package com.datecs.lineaservice;

import com.datecs.linea.LineaPro;

/**
 * Interface definition for a callback to be invoked when Linea connection state is changed.
 */
public interface LineaConnection {
    /**
     * Called when establish connection with Linea device.
     * @param lineaPro instance to Linea device.
     */
    void onLineaConnected(LineaPro lineaPro);

    /**
     * Called when close connection with Linea device.
     * @param lineaPro instance to Linea device.
     */
    void onLineaDisconnected(LineaPro lineaPro);

    /**
     *  Called when debug message is delivered from service.
     * @param message the text message.
     */
    void onLineaDebug(String message);

}
