package bg.datecs.drawerdemo;

import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.widget.Toast;

import com.datecs.drawer.Drawer;

import java.io.IOException;

import bg.datecs.drawerdemo.connectivity.BluetoothConnector;
import bg.datecs.drawerdemo.connectivity.BluetoothSppConnector;
import bg.datecs.drawerdemo.fragment.BluetoothFragment;
import bg.datecs.drawerdemo.fragment.CommandFragment;

public class MainActivity extends AppCompatActivity implements BluetoothFragment.ClickListener,
        Drawer.ConnectionListener, Drawer.StateListener, CommandFragment.OnFragmentInteractionListener {

    private Drawer mDrawer;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Create a new Fragment to be placed in the activity layout
        BluetoothFragment fragment = new BluetoothFragment();

        // Add the fragment to the 'fragment_container' FrameLayout
        getSupportFragmentManager().beginTransaction()
                .add(R.id.fragment_container, fragment).commit();

        Drawer.setDebug(true);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mDrawer != null) {
            try {
                mDrawer.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onClick(BluetoothDevice device) {
        BluetoothConnector connector = new BluetoothSppConnector(this, BluetoothAdapter
                .getDefaultAdapter(), device);

        new BluetoothTask().execute(connector);
    }

    @Override
    public void onDisconnect() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                showToast("Connection is closed");
                finish();
            }
        });
    }

    @Override
    public void onStateChanged(final boolean opened) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (opened) {
                    showToast("Drawer is opened");
                } else {
                    showToast("Drawer is closed");
                }
            }
        });
    }

    @Override
    public void onOpenDrawer() {
        try {
            mDrawer.open();
        } catch (IOException e) {
            e.printStackTrace();
            showToast(e.getMessage());
        }
    }

    @Override
    public void onGetState() {
        try {
            boolean b = mDrawer.getState();

            if (b) {
                showToast("Drawer is opened");
            } else {
                showToast("Drawer is closed");
            }
        } catch (IOException e) {
            e.printStackTrace();
            showToast(e.getMessage());
        }
    }

    private void showToast(final String message) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(MainActivity.this, message, Toast.LENGTH_SHORT).show();
            }
        });
    }

    private class BluetoothTask extends AsyncTask<BluetoothConnector, Void, Boolean> {

        private ProgressDialog mProgressDialog;

        @Override
        protected void onPreExecute() {
            mProgressDialog = new ProgressDialog(MainActivity.this);
            mProgressDialog.setCancelable(false);
            mProgressDialog.setMessage("Please, wait...");
            mProgressDialog.show();

        }

        @Override
        protected Boolean doInBackground(BluetoothConnector... bluetoothConnectors) {
            try {
                bluetoothConnectors[0].connect();

                mDrawer = new Drawer(bluetoothConnectors[0].getInputStream(),
                        bluetoothConnectors[0].getOutputStream());
                mDrawer.setConnectionListener(MainActivity.this);
                mDrawer.setStateListener(MainActivity.this);
            } catch (final IOException e) {
                e.printStackTrace();
                showToast(e.getMessage());
                return false;
            }

            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            mProgressDialog.dismiss();

            if (result) {
                CommandFragment fragment = new CommandFragment();
                getSupportFragmentManager().beginTransaction()
                        .replace(R.id.fragment_container, fragment).commit();
            }
        }
    }
}
