/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdEJournal;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.datamatrix.DataMatrixWriter;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.EAN8Writer;
import com.google.zxing.oned.ITFWriter;
import com.google.zxing.pdf417.PDF417Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ReceiptConverterAB {
    private int REC_WIDTH = 1;
    private int QRsize = 120;
    private int barcodeHeight = 100;
    private int barcodeWidth = 300;
    private String outImageFormat = "png";
    private int regularFontSize = 15;
    private int boldTextFontSize = 17;
    private String textFont = "Courier New";
    private Insets receiptMargin = new Insets(3, 9, 3, 9);
    private static int barcodeTextFontSize = 17;
    private static BarcodeFormat barcodeFormat = BarcodeFormat.CODE_128;
    private final int receiptWidth = 1;
    private boolean fPrintBarcodeData;
    protected cmdEJournal cmd = new cmdEJournal();
    private static OnConvertCompletedListener mListener;

    public void setfPrintBarcodeData(boolean fPrintBarcodeData) {
        this.fPrintBarcodeData = fPrintBarcodeData;
    }

    public void setQRsize(int QRsize) {
        this.QRsize = QRsize;
    }

    public void setBarcodeHeight(int barcodeHeight) {
        this.barcodeHeight = barcodeHeight;
    }

    public void setBarcodeWidth(int barcodeWidth) {
        this.barcodeWidth = barcodeWidth;
    }

    public void setOutImageFormat(String outImageFormat) {
        this.outImageFormat = outImageFormat;
    }

    public void setRegularFontSize(int regularFontSize) {
        this.regularFontSize = regularFontSize;
    }

    public void setBoldTextFontSize(int boldTextFontSize) {
        this.boldTextFontSize = boldTextFontSize;
    }

    public void setTextFont(String textFont) {
        this.textFont = textFont;
    }

    public void setReceiptMargin(Insets receiptMargin) {
        this.receiptMargin = receiptMargin;
    }

    public static void setBarcodeTextFontSize(int barcodeTextFontSize) {
        ReceiptConverterAB.barcodeTextFontSize = barcodeTextFontSize;
    }

    public static void setBarcodeFormat(BarcodeFormat barcodeFormat) {
        ReceiptConverterAB.barcodeFormat = barcodeFormat;
    }

    public void registerConvertCompletedListener(OnConvertCompletedListener mListener) {
        ReceiptConverterAB.mListener = mListener;
    }

    private JLabel createIconLabel(ImageIcon imageIcon, String text, int fontSize) {
        JLabel label1 = new JLabel();
        label1.setFont(new Font(this.textFont, 1, fontSize));
        label1.setText(text);
        label1.setIconTextGap(10);
        label1.setIcon(imageIcon);
        label1.setHorizontalAlignment(0);
        label1.setVerticalAlignment(0);
        return label1;
    }

    private void addStylesToDocument(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(regular, this.textFont);
        StyleConstants.setBold(regular, false);
        StyleConstants.setFontSize(regular, this.regularFontSize);
        Style bold = doc.addStyle("bold", regular);
        StyleConstants.setBold(bold, true);
        StyleConstants.setFontSize(bold, this.boldTextFontSize);
    }

    public void ConvertEJReceiptA(final String deviceFM, final String docNumber, final BufferedImage logoImg, final String imageFileName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block18: {
                    try {
                        String docFound = ReceiptConverterAB.this.cmd.readEjDocumentsByNumbersRange(docNumber, docNumber, cmdEJournal.EjDocTypePrn.all_types);
                        if (docFound == null || docFound == "") {
                            throw new Exception("DOCUMENT " + docNumber + " NOT FOUND IN EJ...");
                        }
                        String[] docLines = docFound.split("\n");
                        StyleContext context = new StyleContext();
                        final DefaultStyledDocument styledDocument = new DefaultStyledDocument(context);
                        ReceiptConverterAB.this.addStylesToDocument(styledDocument);
                        ReceiptConverterAB.this.REC_WIDTH = docLines[0].length() * ReceiptConverterAB.this.boldTextFontSize > ReceiptConverterAB.this.regularFontSize ? ReceiptConverterAB.this.boldTextFontSize : ReceiptConverterAB.this.regularFontSize;
                        if (logoImg != null) {
                            BufferedImage logo = logoImg;
                            if (logoImg.getWidth() > ReceiptConverterAB.this.REC_WIDTH) {
                                logo = ReceiptConverterAB.resizeLogo(logoImg, ReceiptConverterAB.this.REC_WIDTH, logoImg.getHeight());
                            }
                            Style logoStyle = styledDocument.addStyle("logo", null);
                            StyleConstants.setAlignment(logoStyle, 1);
                            styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, logoStyle, false);
                            StyleConstants.setComponent(logoStyle, ReceiptConverterAB.this.createIconLabel(new ImageIcon(logo), "", ReceiptConverterAB.this.boldTextFontSize));
                            styledDocument.insertString(0, "", logoStyle);
                            styledDocument.insertString(styledDocument.getLength(), "\n", logoStyle);
                        }
                        for (int i = 0; i < docLines.length; ++i) {
                            String s = docLines[i];
                            Style style = styledDocument.getStyle("regular");
                            StyleConstants.setAlignment(style, 0);
                            styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                            if (s.contains("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd")) {
                                style = styledDocument.getStyle("bold");
                                StyleConstants.setAlignment(style, 0);
                                styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                            } else if (s.matches("^( .)+$")) {
                                style = styledDocument.getStyle("bold");
                                if (s.contains(" \ufffd \ufffd \ufffd \ufffd")) {
                                    s = s.replaceAll("( ){2}", "^").replace(" ", "").replace("^", "   ");
                                    StyleConstants.setAlignment(style, 0);
                                    styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                                } else {
                                    s = s.replace(" ", "R").replaceAll("(R){2,}", " ").replace("R", "");
                                    StyleConstants.setAlignment(style, 1);
                                    styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                                    s = ReceiptConverterAB.this.trimStart(s);
                                }
                                if (s.contains("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd")) {
                                    Style styleMap = styledDocument.addStyle("styleMap", null);
                                    StyleConstants.setAlignment(styleMap, 1);
                                    styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, styleMap, false);
                                    StyleConstants.setComponent(styleMap, ReceiptConverterAB.this.createIconLabel(new ImageIcon(this.getClass().getClassLoader().getResource("res/bgmap24x16.png")), s.trim(), ReceiptConverterAB.this.boldTextFontSize));
                                    styledDocument.insertString(styledDocument.getLength(), "dummy", styleMap);
                                    styledDocument.insertString(styledDocument.getLength(), "\n", style);
                                    continue;
                                }
                            } else {
                                if (s.contains("\ufffd\ufffd [")) {
                                    if ((s = s.replace(" ", "")).startsWith("\ufffd\ufffd[" + deviceFM)) {
                                        s = s.replace(" ", "");
                                        String QRdata = s.substring(3, s.length() - 1);
                                        Style styleQR = styledDocument.addStyle("styleQR", null);
                                        StyleConstants.setAlignment(styleQR, 1);
                                        styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, styleQR, false);
                                        StyleConstants.setComponent(styleQR, ReceiptConverterAB.this.createIconLabel(new ImageIcon(ReceiptConverterAB.this.createBarcodeImage(QRdata, ReceiptConverterAB.this.QRsize, ReceiptConverterAB.this.QRsize, BarcodeFormat.QR_CODE)), "", ReceiptConverterAB.this.boldTextFontSize));
                                        styledDocument.insertString(styledDocument.getLength(), "dummy", styleQR);
                                    } else {
                                        String barcodeData = s.substring(3, s.length() - 1);
                                        Style bcStyle = styledDocument.addStyle("barcode", null);
                                        StyleConstants.setAlignment(bcStyle, 1);
                                        styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, bcStyle, false);
                                        StyleConstants.setComponent(bcStyle, ReceiptConverterAB.this.createIconLabel(new ImageIcon(ReceiptConverterAB.this.createBarcodeImage(barcodeData, ReceiptConverterAB.this.barcodeWidth, ReceiptConverterAB.this.barcodeHeight, barcodeFormat)), "", ReceiptConverterAB.this.boldTextFontSize));
                                        styledDocument.insertString(styledDocument.getLength(), "dummy", bcStyle);
                                        if (ReceiptConverterAB.this.fPrintBarcodeData) {
                                            styledDocument.insertString(styledDocument.getLength(), "\n" + barcodeData, style);
                                        }
                                    }
                                    styledDocument.insertString(styledDocument.getLength(), "\n", style);
                                    continue;
                                }
                                if (s.trim().startsWith(new cmdInfo().GetDeviceSerialNumber())) {
                                    Style logoIcon = styledDocument.addStyle("logoIcon", null);
                                    StyleConstants.setAlignment(logoIcon, 0);
                                    styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, logoIcon, false);
                                    StyleConstants.setComponent(logoIcon, ReceiptConverterAB.this.createIconLabel(new ImageIcon(this.getClass().getClassLoader().getResource("res/datecs_16x16.png")), s.trim(), ReceiptConverterAB.this.boldTextFontSize));
                                    styledDocument.insertString(styledDocument.getLength(), "dummy", logoIcon);
                                    styledDocument.insertString(styledDocument.getLength(), "\n", style);
                                    continue;
                                }
                            }
                            styledDocument.insertString(styledDocument.getLength(), s + "\n", style);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                block3: {
                                    JTextPane textPane = new JTextPane(styledDocument);
                                    textPane.setEditable(false);
                                    textPane.setMargin(ReceiptConverterAB.this.receiptMargin);
                                    JScrollPane scrollPane = new JScrollPane(textPane);
                                    JFrame frame = new JFrame("View");
                                    frame.add((Component)scrollPane, "Center");
                                    frame.setSize(ReceiptConverterAB.this.REC_WIDTH, 150);
                                    frame.setVisible(true);
                                    BufferedImage image = new BufferedImage(textPane.getWidth(), textPane.getHeight(), 10);
                                    frame.setVisible(false);
                                    Graphics2D g = image.createGraphics();
                                    textPane.printAll(g);
                                    g.dispose();
                                    try {
                                        ImageIO.write((RenderedImage)image, "png", new File(imageFileName + ".png"));
                                        if (mListener != null) {
                                            mListener.onResultEvent(image, null);
                                        }
                                    }
                                    catch (IOException exp) {
                                        exp.printStackTrace();
                                        if (mListener == null) break block3;
                                        mListener.onResultEvent(null, exp.getMessage());
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (mListener == null) break block18;
                        mListener.onResultEvent(null, e.getMessage());
                    }
                }
            }
        }).start();
    }

    private String trimStart(String s) {
        if (s.startsWith(" ")) {
            return this.trimStart(s.replaceFirst(" ", ""));
        }
        return s;
    }

    public void ConvertEJReceiptB(final String deviceFM, String recNumber, final BufferedImage logoImg, final String imageFileName) {
        final Integer docNumber = Integer.valueOf(recNumber);
        new Thread(new Runnable(){

            @Override
            public void run() {
                String recAmount = "0.00";
                try {
                    DocFoundInfo docFoundInfo = ReceiptConverterAB.this.SetDocumentToRead(docNumber, EjDocType.all);
                    if (docFoundInfo == null) {
                        throw new Exception("DOCUMENT " + docNumber + " NOT FOUND IN EJ...");
                    }
                    boolean isQRCodeRec = docFoundInfo.getType() == EjDocType.fiscalSaleRec || docFoundInfo.getType() == EjDocType.invoiceRec || docFoundInfo.getType() == EjDocType.stornoRec || docFoundInfo.getType() == EjDocType.creditNoteRec;
                    String[] readDocsList = new String[]{ReceiptConverterAB.this.ReadEjDocument()};
                    String[] docLines = readDocsList[0].split("\n\r");
                    StyleContext context = new StyleContext();
                    final DefaultStyledDocument styledDocument = new DefaultStyledDocument(context);
                    ReceiptConverterAB.this.addStylesToDocument(styledDocument);
                    ReceiptConverterAB.this.REC_WIDTH = docLines[0].length() / 2 * ReceiptConverterAB.this.boldTextFontSize;
                    if (logoImg != null) {
                        BufferedImage logo = logoImg;
                        if (logoImg.getWidth() > ReceiptConverterAB.this.REC_WIDTH) {
                            logo = ReceiptConverterAB.resizeLogo(logoImg, ReceiptConverterAB.this.REC_WIDTH, logoImg.getHeight());
                        }
                        Style logoStyle = styledDocument.addStyle("logo", null);
                        StyleConstants.setAlignment(logoStyle, 1);
                        styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, logoStyle, false);
                        StyleConstants.setComponent(logoStyle, ReceiptConverterAB.this.createIconLabel(new ImageIcon(logo), "", 0));
                        styledDocument.insertString(0, "", logoStyle);
                        styledDocument.insertString(styledDocument.getLength(), "\n", logoStyle);
                    }
                    for (int i = 0; i < docLines.length; ++i) {
                        String s = docLines[i];
                        Style style = styledDocument.getStyle("regular");
                        StyleConstants.setAlignment(style, 0);
                        styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                        if (s.trim().matches("^.?[\\^].+$")) {
                            int column = s.length();
                            style = styledDocument.getStyle("bold");
                            StyleConstants.setAlignment(style, 1);
                            styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                            s = s.trim().replace("^", "");
                            StyleConstants.setFontSize(style, ReceiptConverterAB.this.boldTextFontSize);
                            if (s.contains("\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd")) {
                                recAmount = ReceiptConverterAB.this.getRecAmount(s);
                                StyleConstants.setAlignment(style, 0);
                                styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                                s = ReceiptConverterAB.alignRight("\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd", recAmount, column - recAmount.length());
                            }
                            if (s.contains("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd")) {
                                Style styleMap = styledDocument.addStyle("styleMap", null);
                                StyleConstants.setAlignment(styleMap, 1);
                                styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, styleMap, false);
                                StyleConstants.setComponent(styleMap, ReceiptConverterAB.this.createIconLabel(new ImageIcon(this.getClass().getClassLoader().getResource("res/bgmap24x16.png")), s, ReceiptConverterAB.this.boldTextFontSize));
                                styledDocument.insertString(styledDocument.getLength(), "dummy", styleMap);
                                styledDocument.insertString(styledDocument.getLength(), "\n", style);
                                continue;
                            }
                        } else if (s.startsWith(String.format("%07d", docNumber)) && isQRCodeRec) {
                            String QRdata = deviceFM + "*" + ReceiptConverterAB.this.convertDate(docFoundInfo.getDate()) + "*" + recAmount;
                            styledDocument.insertString(styledDocument.getLength(), s + "\n", style);
                            Style styleQR = styledDocument.addStyle("styleQR", null);
                            StyleConstants.setAlignment(styleQR, 1);
                            styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, styleQR, false);
                            StyleConstants.setComponent(styleQR, ReceiptConverterAB.this.createIconLabel(new ImageIcon(ReceiptConverterAB.createQRCodeImage(QRdata, ReceiptConverterAB.this.QRsize)), "", ReceiptConverterAB.this.boldTextFontSize));
                            styledDocument.insertString(styledDocument.getLength(), "dummy", styleQR);
                            styledDocument.insertString(styledDocument.getLength(), "\n", style);
                            continue;
                        }
                        styledDocument.insertString(styledDocument.getLength(), s + "\n", style);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                JTextPane textPane = new JTextPane(styledDocument);
                                textPane.setEditable(false);
                                JScrollPane scrollPane = new JScrollPane(textPane);
                                JFrame frame = new JFrame("View");
                                frame.add((Component)scrollPane, "Center");
                                frame.setSize(ReceiptConverterAB.this.REC_WIDTH, 150);
                                frame.setVisible(true);
                                BufferedImage image = new BufferedImage(textPane.getWidth(), textPane.getHeight(), 1);
                                frame.setVisible(false);
                                Graphics2D g = image.createGraphics();
                                textPane.printAll(g);
                                g.dispose();
                                try {
                                    ImageIO.write((RenderedImage)image, ReceiptConverterAB.this.outImageFormat, new File(imageFileName + "." + ReceiptConverterAB.this.outImageFormat));
                                    if (mListener != null) {
                                        mListener.onResultEvent(image, null);
                                    }
                                }
                                catch (IOException exp) {
                                    exp.printStackTrace();
                                    if (mListener == null) break block3;
                                    mListener.onResultEvent(null, exp.getMessage());
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (mListener != null) {
                        mListener.onResultEvent(null, e.getMessage());
                    }
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private String convertDate(String ejDate) throws Exception {
        if (!ejDate.matches("^[0-9]{2}-[0-9]{2}-[0-9]{2,4} \\d{2}:\\d{2}:\\d{2}( DST)?$")) {
            throw new Exception("INVALID DATE TIME FORMAT...");
        }
        Date date = new SimpleDateFormat("dd-MM-yy HH:mm:ss").parse(ejDate);
        SimpleDateFormat naredba18DateFormat = new SimpleDateFormat("yyyy-MM-dd*HH:mm:ss");
        return naredba18DateFormat.format(date);
    }

    private String getRecAmount(String s) {
        if (s.contains("\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd")) {
            String sAmount = s.split("\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd")[1];
            return String.format("%.2f", Double.valueOf(sAmount));
        }
        return "0.00";
    }

    public void setBarcodeFormat(BCType barcodeFormat) throws Exception {
        switch (barcodeFormat) {
            case EAN8: {
                ReceiptConverterAB.barcodeFormat = BarcodeFormat.EAN_8;
                break;
            }
            case EAN13: {
                ReceiptConverterAB.barcodeFormat = BarcodeFormat.EAN_13;
                break;
            }
            case CODE128: {
                ReceiptConverterAB.barcodeFormat = BarcodeFormat.CODE_128;
                break;
            }
            case ITF: {
                ReceiptConverterAB.barcodeFormat = BarcodeFormat.ITF;
                break;
            }
            case PDF417: {
                ReceiptConverterAB.barcodeFormat = BarcodeFormat.PDF_417;
                break;
            }
            case QRCODE: {
                ReceiptConverterAB.barcodeFormat = BarcodeFormat.QR_CODE;
                break;
            }
            case DATAMATRIX: {
                ReceiptConverterAB.barcodeFormat = BarcodeFormat.DATA_MATRIX;
                break;
            }
            default: {
                throw new Exception("Barcode not supported:" + (Object)((Object)barcodeFormat));
            }
        }
    }

    private BufferedImage createBarcodeImage(String barcodeMessage, int width, int height, BarcodeFormat bcFormat) throws Exception {
        BitMatrix bitMatrix;
        switch (bcFormat) {
            case CODE_128: {
                if (!barcodeMessage.matches("^.{22,42}$")) {
                    throw new Exception("Barcode data not matches - CODE_128");
                }
                Code128Writer code128Writer = new Code128Writer();
                bitMatrix = code128Writer.encode(barcodeMessage, BarcodeFormat.CODE_128, width, height, null);
                break;
            }
            case EAN_13: {
                if (!barcodeMessage.matches("^\\d{12}$")) {
                    throw new Exception("Barcode data not matches - EAN_13");
                }
                EAN13Writer ean13Writer = new EAN13Writer();
                bitMatrix = ean13Writer.encode(barcodeMessage, BarcodeFormat.EAN_13, width, height, null);
                break;
            }
            case EAN_8: {
                if (!barcodeMessage.matches("^\\d{7}$")) {
                    throw new Exception("Barcode data not matches - EAN_8");
                }
                EAN8Writer ean8Writer = new EAN8Writer();
                bitMatrix = ean8Writer.encode(barcodeMessage, BarcodeFormat.EAN_8, width, height, null);
                break;
            }
            case ITF: {
                if (!barcodeMessage.matches("^\\d+$")) {
                    throw new Exception("Barcode data not matches - ITF");
                }
                ITFWriter itfWriter = new ITFWriter();
                bitMatrix = itfWriter.encode(barcodeMessage, BarcodeFormat.ITF, width, height, null);
                break;
            }
            case PDF_417: {
                if (!barcodeMessage.matches("^.{1,140}$")) {
                    throw new Exception("Barcode data not matches - PDF_417");
                }
                PDF417Writer pdf417Writer = new PDF417Writer();
                bitMatrix = pdf417Writer.encode(barcodeMessage, BarcodeFormat.PDF_417, width, height, null);
                break;
            }
            case QR_CODE: {
                if (!barcodeMessage.matches("^.{1,140}$")) {
                    throw new Exception("Barcode data not matches - QR_CODE");
                }
                Hashtable<EncodeHintType, Enum> qrMap = new Hashtable<EncodeHintType, Enum>();
                qrMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
                qrMap.put(EncodeHintType.CHARACTER_SET, CharacterSetECI.ISO8859_5);
                QRCodeWriter qrCodeWriter = new QRCodeWriter();
                bitMatrix = qrCodeWriter.encode(barcodeMessage, BarcodeFormat.QR_CODE, width, width, qrMap);
                break;
            }
            case DATA_MATRIX: {
                if (!barcodeMessage.matches("^.{1,140}$")) {
                    throw new Exception("Barcode data not matches - DATA_MATRIX");
                }
                EnumMap<EncodeHintType, SymbolShapeHint> hints = new EnumMap<EncodeHintType, SymbolShapeHint>(EncodeHintType.class);
                hints.put(EncodeHintType.DATA_MATRIX_SHAPE, SymbolShapeHint.FORCE_SQUARE);
                DataMatrixWriter dataMatrixWriter = new DataMatrixWriter();
                bitMatrix = dataMatrixWriter.encode(barcodeMessage, BarcodeFormat.DATA_MATRIX, width, width, hints);
                break;
            }
            default: {
                throw new Exception("UNSUPPORTED BARCODE FORMAT...");
            }
        }
        int matrixWidth = bitMatrix.getWidth();
        int matrixHeight = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(matrixWidth, matrixHeight, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, matrixWidth, matrixWidth);
        graphics.setColor(Color.BLACK);
        for (int i = 0; i < matrixWidth; ++i) {
            for (int j = 0; j < matrixHeight; ++j) {
                if (!bitMatrix.get(i, j)) continue;
                graphics.fillRect(i, j, 1, 1);
            }
        }
        return image;
    }

    private static BufferedImage createQRCodeImage(String qrCodeString, int size) throws WriterException {
        Hashtable<EncodeHintType, Enum> hintMap = new Hashtable<EncodeHintType, Enum>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hintMap.put(EncodeHintType.CHARACTER_SET, CharacterSetECI.ISO8859_5);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix byteMatrix = qrCodeWriter.encode(qrCodeString, BarcodeFormat.QR_CODE, size, size, hintMap);
        int matrixWidth = byteMatrix.getWidth();
        BufferedImage image = new BufferedImage(matrixWidth, matrixWidth, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, matrixWidth, matrixWidth);
        graphics.setColor(Color.BLACK);
        for (int i = 0; i < matrixWidth; ++i) {
            for (int j = 0; j < matrixWidth; ++j) {
                if (!byteMatrix.get(i, j)) continue;
                graphics.fillRect(i, j, 1, 1);
            }
        }
        return image;
    }

    private static String alignRight(String strLeft, String strRight, int column) {
        if (column < strLeft.length() + strRight.length()) {
            column = strLeft.length() + strRight.length();
        }
        return String.format("%s%" + (column - strLeft.length()) + "s", strLeft, strRight + "\n");
    }

    private static BufferedImage resizeLogo(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    private DocFoundInfo SetDocumentToRead(int DocNum, EjDocType ejDocType) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = DatecsFiscalDevice.getConnectedECRV1().command125Variant0Version0(String.valueOf(DocNum), String.valueOf(ejDocType.ordinal()));
        if (R.get("ErrCode").equals("P")) {
            return new DocFoundInfo(R.getInt("DocNumber"), R.get("Date"), EjDocType.values()[R.getInt("Type")], R.getInt("Znumber"));
        }
        return null;
    }

    private String ReadEjDocument() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        StringBuilder res = new StringBuilder();
        while (true) {
            R = DatecsFiscalDevice.getConnectedECRV1().command125Variant1Version0();
            switch (R.get("ErrCode")) {
                case "P": {
                    res.append(R.get("Text")).append("\n\r");
                    break;
                }
                case "F": {
                    return res.toString();
                }
            }
        }
    }

    private static class DocFoundInfo {
        private int DocNumber;
        private String Date;
        private EjDocType type;
        private int Znumber;

        public DocFoundInfo(int docNumber, String date, EjDocType type, int znumber) {
            this.DocNumber = docNumber;
            this.Date = date;
            this.type = type;
            this.Znumber = znumber;
        }

        public int getDocNumber() {
            return this.DocNumber;
        }

        public void setDocNumber(int docNumber) {
            this.DocNumber = docNumber;
        }

        public String getDate() {
            return this.Date;
        }

        public void setDate(String date) {
            this.Date = date;
        }

        public EjDocType getType() {
            return this.type;
        }

        public void setType(EjDocType type) {
            this.type = type;
        }

        public int getZnumber() {
            return this.Znumber;
        }

        public void setZnumber(int znumber) {
            this.Znumber = znumber;
        }
    }

    private static enum EjDocType {
        all,
        fiscalSaleRec,
        reportZ,
        cahsInRec,
        cahsOutRec,
        reportX,
        nonFiscalRec,
        invoiceRec,
        stornoRec,
        creditNoteRec;

    }

    public static enum BCType {
        EAN8,
        EAN13,
        CODE128,
        ITF,
        PDF417,
        QRCODE,
        DATAMATRIX;

    }

    public static interface OnConvertCompletedListener {
        public void onResultEvent(BufferedImage var1, String var2);
    }
}

