/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV2;

import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;
import com.datecs.util.EGNValidator;
import com.datecs.util.EIKValidator;
import com.datecs.util.RegExpr;
import java.util.ArrayList;
import java.util.List;

public class cmdReceipt
extends DatecsFiscalDevice {
    protected String receiptNumber;

    public boolean isStornoReceiptOpen() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdReceipt.getConnectedModelV2().command103Variant0Version0();
        }
        cmdReceipt.checkErrorCode(R);
        return R.get("fStorno ").equals(1);
    }

    public void printFreeText(String text, boolean Bold, boolean Italic, boolean DoubleH, boolean Underline, AlignmentType alignment) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdReceipt.getConnectedModelV2().command54Variant1Version0(text, Bold ? "1" : "0", Italic ? "1" : "0", DoubleH ? "1" : "0", Underline ? "1" : "0", String.valueOf(alignment.ordinal()));
        }
        cmdReceipt.checkErrorCode(R);
    }

    public void paperFeed(int linesToFeed) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        while (linesToFeed > cmdReceipt.getConnectedModelV2().getMaxLinesToFeed()) {
            if (this.isConnectedDeviceV2()) {
                R = cmdReceipt.getConnectedModelV2().command44Variant0Version0(String.valueOf(linesToFeed));
            }
            cmdReceipt.checkErrorCode(R);
            linesToFeed -= cmdReceipt.getConnectedModelV2().getMaxLinesToFeed().intValue();
        }
        if (this.isConnectedDeviceV2()) {
            R = cmdReceipt.getConnectedModelV2().command44Variant0Version0(String.valueOf(linesToFeed));
        }
        cmdReceipt.checkErrorCode(R);
    }

    public void paperCutting() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdReceipt.getConnectedModelV2().command46Variant0Version0();
        }
        cmdReceipt.checkErrorCode(R);
    }

    public Double[] cashInCashOut(Double dAmount, boolean foreignCurrency) throws Exception {
        Double[] outData = new Double[3];
        if (this.isConnectedDeviceV2()) {
            String typeOperation = "0";
            if (dAmount > 0.0) {
                typeOperation = "0";
                if (foreignCurrency) {
                    typeOperation = "2";
                }
            }
            if (dAmount < 0.0) {
                typeOperation = "1";
                if (foreignCurrency) {
                    typeOperation = "3";
                }
                dAmount = Math.abs(dAmount);
            }
            FiscalResponse R = new FiscalResponse(0);
            R = cmdReceipt.getConnectedModelV2().command70Variant0Version0(typeOperation, dAmount.toString());
            cmdReceipt.checkErrorCode(R);
            outData[0] = R.getDouble("cashSum");
            outData[1] = R.getDouble("cashIn");
            outData[2] = R.getDouble("cashOut");
        }
        return outData;
    }

    public void printBarcode(BarcdeType bcType, String bcData, int bcQRSize) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = bcType == BarcdeType.QRcode || bcType == BarcdeType.PDF417trunc || bcType == BarcdeType.PDF417normal ? cmdReceipt.getConnectedModelV2().command84Variant1Version0(bcData, String.valueOf(bcQRSize)) : cmdReceipt.getConnectedModelV2().command84Variant0Version0(String.valueOf(bcType.ordinal() + 1), bcData, "");
        }
        cmdReceipt.checkErrorCode(R);
    }

    public void drawerKickOut() throws Exception {
    }

    public static class FiscalTransaction
    extends cmdReceipt {
        private Boolean IsOpen;
        private int RecNumber;
        private int Items;
        private String Amount;
        private String Payed;
        private ReceiptType receiptType;

        public ReceiptType getReceiptType() {
            return this.receiptType;
        }

        public FiscalTransaction() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalTransaction.getConnectedModelV2().command76Variant0Version0();
            }
            FiscalTransaction.checkErrorCode(R);
            int openRecType = R.getInt("isOpen");
            this.IsOpen = openRecType > 0;
            this.receiptType = ReceiptType.values()[openRecType];
            this.RecNumber = R.getInt("number");
            this.Items = R.getInt("items");
            this.Amount = R.get("amount");
            this.Payed = R.get("payed");
        }

        public boolean isOpen() {
            return this.IsOpen;
        }

        public int getNumber() {
            return this.RecNumber;
        }

        public String getNumberAsString() {
            return String.valueOf(this.RecNumber);
        }

        public Double getAmount() {
            return Double.valueOf(this.Amount);
        }

        public String getAmountAsString() {
            return this.Amount;
        }

        public Double getPaid() {
            return Double.valueOf(this.Payed);
        }

        public String getPaidAsString() {
            return this.Payed;
        }

        public Double getNotPaid() {
            return this.getAmount() - this.getPaid();
        }

        public static enum ReceiptType {
            ReceiptIsClosed,
            NormalReceipt,
            StornoOperatorMistake,
            StornoRrefund,
            StornoTaxReduction,
            NonFiscal;

        }
    }

    public static enum BarcdeType {
        EAN8,
        EAN13,
        Code128,
        QRcode,
        Interleave,
        PDF417trunc,
        PDF417normal;

    }

    public static class NonFiscalReceipt
    extends cmdReceipt {
        public boolean isFontSetupSupport() {
            return this.isConnectedDeviceV2();
        }

        public int openNonFiscalReceipt() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = NonFiscalReceipt.getConnectedModelV2().command38Variant0Version0();
            }
            NonFiscalReceipt.checkErrorCode(R);
            return Integer.valueOf(R.get("slipNumber"));
        }

        public int closeNonFiscalReceipt() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = NonFiscalReceipt.getConnectedModelV2().command39Variant0Version0();
            }
            NonFiscalReceipt.checkErrorCode(R);
            return Integer.valueOf(R.get("slipNumber"));
        }

        public boolean isOpen() {
            boolean bitResult = true;
            if (this.isConnectedDeviceV2()) {
                bitResult = NonFiscalReceipt.getConnectedModelV2().getStatusBitBol(2, 5);
            }
            return bitResult;
        }

        public void printNonFiscalText(String text) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = NonFiscalReceipt.getConnectedModelV2().command42Variant0Version0(text);
            }
            NonFiscalReceipt.checkErrorCode(R);
        }

        public void printNonFiscalText(String text, boolean Bold, boolean Italic, boolean DoubleH, boolean Underline, AlignmentType alignment) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = NonFiscalReceipt.getConnectedModelV2().command42Variant1Version0(text, Bold ? "1" : "0", Italic ? "1" : "0", DoubleH ? "1" : "0", Underline ? "1" : "0", String.valueOf(alignment.ordinal()));
            }
            NonFiscalReceipt.checkErrorCode(R);
        }
    }

    public static class FiscalSale
    extends cmdReceipt {
        String PluName = "";
        String TaxCd = "";
        String Price = "";
        String Quantity = "";
        static DiscountType DiscountType = DiscountType.noDiscount;
        String DiscountValue = "";
        String Department = "0";
        String Unit = "";

        public FiscalSale() {
        }

        public FiscalSale(String pluName, String taxCd, String price, String quantity, String department) {
            this.PluName = pluName;
            this.TaxCd = taxCd;
            this.Price = price;
            this.Quantity = quantity;
            this.Department = department;
        }

        public FiscalSale(String pluName, String taxCd, String price, String quantity, DiscountType discountType, String discountValue, String department, String unit) {
            this.PluName = pluName;
            this.TaxCd = taxCd;
            this.Price = price;
            this.Quantity = quantity;
            DiscountType = discountType;
            this.DiscountValue = discountValue;
            this.Department = department;
            this.Unit = unit;
        }

        public int addByPLU(String pluCode, String quantity, String price, DiscountType discountType, String discountValue) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command58Variant0Version0(pluCode, quantity, price, String.valueOf(discountType.ordinal()), discountValue);
            }
            FiscalSale.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return Integer.valueOf(this.receiptNumber);
        }

        public FiscalSale addWithUnit() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command49Variant1Version0(this.PluName, this.TaxCd, this.Price, this.Quantity, String.valueOf(DiscountType.ordinal()), this.DiscountValue, this.Department.equals("") ? "0" : this.Department, this.Unit);
            }
            FiscalSale.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return this;
        }

        public FiscalSale(String pluName, String taxCd, String price) {
            this.PluName = pluName;
            this.TaxCd = taxCd;
            this.Price = price;
        }

        public FiscalSale add() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command49Variant0Version0(this.PluName, this.TaxCd, this.Price, this.Quantity, String.valueOf(DiscountType.ordinal()), this.DiscountValue, this.Department.equals("") ? "0" : this.Department);
            }
            FiscalSale.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return this;
        }

        public FiscalSale add(String pluName, String taxCd, String department, String price, String quantity, DiscountType discountType, String discountValue, String unit) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command49Variant1Version0(pluName, taxCd, price, quantity, String.valueOf(discountType.ordinal()), discountValue, department.equals("") ? "0" : department, unit);
            }
            FiscalSale.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return this;
        }

        public FiscalSale add(String pluName, String taxCd, String dept, String price, String qwan, DiscountType discountType, String discValueStr) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command49Variant0Version0(pluName, taxCd, price, qwan, String.valueOf(discountType.ordinal()), discValueStr, dept.equals("") ? "0" : dept);
            }
            FiscalSale.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return this;
        }

        public String readSubtotal(boolean display, DiscountType discountType, String discountValue) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command51Variant0Version0("0", display ? "1" : "0", String.valueOf(discountType.ordinal()), discountValue);
            }
            FiscalSale.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return R.get("subtotal");
        }

        public String printSubtotal(boolean display, DiscountType discountType, String discountValue) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command51Variant0Version0("1", display ? "1" : "0", String.valueOf(discountType.ordinal()), discountValue);
            }
            FiscalSale.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return R.get("subtotal");
        }

        public void saleTotal(PaymentType paymentType, String tenderAmount) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command53Variant0Version0(String.valueOf(paymentType.ordinal()), tenderAmount);
            }
            FiscalSale.checkErrorCode(R);
        }

        public void saleTotalDebitCard(String tenderAmount, TypeOfCardPayment typeOfCardPayment) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command53Variant1Version0(tenderAmount, typeOfCardPayment == TypeOfCardPayment.paymentWithMoney ? "1" : "12");
            }
            FiscalSale.checkErrorCode(R);
        }

        public void saleTotalForeignCurrency(String tenderAmount, TypeOfChange typeOfChange) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalSale.getConnectedModelV2().command53Variant2Version0(tenderAmount, String.valueOf(typeOfChange.ordinal()));
            }
            FiscalSale.checkErrorCode(R);
        }

        public static enum TypeOfChange {
            currentCurrency,
            foreignCurrency;

        }

        public static enum TypeOfCardPayment {
            paymentWithMoney,
            paymentWithPoints;

        }

        public static enum DiscountType {
            noDiscount,
            surchargePercentage,
            discountPercentage,
            surchargeSum,
            discountSum;

        }
    }

    public static class FiscalReceipt
    extends cmdReceipt {
        String OpCode;
        String OpPwd;
        String TillNmb;

        public FiscalReceipt() {
        }

        public FiscalReceipt(String opCode, String opPwd, String tillNmb) {
            this.OpCode = opCode;
            this.OpPwd = opPwd;
            this.TillNmb = tillNmb;
        }

        public FiscalReceipt openFiscalReceipt() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command48Variant0Version0(this.OpCode, this.OpPwd, this.TillNmb, "");
            }
            FiscalReceipt.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return this;
        }

        public int openFiscalReceipt(String opCode, String opPwd, String nSale, String tillNmb, boolean invoice) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command48Variant0Version0(opCode, opPwd, nSale, tillNmb, invoice ? "I" : "");
            }
            FiscalReceipt.checkErrorCode(R);
            this.receiptNumber = R.getString("slipNumber");
            return Integer.valueOf(this.receiptNumber);
        }

        public int openFiscalReceipt(String opCode, String opPwd, String tillNmb, boolean invoice) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command48Variant0Version0(opCode, opPwd, tillNmb, invoice ? "I" : "");
            }
            FiscalReceipt.checkErrorCode(R);
            this.receiptNumber = R.get("slipNumber");
            return Integer.valueOf(this.receiptNumber);
        }

        public int closeFiscalReceipt() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command56Variant0Version0();
            }
            FiscalReceipt.checkErrorCode(R);
            this.receiptNumber = R.getString("slipNumber");
            return Integer.valueOf(this.receiptNumber);
        }

        public int openInvoice() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command48Variant0Version0(this.OpCode, this.OpPwd, this.TillNmb, "I");
            }
            FiscalReceipt.checkErrorCode(R);
            this.receiptNumber = R.getString("slipNumber");
            return Integer.valueOf(this.receiptNumber);
        }

        public int openInvoice(String opCode, String opPwd, String tillNmb) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command48Variant0Version0(opCode, opPwd, tillNmb, "I");
            }
            FiscalReceipt.checkErrorCode(R);
            this.receiptNumber = R.getString("slipNumber");
            return Integer.valueOf(this.receiptNumber);
        }

        public boolean isOpen() {
            boolean bitResult = true;
            if (this.isConnectedDeviceV2()) {
                bitResult = FiscalReceipt.getConnectedModelV2().getStatusBitBol(2, 3);
            }
            return bitResult;
        }

        public boolean cancel() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command60Variant0Version0();
            }
            FiscalReceipt.checkErrorCode(R);
            return R.get("errorCode").equals("0");
        }

        public String getOpCode() {
            return this.OpCode;
        }

        public void setOpCode(String opCode) {
            this.OpCode = opCode;
        }

        public String getOpPwd() {
            return this.OpPwd;
        }

        public void setOpPwd(String opPwd) {
            this.OpPwd = opPwd;
        }

        public String getTillNmb() {
            return this.TillNmb;
        }

        public void setTillNmb(String tillNmb) {
            this.TillNmb = tillNmb;
        }

        public String getAllreceipt() throws Exception {
            cmdInfo info = new cmdInfo();
            return info.GetGlobalNumberOfReceipts();
        }

        public String getReceiptNumber() {
            return this.receiptNumber;
        }

        public String getFiscReceipt() throws Exception {
            cmdInfo info = new cmdInfo();
            return info.GetGlobalNumberOfFiscalReceipts();
        }

        public void printFreeText(String s) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command54Variant0Version0(s);
            }
            FiscalReceipt.checkErrorCode(R);
        }

        public void printSeparatingLine(SeparatingLine separatingLine) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedDeviceV2()) {
                R = FiscalReceipt.getConnectedModelV2().command92Variant0Version0(String.valueOf(separatingLine.ordinal()));
            }
            FiscalReceipt.checkErrorCode(R);
        }

        public static class Storno
        extends FiscalReceipt {
            String OpCode = "";
            String OpPwd = "";
            String TillNmb = "";
            StornoType stornoType = StornoType.operator_error;
            String DocNumber = "";
            String DateTime = "";
            String FMNumber = "";
            Boolean Invoice = false;
            String ToInvoice = "";
            String Reason = "";
            String NSale = "";

            public Storno() {
            }

            public Storno(String opCode, String opPwd, String tillNmb, StornoType stornoType, String docNumber, String dateTime, String fmNumber, boolean invoice, String toInvoice, String reason, String nSale) {
                this.OpCode = opCode;
                this.OpPwd = opPwd;
                this.TillNmb = tillNmb;
                this.stornoType = stornoType;
                this.DocNumber = docNumber;
                this.DateTime = dateTime;
                this.FMNumber = fmNumber;
                this.Invoice = invoice;
                this.ToInvoice = toInvoice;
                this.Reason = reason;
                this.NSale = nSale;
            }

            public void open() throws Exception {
                this.open(this.OpCode, this.OpPwd, this.TillNmb, this.stornoType, this.DocNumber, this.DateTime, this.FMNumber, this.Invoice, this.ToInvoice, this.Reason, this.NSale);
            }

            public Storno(String opCode, String opPwd, String tillNmb, StornoType reasonStorno, String docNumber, String dateTime, String fmNumber) {
                this.OpCode = opCode;
                this.OpPwd = opPwd;
                this.TillNmb = tillNmb;
                this.stornoType = reasonStorno;
                this.DocNumber = docNumber;
                this.DateTime = dateTime;
                this.FMNumber = fmNumber;
            }

            public void open(String opCode, String opPwd, String tillNmb, StornoType reasonStorno, String docNumber, String dateTime, String numberOfFM) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedDeviceV2()) {
                    R = Storno.getConnectedModelV2().command43Variant0Version0(opCode, opPwd, tillNmb, String.valueOf(reasonStorno.ordinal()), docNumber, dateTime, numberOfFM, "", "", "", "");
                }
                Storno.checkErrorCode(R);
            }

            public void open(String opCode, String opPwd, String tillNmb, StornoType reasonStorno, String docNumber, String dateTime, String numberOfFM, boolean invoice, String toInvoice, String reason, String nSale) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedDeviceV2()) {
                    R = Storno.getConnectedModelV2().command43Variant0Version0(opCode, opPwd, tillNmb, String.valueOf(reasonStorno.ordinal()), docNumber, dateTime, numberOfFM, invoice ? "I" : "", toInvoice, reason, nSale);
                }
                Storno.checkErrorCode(R);
            }

            public List<Boolean> validateOpenStorno(String opCode, String opPwd, String tillNmb, StornoType stornoType, String docNumber, String docDateTime, String fiscalMemoryID, String nSale) {
                ArrayList<Boolean> resList = new ArrayList<Boolean>();
                resList.add(opCode.matches(RegExpr._1_30));
                resList.add(opPwd.matches(RegExpr._1to8Digit));
                resList.add(tillNmb.matches(RegExpr._1_99999));
                resList.add(String.valueOf(stornoType.ordinal()).matches(RegExpr._0_2));
                resList.add(docNumber.matches(RegExpr._1_9999999));
                resList.add(docDateTime.matches(RegExpr._DD_MM_YY_HH_MM_SS));
                resList.add(fiscalMemoryID.matches(RegExpr._8Digit));
                if (nSale.length() > 0) {
                    resList.add(nSale.matches(RegExpr._UNP));
                } else {
                    resList.add(true);
                }
                return resList;
            }

            public List<Boolean> validateOpenInvoice(String opCode, String opPwd, String tillNmb, StornoType stornoType, String docNumber, String docDateTime, String fiscalMemoryID, String toInvoice, String docUNP, String stornoReason, String nSale) {
                ArrayList<Boolean> resList = new ArrayList<Boolean>();
                resList.add(opCode.matches(RegExpr._1_30));
                resList.add(opPwd.matches(RegExpr._1to8Digit));
                resList.add(tillNmb.matches(RegExpr._1_99999));
                if (nSale.length() > 0) {
                    resList.add(nSale.matches(RegExpr._UNP));
                } else {
                    resList.add(true);
                }
                resList.add(String.valueOf(stornoType.ordinal()).matches(RegExpr._1_3));
                resList.add(docNumber.matches(RegExpr._1_9999999));
                resList.add(toInvoice.matches(RegExpr._1_9999999));
                resList.add(docDateTime.matches(RegExpr._DD_MM_YY_HH_MM_SS));
                resList.add(fiscalMemoryID.matches(RegExpr._8Digit));
                if (stornoReason.length() > 0) {
                    resList.add(stornoReason.matches(RegExpr._UpTo30Symbol));
                } else {
                    resList.add(true);
                }
                return resList;
            }

            public static enum StornoType {
                operator_error,
                refund,
                taxBaseReduction;

            }
        }

        public static class InvoiceClientInfo
        extends cmdReceipt {
            private TypeTAXN TypeTaxNum;
            private String TAXnum;
            private String VATnum;
            private String Seller;
            private String Receiver;
            private String Buyer;
            private String Address1;
            private String Address2;

            public TypeTAXN getTypeTaxNum() {
                return this.TypeTaxNum;
            }

            public void setTypeTaxNum(TypeTAXN typeTaxNum) {
                this.TypeTaxNum = typeTaxNum;
            }

            public boolean[] isValid() {
                boolean[] res = new boolean[7];
                switch (this.TypeTaxNum) {
                    case EGN: {
                        res[0] = new EGNValidator(this.TAXnum).isValid();
                        break;
                    }
                    case BULSTAT: {
                        res[0] = EIKValidator.isValid(this.TAXnum);
                        break;
                    }
                    case LNCH: {
                        res[0] = this.TAXnum.matches(RegExpr._8_13_Digit);
                        break;
                    }
                    case ServiceNumber: {
                        res[0] = true;
                        break;
                    }
                    default: {
                        res[0] = false;
                    }
                }
                res[1] = this.VATnum.matches(RegExpr._10_14Symbol);
                res[2] = this.Seller.matches(RegExpr._UpTo36Symbol);
                res[3] = this.Receiver.matches(RegExpr._UpTo36Symbol);
                res[4] = this.Buyer.matches(RegExpr._UpTo36Symbol);
                res[5] = this.Address1.matches(RegExpr._UpTo36Symbol);
                res[6] = this.Address2.matches(RegExpr._UpTo36Symbol);
                return res;
            }

            public boolean[] ValidateClientInfo(TypeTAXN typeTAXN, String TAXN, String VATN, String seller, String receiver, String buyer, String address1, String address2) {
                boolean[] res = new boolean[7];
                switch (typeTAXN) {
                    case EGN: {
                        res[0] = new EGNValidator(TAXN).isValid();
                        break;
                    }
                    case BULSTAT: {
                        res[0] = EIKValidator.isValid(TAXN);
                        break;
                    }
                    case LNCH: {
                        res[0] = TAXN.matches(RegExpr._8_13_Digit);
                        break;
                    }
                    case ServiceNumber: {
                        res[0] = true;
                        break;
                    }
                    default: {
                        res[0] = false;
                    }
                }
                res[1] = VATN.matches(RegExpr._10_14Symbol);
                res[2] = seller.matches(RegExpr._UpTo36Symbol);
                res[3] = receiver.matches(RegExpr._UpTo36Symbol);
                res[4] = buyer.matches(RegExpr._UpTo36Symbol);
                res[5] = address1.matches(RegExpr._UpTo36Symbol);
                res[6] = address2.matches(RegExpr._UpTo36Symbol);
                return res;
            }

            public InvoiceClientInfo(TypeTAXN typeTaxNum, String TAXN, String VATN) {
                this.TypeTaxNum = typeTaxNum;
                this.TAXnum = TAXN;
                this.VATnum = VATN;
            }

            public InvoiceClientInfo(TypeTAXN typeTAXN, String TAXN, String VATN, String seller, String receiver, String buyer, String address1, String address2) {
                this.TypeTaxNum = typeTAXN;
                this.TAXnum = TAXN;
                this.VATnum = VATN;
                this.Seller = seller;
                this.Receiver = receiver;
                this.Buyer = buyer;
                this.Address1 = address1;
                this.Address2 = address2;
            }

            public void saveClientInfo() throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedDeviceV2()) {
                    R = InvoiceClientInfo.getConnectedModelV2().command57Variant0Version0(this.Seller, this.Receiver, this.Buyer, this.Address1, this.Address2, String.valueOf(this.TypeTaxNum.ordinal()), this.TAXnum, this.VATnum);
                }
                InvoiceClientInfo.checkErrorCode(R);
            }

            public void saveClientInfo(TypeTAXN TypeTaxN, String TAXN, String VATN, String seller, String receiver, String buyer, String address1, String address2) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedDeviceV2()) {
                    R = InvoiceClientInfo.getConnectedModelV2().command57Variant0Version0(seller, receiver, buyer, address1, address2, String.valueOf(TypeTaxN.ordinal()), TAXN, VATN);
                }
                InvoiceClientInfo.checkErrorCode(R);
            }

            public void saveClientInfo(TypeTAXN typeTAXN, String TAXN, String VATN) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedDeviceV2()) {
                    R = InvoiceClientInfo.getConnectedModelV2().command57Variant0Version0("", "", "", "", "", String.valueOf(typeTAXN.ordinal()), TAXN, VATN);
                }
                InvoiceClientInfo.checkErrorCode(R);
            }

            public String getTAXnum() {
                return this.TAXnum;
            }

            public void setTAXnum(String TAXnum) {
                this.TAXnum = TAXnum;
            }

            public String getVATnum() {
                return this.VATnum;
            }

            public void setVATnum(String VATnum) {
                this.VATnum = VATnum;
            }

            public String getSeller() {
                return this.Seller;
            }

            public void setSeller(String seller) {
                this.Seller = seller;
            }

            public String getReceiver() {
                return this.Receiver;
            }

            public void setReceiver(String receiver) {
                this.Receiver = receiver;
            }

            public String getBuyer() {
                return this.Buyer;
            }

            public void setBuyer(String buyer) {
                this.Buyer = buyer;
            }

            public String getAddress1() {
                return this.Address1;
            }

            public void setAddress1(String address1) {
                this.Address1 = address1;
            }

            public String getAddress2() {
                return this.Address2;
            }

            public void setAddress2(String address2) {
                this.Address2 = address2;
            }

            public void saveClientInfo(String bulstat, String seller, String receiver, String client, String clientTaxNo, String clientAddress) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
            }

            public static enum TypeTAXN {
                BULSTAT,
                EGN,
                LNCH,
                ServiceNumber;

                private static TypeTAXN[] allValues;

                public static TypeTAXN fromOrdinal(int n) {
                    return allValues[n];
                }

                static {
                    allValues = TypeTAXN.values();
                }
            }
        }
    }

    public static enum SeparatingLine {
        not_used,
        dash,
        dash_space,
        equal,
        text;

    }

    public static enum AlignmentType {
        alignmentLeft,
        alignmentCenter,
        alignmentLeftRight;

    }

    public static enum PaymentType {
        cash,
        credit_card,
        debit_card,
        other_pay3,
        other_pay4,
        other_pay5;

    }
}

