/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FiscalResponse {
    private final Map<String, String> parameters = new HashMap<String, String>();

    public FiscalResponse() {
    }

    public FiscalResponse(int i) {
    }

    public void put(String key, String value) {
        this.parameters.put(key, value);
    }

    public void set(String key, String value) {
        this.parameters.put(key, value);
    }

    public void set(String key, int value) {
        if (!this.parameters.containsKey(key)) {
            this.parameters.put(key, Integer.toString(value));
        }
    }

    public void set(String key, float value) {
        if (!this.parameters.containsKey(key)) {
            this.parameters.put(key, Float.toString(value));
        }
    }

    public void set(String key, double value) {
        if (!this.parameters.containsKey(key)) {
            this.parameters.put(key, Double.toString(value));
        }
    }

    public void set(String key, char value) {
        if (!this.parameters.containsKey(key)) {
            this.parameters.put(key, Character.toString(value));
        }
    }

    public void set(String key, boolean value) {
        if (!this.parameters.containsKey(key)) {
            this.parameters.put(key, Boolean.toString(value));
        }
    }

    public String get(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        String res = this.parameters.containsKey(key) ? this.parameters.get(key) : defaultValue;
        return res;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public int getInt(String key, int defaultValue) {
        int res;
        if (!this.parameters.containsKey(key)) {
            return defaultValue;
        }
        try {
            res = Integer.parseInt(this.parameters.get(key));
        }
        catch (NumberFormatException e) {
            res = defaultValue;
        }
        return res;
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public long getLong(String key, long defaultValue) {
        long res;
        if (!this.parameters.containsKey(key)) {
            return defaultValue;
        }
        try {
            res = Long.parseLong(this.parameters.get(key));
        }
        catch (Exception e) {
            res = defaultValue;
        }
        return res;
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public double getDouble(String key, double defaultValue) {
        double res;
        if (!this.parameters.containsKey(key)) {
            return defaultValue;
        }
        try {
            res = Double.parseDouble(this.parameters.get(key));
        }
        catch (Exception e) {
            res = defaultValue;
        }
        return res;
    }

    public double getDouble(String key) {
        return this.getDouble(key, -1.0);
    }

    public float getFloat(String key, float defaultValue) {
        float res;
        if (!this.parameters.containsKey(key)) {
            return defaultValue;
        }
        try {
            res = Long.parseLong(this.parameters.get(key));
        }
        catch (Exception e) {
            res = defaultValue;
        }
        return res;
    }

    public float getFloat(String key) {
        return this.getFloat(key, -1.0f);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean res;
        if (!this.parameters.containsKey(key)) {
            return defaultValue;
        }
        try {
            res = Boolean.parseBoolean(this.parameters.get(key));
        }
        catch (Exception e) {
            res = defaultValue;
        }
        return res;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean contains(String key) {
        return this.parameters.containsKey(key);
    }

    public Set<String> getKeys() {
        return this.parameters.keySet();
    }

    public Collection<String> getValues() {
        return this.parameters.values();
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }
}

