/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.util;

import com.datecs.util.LoggerEx;
import com.datecs.util.ResourceLoader;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Translate {
    private LoggerEx logger = LoggerEx.getLogger(Translate.class);
    public static final String invalidNumber = "invalidNumber";
    public static final String serviceIsAlreadyOpen = "serviceIsAlreadyOpen";
    public static final String serviceIsNotOpen = "serviceIsNotOpen";
    public static final String deviceIsNotClaimed = "deviceIsNotClaimed";
    public static final String changeToNewCurrencyError = "changeToNewCurrencyError";
    public static final String trainingMethodNotSupported = "trainingMethodNotSupported";
    public static final String jposEntryDoesNotContainProperty = "jposEntryDoesNotContainProperty";
    public static final String couldNotLoadProperty = "couldNotLoadProperty";
    public static final String onlySerialPortsAreHandled = "onlySerialPortsAreHandled";
    public static final String portIsCurrentlyInUse = "portIsCurrentlyInUse";
    public static final String setFiscalReceiptTypeIsDisabled = "setFiscalReceiptTypeIsDisabled";
    public static final String postPreLineIsDisabled = "postPreLineIsDisabled";
    public static final String printRecNotPaidIsDisabled = "printRecNotPaidIsDisabled";
    public static final String checkTotalIsDisabled = "checkTotalIsDisabled";
    public static final String setPOSIDIsDisabled = "setPOSIDIsDisabled";
    public static final String predefinedPaymentLinesNotSupported = "predefinedPaymentLinesNotSupported";
    public static final String methodIsDisabledByCap = "methodIsDisabledByCap";
    public static final String dayIsOpened = "dayIsOpened";
    public static final String canNotSetVatValue = "canNotSetVatValue";
    public static final String refundNotSupported = "refundNotSupported";
    public static final String vatTableNotSupported = "vatTableNotSupported";
    public static final String vatIDnotInrange = "vatIDnotInrange";
    public static final String changeOfVatTableNotSupported = "changeOfVatTableNotSupported";
    public static final String nonFiscalModeNotAllowed = "nonFiscalModeNotAllowed";
    public static final String receiptDuplicationNotSupported = "receiptDuplicationNotSupported";
    public static final String deviceIsEnabled = "deviceIsEnabled";
    public static final String additionalHeaderNotSupported = "additionalHeaderNotSupported";
    public static final String additionalTrailerNotSupported = "additionalTrailerNotSupported";
    public static final String changeDueTextNotSupported = "changeDueTextNotSupported";
    public static final String multipleContractorsNotSupported = "multipleContractorsNotSupported";
    public static final String messageTypeNotSupported = "messageTypeNotSupported";
    public static final String methodNotSupported = "methodNotSupported";
    public static final String methodNotSupportedForFiscRecType = "methodNotSupportedForFiscRecType";
    public static final String invalidParameterValue = "invalidParameterValue";
    public static final String invalidPropertyValue = "invalidPropertyValue";
    public static final String notPaidReceiptsNotSupported = "notPaidReceiptsNotSupported";
    public static final String noSupportedItemList = "noSupportedItemList";
    public static final String invalidFiscalReceiptType = "invalidFiscalReceiptType";
    public static final String failedConfirmDate = "failedConfirmDate";
    public static final String wrongPrinterState = "wrongPrinterState";
    public static final String slipStationNotPresent = "slipStationNotPresent";
    public static final String receiptStationNotPresent = "receiptStationNotPresent";
    public static final String journalStationNotPresent = "journalStationNotPresent";
    public static final String graphicsNotSupported = "graphicsNotSupported";
    public static final String endDumpFailed = "endDumpFailed";
    public static final String LockedTaxPassword = "LockedTaxPassword";
    public static final String ConfirmDateFailed = "ConfirmDateFailed";
    public static final String WriteDecimalPointFailed = "WriteDecimalPointFailed";
    public static final String StopTestFailed = "StopTestFailed";
    public static final String PrinterSupportesEAN13Only = "PrinterSupportesEAN13Only";
    public static final String InvalidBarcodeHeight = "InvalidBarcodeHeight";
    public static final String InvalidBarcodePrintType = "InvalidBarcodePrintType";
    public static final String InvalidAnswerLength = "InvalidAnswerLength";
    public static final String InvalidFieldValue = "InvalidFieldValue";
    public static final String NoConnection = "NoConnection";
    public static final String ReadAnswerError = "ReadAnswerError";
    public static final String WriteCommandError = "WriteCommandError";
    public static final String ReceiveTimeoutNotSupported = "ReceiveTimeoutNotSupported";
    public static final String NotImplemented = "NotImplemented";
    public static final String CommandNotFound = "CommandNotFound";
    public static final String NullDataParameter = "NullDataParameter";
    public static final String NullObjectParameter = "NullObjectParameter";
    public static final String InsufficientDataLen = "InsufficientDataLen";
    public static final String InsufficientObjectLen = "InsufficientObjectLen";
    public static final String BarcodeTypeNotSupported = "BarcodeTypeNotSupported";
    public static final String BarcodeExceedsPrintWidth = "BarcodeExceedsPrintWidth";
    public static final String FailedCancelReceipt = "FailedCancelReceipt";
    public static final String BaudrateNotSupported = "BaudrateNotSupported";
    public static final String InvalidLineNumber = "InvalidLineNumber";
    public static final String InvalidImageHeight = "InvalidImageHeight";
    public static final String InvalidImageWidth = "InvalidImageWidth";
    public static final String InvalidImageIndex = "InvalidImageIndex";
    public static final String PropNotFound = "PropNotFound";
    public static final String UnknownPrinterError = "UnknownPrinterError";
    public static final String InternalHealthCheck = "InternalHealthCheck";
    public static final String RecPaperEmpty = "RecPaperEmpty";
    public static final String RecPaperNearEnd = "RecPaperNearEnd";
    public static final String JrnPaperEmpty = "JrnPaperEmpty";
    public static final String JrnPaperNearEnd = "JrnPaperNearEnd";
    public static final String JrnLeverUp = "JrnLeverUp";
    public static final String EJNearFull = "EJNearFull";
    public static final String FMOverflow = "FMOverflow";
    public static final String FMLowBattery = "FMLowBattery";
    public static final String FMLastRecordCorrupted = "FMLastRecordCorrupted";
    public static final String FMEndDayRequired = "FMEndDayRequired";
    public static final String NoErrors = "NoErrors";
    public static final String PhysicalDeviceDescription = "PhysicalDeviceDescription";
    private static Translate instance;
    private ResourceBundle bundle = null;
    private final Properties properties = new Properties();

    private Translate(String resourceName) {
        this.initProperties();
        this.loadFromResource(resourceName);
    }

    public void loadFromResource(String resourceName) {
        try {
            InputStream stream = ResourceLoader.load(resourceName);
            this.bundle = new PropertyResourceBundle(stream);
        }
        catch (Exception e) {
            this.logger.error("", e);
        }
    }

    public static String getDefaultFileName() {
        String lang = Locale.getDefault().getLanguage();
        return "javapos_" + lang + ".properties";
    }

    public static Translate getInstance() {
        if (instance == null) {
            instance = new Translate(Translate.getDefaultFileName());
        }
        return instance;
    }

    public static void init(String fileName) {
        instance = new Translate(fileName);
    }

    private String getResourceString(String key) throws Exception {
        if (this.bundle != null) {
            String value = this.bundle.getString(key);
            return value;
        }
        this.logger.debug("Not found resource string for key: " + key);
        return this.properties.getProperty(key);
    }

    public static String getString(String key) {
        try {
            return Translate.getInstance().getResourceString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    private void add(String key, String value) {
        this.properties.setProperty(key, value);
    }

    private void initProperties() {
        this.properties.clear();
        this.add(invalidNumber, "Invalid Number!");
        this.add(serviceIsAlreadyOpen, "Service Is Already Open.");
        this.add(serviceIsNotOpen, "Service Is Not Open.");
        this.add(deviceIsNotClaimed, "Device Is Not Claimed.");
        this.add(changeToNewCurrencyError, "Change to a new currency only be called when the day is not opened.");
        this.add(trainingMethodNotSupported, "Training method not supported.");
        this.add(couldNotLoadProperty, "Could not load the property: ");
        this.add(jposEntryDoesNotContainProperty, "The JposEntry does not contain the property: ");
        this.add(onlySerialPortsAreHandled, "Only serial ports are handled by this driver");
        this.add(portIsCurrentlyInUse, "Port is currently in use");
        this.add(setFiscalReceiptTypeIsDisabled, "Switching of fiscal receipt types method not supported.");
        this.add(printRecNotPaidIsDisabled, "PrintRecNotPaid Is Disabled");
        this.add(checkTotalIsDisabled, "Check Total Is Disabled");
        this.add(setPOSIDIsDisabled, "SetPOSIDIs Disabled");
        this.add(predefinedPaymentLinesNotSupported, "Predefined Payment Lines Not Supported");
        this.add(methodIsDisabledByCap, "This Method Is Disabled By ");
        this.add(dayIsOpened, "Day Is Opened");
        this.add(canNotSetVatValue, "Can Not Set Vat Value.");
        this.add(refundNotSupported, "Refund Not Supported.");
        this.add(vatTableNotSupported, "VatTable Not Supported.");
        this.add(vatIDnotInrange, "Value of vatID not in range.");
        this.add(changeOfVatTableNotSupported, "Change Of VatTable Not Supported");
        this.add(postPreLineIsDisabled, "The Fiscal Printer does not support printing post/pre item lines");
        this.add(nonFiscalModeNotAllowed, "Non Fiscal Mode Not Supported");
        this.add(receiptDuplicationNotSupported, "Receipt Duplication Is Not Supported");
        this.add(deviceIsEnabled, "DeviceIsEnabled");
        this.add(additionalHeaderNotSupported, "Additional Header is not Supported");
        this.add(additionalTrailerNotSupported, "Additional trailer is not supported");
        this.add(changeDueTextNotSupported, "Change due text is not supported");
        this.add(multipleContractorsNotSupported, "Multiple contractors are not supported");
        this.add(messageTypeNotSupported, "MessageType is not supported");
        this.add(methodNotSupportedForFiscRecType, "Method not supported for selected FiscalReceiptType");
        this.add(methodNotSupported, "Method not supported");
        this.add(invalidParameterValue, "Invalid parameter value ");
        this.add(invalidPropertyValue, "Invalid property value ");
        this.add(notPaidReceiptsNotSupported, "Not paid receipts is not supported");
        this.add(noSupportedItemList, "Reports of items of a specified VAT class not supported");
        this.add(invalidFiscalReceiptType, "Invalid FiscalReceiptType value");
        this.add(failedConfirmDate, "Failed to confirm date. ");
        this.add(wrongPrinterState, "Wrong printer state");
        this.add(slipStationNotPresent, "Slip station not present");
        this.add(receiptStationNotPresent, "Receipt station not present");
        this.add(journalStationNotPresent, "Journal station not present");
        this.add(graphicsNotSupported, "Graphics not supported");
        this.add(endDumpFailed, "Can not change dump state");
        this.add(LockedTaxPassword, "Locked for invalid tax officer password");
        this.add(ConfirmDateFailed, "Can not change wait date state");
        this.add(WriteDecimalPointFailed, "Can not change point state");
        this.add(StopTestFailed, "Can not change test state");
        this.add(PrinterSupportesEAN13Only, "Printer supportes barcode EAN-13 only");
        this.add(InvalidBarcodeHeight, "Barcode height <= 0");
        this.add(InvalidBarcodePrintType, "Invalid barcode print type");
        this.add(InvalidAnswerLength, "Invalid answer data length");
        this.add(InvalidFieldValue, "Invalid field value");
        this.add(NoConnection, "No connection");
        this.add(ReceiveTimeoutNotSupported, "Receive timeout is not supported by port driver");
        this.add(NotImplemented, "Not implemented");
        this.add(CommandNotFound, "Command not found");
        this.add(NullDataParameter, "Data parameter cannot be null");
        this.add(NullObjectParameter, "Object parameter cannot be null");
        this.add(InsufficientDataLen, "Data parameter length must be greater than ");
        this.add(InsufficientObjectLen, "Object parameter length must be greater than ");
        this.add(BarcodeTypeNotSupported, "Barcode type is not supported");
        this.add(BarcodeExceedsPrintWidth, "Barcode exceeds print width");
        this.add(FailedCancelReceipt, "Can not cancel receipt");
        this.add(BaudrateNotSupported, "Baud rate is not supported");
        this.add(InvalidLineNumber, "Invalid line number value");
        this.add(InvalidImageHeight, "Image height exceeds maximum");
        this.add(InvalidImageWidth, "Image width exceeds maximum");
        this.add(InvalidImageIndex, "Invalid image index");
        this.add(PropNotFound, "Property not found, ");
        this.add(UnknownPrinterError, "Unknown printer error");
        this.add(InternalHealthCheck, "Internal health check");
        this.add(RecPaperEmpty, "Receipt paper is empty.");
        this.add(RecPaperNearEnd, "Receipt paper is near end.");
        this.add(JrnPaperEmpty, "Journal paper is empty.");
        this.add(JrnPaperNearEnd, "Journal paper is near end.");
        this.add(JrnLeverUp, "Journal station lever is up.");
        this.add(EJNearFull, "Electronic journal is near full.");
        this.add(FMOverflow, "Fiscal memory overflow.");
        this.add(FMLowBattery, "Low fiscal memory battery voltage.");
        this.add(FMLastRecordCorrupted, "Last fiscal memory record currupted.");
        this.add(FMEndDayRequired, "Fiscal memory fiscal day is over.");
        this.add(NoErrors, "No errors");
        this.add(PhysicalDeviceDescription, "%s,  %s, Printer firmware: %s.%d, %s, FM firmware: %s.%d, %s");
    }
}

