/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK;

import com.datecs.fiscalprinter.SDK.AbstractTransportProtocol;
import com.datecs.fiscalprinter.SDK.FiscalDeviceInfo;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class FiscalDeviceV2 {
    private boolean chkInputParams = true;
    private final int maxFooterLines = 10;
    private final int maxHeaderLines = 10;
    private final Double MAX_PRICE = 9999999.99;
    private final Integer MAX_DEPARTMENT = 99;
    private final Integer MAX_STOCK_GR = 99;
    private final Integer maxLinesToFeed = 99;
    private final int maxDisplayText = 20;
    private final Integer maxOperators = 30;
    private final String defaultTillNumber = "1";
    private String msgSeparator = FiscalException.msgSeparator;
    private static boolean[][] isStatusCritical = new boolean[8][8];
    static final Logger LOGGER = Logger.getLogger(FiscalDeviceV2.class.getName());
    private boolean throwErrorCode = true;
    private boolean throwErrorMessage = true;
    public static AbstractTransportProtocol transport;
    protected Map<String, Object> parameters;
    protected int build;

    public boolean isThrowErrorCode() {
        return this.throwErrorCode;
    }

    public void setThrowErrorCode(boolean throwErrorCode) {
        this.throwErrorCode = throwErrorCode;
    }

    public boolean isThrowErrorMessage() {
        return this.throwErrorMessage;
    }

    public void setThrowErrorMessage(boolean throwErrorMessage) {
        this.throwErrorMessage = throwErrorMessage;
    }

    public abstract String detectConnectedModel() throws IOException, FiscalException;

    public final String customCommand(int cmd, String data) throws UnsupportedOperationException, IOException, FiscalException {
        String result = transport.customCommand(cmd, data);
        String exceptionMessage = "";
        if (cmd != 74) {
            exceptionMessage = this.CHECK_STATUS();
        }
        FiscalResponse R = new FiscalResponse(2);
        R = this.CHECK_ERROR(result);
        if (R.getInt("errorCode") != 0) {
            if (this.throwErrorCode) {
                exceptionMessage = exceptionMessage + this.msgSeparator + R.get("errorCode");
            }
            if (this.throwErrorMessage) {
                exceptionMessage = exceptionMessage + this.msgSeparator + R.get("errorMessage");
            }
        }
        if (exceptionMessage.length() > 0) {
            throw new FiscalException(R.getInt("errorCode"), exceptionMessage);
        }
        return result;
    }

    public final synchronized void close() {
        transport.close();
    }

    public FiscalDeviceV2(InputStream input, OutputStream output, int encoding) {
        this.parameters = new HashMap<String, Object>();
    }

    public FiscalDeviceV2(InputStream input, OutputStream output) {
        this(input, output, 0);
    }

    public FiscalDeviceV2(AbstractTransportProtocol protocol) {
        transport = protocol;
        this.parameters = new HashMap<String, Object>();
    }

    private static void setupLogger() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){
            private final DateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");

            @Override
            public String format(LogRecord record) {
                StringBuilder builder = new StringBuilder(1000);
                builder.append(this.df.format(new Date(record.getMillis()))).append(" - ");
                builder.append(this.formatMessage(record));
                builder.append("\n");
                return builder.toString();
            }

            @Override
            public String getHead(Handler h) {
                return super.getHead(h);
            }

            @Override
            public String getTail(Handler h) {
                return super.getTail(h);
            }
        });
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(handler);
        LOGGER.setLevel(Level.OFF);
    }

    public static void setDebugLevel(Level level) {
        LOGGER.setLevel(level);
    }

    public FiscalDeviceInfo getInfo() {
        return new FiscalDeviceInfo();
    }

    protected String getParam(Object key) {
        return String.valueOf(this.parameters.get(key));
    }

    protected String getParam(Object key, String defaultValue) {
        return this.isNullOrEmpty(this.getParam(key)) ? defaultValue : this.getParam(key);
    }

    protected boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value) || "null".contentEquals(value);
    }

    protected String get(String value, String defaultValue) {
        return this.isNullOrEmpty(value) ? defaultValue : value;
    }

    protected String get(String prefix, String key, String suffix) {
        return (!"".equals(this.get(key, "")) ? prefix : "") + this.get(key, "") + (!"".equals(this.get(key, "")) ? suffix : "");
    }

    protected String get(String prefix, String key, String suffix, String defaultValue) {
        return (!"".equals(this.get(key, defaultValue)) ? prefix : "") + this.get(key, defaultValue) + (!"".equals(this.get(key, defaultValue)) ? suffix : "");
    }

    protected String get(String prefixSep, String prefix, String key, String suffix, String suffixSep, String defaultValue) {
        return prefixSep + this.get(prefix, key, suffix, defaultValue) + suffixSep;
    }

    protected static String[] split(String input, String[] delimiters) {
        char[] inputBuffer = input.toCharArray();
        char[][] delimiterBuffers = new char[delimiters.length][];
        for (int i = 0; i < delimiterBuffers.length; ++i) {
            delimiterBuffers[i] = delimiters[i].toCharArray();
        }
        int numberOfDelimiters = 0;
        for (int i = 0; i < inputBuffer.length; ++i) {
            for (int j = 0; j < delimiterBuffers.length; ++j) {
                if (i + delimiterBuffers[j].length > inputBuffer.length) continue;
                boolean match = true;
                for (int k = 0; k < delimiterBuffers[j].length; ++k) {
                    if (delimiterBuffers[j][k] == inputBuffer[i + k]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                ++numberOfDelimiters;
                i += delimiterBuffers[j].length - 1;
            }
        }
        String[] stringBuffer = new String[numberOfDelimiters + 1];
        if (stringBuffer.length == 1) {
            stringBuffer[0] = input;
        } else {
            int bufferIndex = 0;
            int startIndex = 0;
            for (int i = 0; i < inputBuffer.length; ++i) {
                for (int j = 0; j < delimiterBuffers.length; ++j) {
                    if (i + delimiterBuffers[j].length > inputBuffer.length) continue;
                    boolean match = true;
                    for (int k = 0; k < delimiterBuffers[j].length; ++k) {
                        if (delimiterBuffers[j][k] == inputBuffer[i + k]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    stringBuffer[bufferIndex++] = new String(inputBuffer, startIndex, i - startIndex);
                    startIndex = i + delimiterBuffers[j].length;
                    i += delimiterBuffers[j].length - 1;
                }
            }
            stringBuffer[bufferIndex] = new String(inputBuffer, startIndex, inputBuffer.length - startIndex);
        }
        return stringBuffer;
    }

    public boolean getChkInputParams() {
        return this.chkInputParams;
    }

    public boolean notInt(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public boolean notDbl(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public int toInt(String value) {
        return Integer.parseInt(value);
    }

    public double toDouble(String value) {
        return Double.parseDouble(value);
    }

    protected String formatNumber(double n, int digits) {
        StringBuffer sb = new StringBuffer();
        if (digits > 0) {
            String nstr;
            sb.append((int)n);
            sb.append('.');
            n -= (double)((int)n);
            for (int i = 0; i < digits; ++i) {
                n *= 10.0;
            }
            if (n * 10.0 % 10.0 >= 5.0) {
                n += 1.0;
            }
            if ((nstr = Integer.toString((int)n)).length() < digits) {
                for (int i = 0; i < digits - nstr.length(); ++i) {
                    sb.append('0');
                }
            }
            sb.append(nstr);
        } else {
            if (n * 10.0 % 10.0 >= 5.0) {
                n += 1.0;
            }
            sb.append((int)n);
        }
        return sb.toString();
    }

    public byte[] getLastStatus() {
        return transport.getStatusBytes();
    }

    public byte[] queryStatus() throws IOException, FiscalException {
        this.customCommand(74, null);
        return transport.getStatusBytes();
    }

    public boolean getStatusBitBol(int byteIndex, int bitIndex) {
        return transport.isStatusBitTriggered(byteIndex, bitIndex);
    }

    protected String padRight(String str, int size, char padChar) {
        StringBuffer padded = new StringBuffer(str);
        while (padded.length() < size) {
            padded.append(padChar);
        }
        return padded.toString();
    }

    public abstract FiscalResponse command100Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command101Variant0Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command103Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command105Variant0Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command106Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command107Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command107Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command107Variant1Version1(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant2Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command107Variant3Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command107Variant3Version1() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command107Variant4Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command107Variant5Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command107Variant6Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command109Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command110Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command110Variant1Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command110Variant2Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command110Variant3Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command110Variant4Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command110Variant5Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command111Variant0Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command112Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command116Variant0Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command123Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command123Variant1Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command123Variant3Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command123Variant4Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command124Variant0Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command125Variant0Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command125Variant1Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command125Variant2Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command125Variant3Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command33ariant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command35Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command38Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command39Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command42Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command46Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command44Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command45Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command47Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command48Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command48Variant0Version0(String var1, String var2, String var3, String var4, String var5) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command49Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command49Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command50Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command51Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command53Variant0Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command53Variant1Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command53Variant2Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command54Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command54Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command55Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command55Variant0Version1(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command55Variant0Version2(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command55Variant2Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command55Variant2Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command55Variant3Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command55Variant3Version1(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command55Variant3Version4(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command55Variant4Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command56Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command57Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command58Variant0Version0(String var1, String var2, String var3, String var4, String var5) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command60Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command61Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command62Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command64Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command65Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command66Variant0Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command66Variant1Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command66Variant2Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command68Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command69Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command70Variant0Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command71Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command71Variant1Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command72Variant0Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command74Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command74Variant0Version1() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command76Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command80Variant0Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command83Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command84Variant0Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command84Variant1Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command86Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command87Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command88Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command89Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command90Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command90Variant1Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command91Variant0Version0(String var1, String var2) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command92Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command94Variant0Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command95Variant0Version0(String var1, String var2, String var3) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command98Variant0Version0(String var1) throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse command99Variant0Version0() throws IOException, IllegalArgumentException, FiscalException;

    public abstract FiscalResponse Command255Read(cmd255Name var1, String var2) throws IOException, FiscalException;

    public abstract FiscalResponse Command255Write(cmd255Name var1, String var2, String var3) throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant0Version0() throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant2Version0(String var1, String var2) throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant3Version0(String var1) throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant4Version0(String var1, String var2) throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant5Version0(String var1, String var2) throws IOException, FiscalException;

    public abstract FiscalResponse command144Variant0Version0(String var1, String var2) throws IOException, FiscalException;

    public abstract FiscalResponse command202Variant1Version0(String var1) throws IOException, FiscalException;

    public abstract FiscalResponse command202Variant0Version0(String var1) throws IOException, FiscalException;

    public abstract FiscalResponse command203Variant1Version0(String var1) throws IOException, FiscalException;

    public abstract FiscalResponse command203Variant0Version0(String var1) throws IOException, FiscalException;

    public abstract FiscalResponse command127Variant0Version0(String var1, String var2) throws IOException, FiscalException;

    public abstract FiscalResponse command42Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException;

    public String getStatusBitDescriptionEn(int byteIndex, int bitIndex) {
        String tmpResult = "";
        switch (byteIndex) {
            case 0: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "For internal use  1";
                        break;
                    }
                    case 6: {
                        tmpResult = "Cover is open";
                        break;
                    }
                    case 5: {
                        tmpResult = "General error - this is OR of all errors marked with #";
                        break;
                    }
                    case 4: {
                        tmpResult = "# Failure in printing mechanism.";
                        break;
                    }
                    case 3: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 2: {
                        tmpResult = "The real time clock is not synchronized";
                        break;
                    }
                    case 1: {
                        tmpResult = "# Command code is invalid.";
                        break;
                    }
                    case 0: {
                        tmpResult = "# Syntax error.";
                    }
                }
                break;
            }
            case 1: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "For internal use  1";
                        break;
                    }
                    case 6: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 5: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 4: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 3: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 2: {
                        tmpResult = "Always 0";
                        break;
                    }
                    case 1: {
                        tmpResult = "# Command is not permitted'";
                        break;
                    }
                    case 0: {
                        tmpResult = "# Overflow during command execution";
                    }
                }
                break;
            }
            case 2: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "For internal use  1";
                        break;
                    }
                    case 6: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 5: {
                        tmpResult = "Nonfiscal receipt is open";
                        break;
                    }
                    case 4: {
                        tmpResult = "EJ nearly full";
                        break;
                    }
                    case 3: {
                        tmpResult = "Fiscal receipt is open";
                        break;
                    }
                    case 2: {
                        tmpResult = "EJ is full";
                        break;
                    }
                    case 1: {
                        tmpResult = "Paper near end";
                        break;
                    }
                    case 0: {
                        tmpResult = "# End of paper";
                    }
                }
                break;
            }
            case 3: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "For internal use  1";
                        break;
                    }
                    case 6: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 5: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 4: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 3: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 2: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 1: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 0: {
                        tmpResult = "For internal use  0";
                    }
                }
                break;
            }
            case 4: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "For internal use  1";
                        break;
                    }
                    case 6: {
                        tmpResult = "Fiscal memory is not found or damaged";
                        break;
                    }
                    case 5: {
                        tmpResult = "OR of all errors marked with * from Bytes 4 - 5";
                        break;
                    }
                    case 4: {
                        tmpResult = "* Fiscal memory is full";
                        break;
                    }
                    case 3: {
                        tmpResult = "There is space for less than 60 reports in Fiscal memory";
                        break;
                    }
                    case 2: {
                        tmpResult = "Serial number and number of FM are set";
                        break;
                    }
                    case 1: {
                        tmpResult = "Tax number is set";
                        break;
                    }
                    case 0: {
                        tmpResult = "* Error accessing data in the FM";
                    }
                }
                break;
            }
            case 5: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "For internal use  1";
                        break;
                    }
                    case 6: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 5: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 4: {
                        tmpResult = "VAT are set at least once";
                        break;
                    }
                    case 3: {
                        tmpResult = "Device is fiscalized";
                        break;
                    }
                    case 2: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 1: {
                        tmpResult = "FM is formated";
                        break;
                    }
                    case 0: {
                        tmpResult = "For internal use  0";
                    }
                }
                break;
            }
            case 6: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "For internal use  1";
                        break;
                    }
                    case 6: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 5: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 4: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 3: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 2: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 1: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 0: {
                        tmpResult = "For internal use  0";
                    }
                }
                break;
            }
            case 7: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "For internal use  1";
                        break;
                    }
                    case 6: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 5: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 4: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 3: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 2: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 1: {
                        tmpResult = "For internal use  0";
                        break;
                    }
                    case 0: {
                        tmpResult = "For internal use  0";
                    }
                }
                break;
            }
            default: {
                tmpResult = "";
            }
        }
        return tmpResult;
    }

    private boolean GetBit(byte thebyte, int position) {
        return 1 == (thebyte >> position & 1);
    }

    protected String CHECK_STATUS() {
        String statusMessage = "";
        byte[] statusBytes = this.getLastStatus();
        if (!this.GetBit(statusBytes[0], 7) && isStatusCritical[0][7]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(0, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 6) && isStatusCritical[0][6]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(0, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 5) && isStatusCritical[0][5]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(0, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 4) && isStatusCritical[0][4]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(0, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 3) && isStatusCritical[0][3]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(0, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 2) && isStatusCritical[0][2]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(0, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 1) && isStatusCritical[0][1]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(0, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 0) && isStatusCritical[0][0]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(0, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[1], 7) && isStatusCritical[1][7]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(1, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 6) && isStatusCritical[1][6]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(1, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 5) && isStatusCritical[1][5]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(1, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 4) && isStatusCritical[1][4]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(1, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 3) && isStatusCritical[1][3]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(1, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 2) && isStatusCritical[1][2]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(1, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 1) && isStatusCritical[1][1]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(1, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 0) && isStatusCritical[1][0]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(1, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[2], 7) && isStatusCritical[2][7]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(2, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 6) && isStatusCritical[2][6]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(2, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 5) && isStatusCritical[2][5]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(2, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 4) && isStatusCritical[2][4]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(2, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 3) && isStatusCritical[2][3]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(2, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 2) && isStatusCritical[2][2]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(2, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 1) && isStatusCritical[2][1]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(2, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 0) && isStatusCritical[2][0]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(2, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[3], 7) && isStatusCritical[3][7]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(3, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 6) && isStatusCritical[3][6]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(3, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 5) && isStatusCritical[3][5]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(3, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 4) && isStatusCritical[3][4]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(3, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 3) && isStatusCritical[3][3]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(3, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 2) && isStatusCritical[3][2]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(3, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 1) && isStatusCritical[3][1]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(3, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 0) && isStatusCritical[3][0]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(3, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 7) && isStatusCritical[4][7]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(4, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 6) && isStatusCritical[4][6]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(4, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 5) && isStatusCritical[4][5]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(4, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 4) && isStatusCritical[4][4]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(4, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 3) && isStatusCritical[4][3]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(4, 3) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 2) && isStatusCritical[4][2]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(4, 2) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 1) && isStatusCritical[4][1]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(4, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 0) && isStatusCritical[4][0]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(4, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 7) && isStatusCritical[5][7]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(5, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 6) && isStatusCritical[5][6]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(5, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 5) && isStatusCritical[5][5]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(5, 5) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 4) && isStatusCritical[5][4]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(5, 4) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 3) && isStatusCritical[5][3]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(5, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 2) && isStatusCritical[5][2]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(5, 2) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 1) && isStatusCritical[5][1]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(5, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 0) && isStatusCritical[5][0]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(5, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[6], 7) && isStatusCritical[6][7]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(6, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[6], 6) && isStatusCritical[6][6]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(6, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[6], 5) && isStatusCritical[6][5]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(6, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[6], 4) && isStatusCritical[6][4]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(6, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[6], 3) && isStatusCritical[6][3]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(6, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[6], 2) && isStatusCritical[6][2]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(6, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[6], 1) && isStatusCritical[6][1]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(6, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[6], 0) && isStatusCritical[6][0]) {
            statusMessage = statusMessage + this.getStatusBitDescriptionEn(6, 0) + this.msgSeparator;
        }
        return statusMessage;
    }

    private FiscalResponse CHECK_ERROR(String result) {
        String[] myOutputList = FiscalDeviceV2.split(result, new String[]{"\t"});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("errorCode", myOutputList[0]);
            R.put("errorMessage", FiscalException.locale(R.getInt("errorCode"), DatecsFiscalDevice.getCountryCode()));
        }
        return R;
    }

    public abstract FiscalResponse command43Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11) throws IOException, FiscalException;

    public abstract String[] getPrintColumnsSupported();

    public abstract boolean getCapAutoCutter();

    public abstract boolean getcapFontSupported();

    public abstract Integer getMAX_PLU();

    public abstract int getMaxNonFiscalText();

    public abstract int getMaxTextHeaderFooter();

    public abstract boolean isCapHasCutter();

    public abstract boolean iscapFontSupported();

    public static boolean getIsStatusCritical(int stByte, int stBit) {
        return isStatusCritical[stByte][stBit];
    }

    public static void setIsStatusCritical(boolean[][] statusCritical) {
        isStatusCritical = statusCritical;
    }

    public void setChkInputParams(boolean chkInputParams) {
        this.chkInputParams = chkInputParams;
    }

    public int getMaxFooterLines() {
        return 10;
    }

    public int getMaxHeaderLines() {
        return 10;
    }

    public Double getMAX_PRICE() {
        return this.MAX_PRICE;
    }

    public Integer getMAX_DEPARTMENT() {
        return this.MAX_DEPARTMENT;
    }

    public Integer getMaxStockGroup() {
        return this.MAX_STOCK_GR;
    }

    public Integer getMaxLinesToFeed() {
        return this.maxLinesToFeed;
    }

    public int getMaxDisplayText() {
        return 20;
    }

    public Integer getMaxOperators() {
        return this.maxOperators;
    }

    public abstract String getCurrentOpCode() throws IOException, FiscalException;

    public abstract String getDefaultOpPass() throws IOException, FiscalException;

    public String getDefaultTillNumber() {
        return "1";
    }

    public abstract Integer getMaxLogoW();

    public abstract Integer getMaxLogoH();

    static {
        FiscalDeviceV2.setupLogger();
    }

    public static enum cmd255Name {
        FpComBaudRate,
        AutoPaperCutting,
        PaperCuttingType,
        BarCodeHeight,
        BarcodeName,
        BthDiscoverability,
        BthPairing,
        BthPinCode,
        BthVersion,
        BthAddress,
        ComPortBaudRate,
        ComPortProtocol,
        EcrLogNumber,
        EcrExtendedReceipt,
        EcrDoveriteli,
        EcrWithoutPasswords,
        EcrAskForPassword,
        EcrAskForVoidPassword,
        EcrConnectedOperReport,
        EcrConnectedDeptReport,
        EcrConnectedPluSalesReport,
        EcrConnectedGroupsReport,
        EcrConnectedCashReport,
        EcrUserPeriodReports,
        EcrPluDailyClearing,
        EcrSafeOpening,
        EcrScaleBarMask,
        EcrNumberBarcode,
        AutoPowerOff,
        BkLight_AutoOff,
        RegModeOnIdle,
        WorkBatteryIncluded,
        MainInterfaceType,
        CurrNameLocal,
        CurrNameForeign,
        ExchangeRate,
        Header,
        Footer,
        OperName,
        OperPasw,
        PayName,
        Payment_forbidden,
        ServPasw,
        ServMessage,
        ServiceDate,
        PrnQuality,
        PrintColumns,
        DublReceipts,
        IntUseReceipts,
        BarcodePrint,
        LogoPrint,
        DoveritelPrint,
        ForeignPrint,
        VatPrintEnable,
        CondensedPrint,
        EnableNearPaperEnd,
        DsblKeyZreport,
        DsblKeyXreport,
        DsblKeyDiagnostics,
        DsblKeyFmReports,
        DsblKeyJournal,
        DsblKeyDateTime,
        DsblKeyCloseReceipt,
        DsblKeyCancelReceipt,
        ModemModel,
        SimPin,
        APN,
        APN_User,
        APN_Pass,
        SimICCID,
        SimIMSI,
        SimTelNumber,
        IMEI,
        LanMAC,
        DHCPenable,
        LAN_IP,
        LAN_NetMask,
        LAN_Gateway,
        LAN_PriDNS,
        LAN_SecDNS,
        nZreport,
        nReset,
        nVatChanges,
        nIDnumberChanges,
        nFMnumberChanges,
        nTAXnumberChanges,
        valVat,
        FMDeviceID,
        IDnumber,
        FMnumber,
        TAXnumber,
        FmWriteDateTime,
        LastValiddate,
        TAXlabel,
        Fiscalized,
        DFR_needed,
        DecimalPoint,
        nBon,
        nFBon,
        nInvoice,
        InvoiceRangeBeg,
        InvoiceRangeEnd,
        nFBonDailyCount,
        nInvoiceDailyCount,
        nLastFiscalDoc,
        CurrClerk,
        NextUpdateCheck,
        EJNewJurnal,
        EJNumber,
        fDateTimeUserSet,
        DateLastSucceededSent,
        NapRegistered,
        DeregOnSever,
        ItemGroups_name,
        Dept_name,
        Dept_price,
        Unit_name,
        EmptyLineAfterTotal,
        Bold_payments,
        LANport_fpCommands,
        Dept_vat,
        UNP,
        StornoUNP,
        PinpadComPort,
        PinpadComBaudRate,
        PinpadType,
        PinpadConnectionType,
        PinpadReceiptCopies,
        PinpadReceiptInfo,
        PinpadPaymentMenu,
        PinpadLoyaltyPayment,
        PinpadShortRec;

    }
}

