/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.util;

import com.datecs.util.FileLogger;
import com.datecs.util.Logger;

public class LoggerEx {
    private final Logger log4JLogger;
    private final FileLogger fileLogger;

    private LoggerEx(String className) {
        this.fileLogger = FileLogger.getLogger(className);
        this.log4JLogger = Logger.getLogger(className);
    }

    public static synchronized LoggerEx getLogger(Class c) {
        return LoggerEx.getLogger(c.getName());
    }

    public static synchronized LoggerEx getLogger(String className) {
        return new LoggerEx(className);
    }

    public void setEnabled(boolean value) {
        this.fileLogger.setEnabled(value);
    }

    public synchronized void fatal(String text, Throwable e) {
        this.log4JLogger.fatal(text, e);
        this.fileLogger.fatal(text, e);
    }

    public synchronized void error(String text, Throwable e) {
        this.log4JLogger.error(text, e);
        this.fileLogger.error(text, e);
    }

    public synchronized void error(Throwable e) {
        this.log4JLogger.error(e);
        this.fileLogger.error(e);
    }

    public synchronized void error(String text) {
        this.log4JLogger.error(text);
        this.fileLogger.error(text);
    }

    public synchronized void debug(String text) {
        this.log4JLogger.debug(text);
        this.fileLogger.debug(text);
    }
}

