/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;

public class cmdPinpad
extends DatecsFiscalDevice {
    public TerminalInfo getPaymentTerminalInformation() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdPinpad.getConnectedPrinterV1().command156Variant0Version0();
            cmdPinpad.checkErrorCode(R);
        }
        return new TerminalInfo(R.get("Model"), R.get("SerialNo"), R.get("SoftVer"), R.get("TerminalId"), R.get("MenuType"));
    }

    public unsuccessfulTransactionStatus getUnsuccessfulTransactionStatus(boolean[] dayClosingRequired) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdPinpad.getConnectedPrinterV1().command158Variant0Version0();
            cmdPinpad.checkErrorCode(R);
        }
        dayClosingRequired[0] = R.get("EndDay").equals("01");
        switch (R.get("Reversal")) {
            case "00": {
                return unsuccessfulTransactionStatus.frozenTransactions;
            }
            case "R": {
                return unsuccessfulTransactionStatus.freezePurchase;
            }
            case "C": {
                return unsuccessfulTransactionStatus.freezeReversal;
            }
            case "F": {
                return unsuccessfulTransactionStatus.noTransactionsInfo;
            }
        }
        return null;
    }

    public boolean checkRRN() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdPinpad.getConnectedPrinterV1().command148Variant0Version0();
            cmdPinpad.checkErrorCode(R);
        }
        return R.get("errCode").equals("P");
    }

    public TransactionData getLastTransactionData() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdPinpad.getConnectedPrinterV1().command149Variant0Version0();
            cmdPinpad.checkErrorCode(R);
        }
        return new TransactionData(R.get("CurrentRRN"), R.getInt("TransactionNo"), R.get("RRN"), R.get("AC"), R.getDouble("Price"), R.get("CardNo"));
    }

    public boolean printLastSuccessfulTransaction() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdPinpad.getConnectedPrinterV1().command151Variant0Version0();
            cmdPinpad.checkErrorCode(R);
        }
        return R.get("errCode").equals("P");
    }

    public boolean printLastSuccessfulTransactionPaymentTerminal() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdPinpad.getConnectedPrinterV1().command163Variant0Version0();
            cmdPinpad.checkErrorCode(R);
        }
        return R.get("errCode").equals("P");
    }

    public boolean printCopyReceiptByNumber(int recNumber) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdPinpad.getConnectedPrinterV1().command175Variant0Version0(String.valueOf(recNumber));
            cmdPinpad.checkErrorCode(R);
        }
        return R.get("errCode").equals("P");
    }

    public boolean printCopyReceiptByDateTime(String dateTime) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdPinpad.getConnectedPrinterV1().command175Variant0Version1(dateTime);
            cmdPinpad.checkErrorCode(R);
        }
        return R.get("errCode").equals("P");
    }

    private class TerminalInfo {
        private String Model;
        private String SerialNo;
        private String SoftVer;
        private String TerminalId;
        private String MenuType;

        public TerminalInfo(String model, String serialNo, String softVer, String terminalId, String menuType) {
            this.Model = model;
            this.SerialNo = serialNo;
            this.SoftVer = softVer;
            this.TerminalId = terminalId;
            this.MenuType = menuType;
        }

        public String getModel() {
            return this.Model;
        }

        public String getSerialNo() {
            return this.SerialNo;
        }

        public String getSoftVer() {
            return this.SoftVer;
        }

        public String getTerminalId() {
            return this.TerminalId;
        }

        public String getMenuType() {
            return this.MenuType;
        }
    }

    private class TransactionData {
        private String fCurrentRRN;
        private int fTransactionNo;
        private String fRRN;
        private String fAC;
        private Double fPrice;
        private String fCardNo;

        public TransactionData(String fCurrentRRN, int fTransactionNo, String fRRN, String fAC, Double fPrice, String fCardNo) {
            this.fCurrentRRN = fCurrentRRN;
            this.fTransactionNo = fTransactionNo;
            this.fRRN = fRRN;
            this.fAC = fAC;
            this.fPrice = fPrice;
            this.fCardNo = fCardNo;
        }

        public String getfCurrentRRN() {
            return this.fCurrentRRN;
        }

        public int getfTransactionNo() {
            return this.fTransactionNo;
        }

        public String getfRRN() {
            return this.fRRN;
        }

        public String getfAC() {
            return this.fAC;
        }

        public Double getfPrice() {
            return this.fPrice;
        }

        public String getfCardNo() {
            return this.fCardNo;
        }
    }

    public static enum unsuccessfulTransactionStatus {
        frozenTransactions,
        freezePurchase,
        freezeReversal,
        noTransactionsInfo;

    }
}

