/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.util.ArrayList;

public class cmdService
extends DatecsFiscalDevice {
    public void setErrorMessageInResponse(boolean enable) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdService.getConnectedPrinterV1().command43Variant1Version0("d", enable ? "1" : "0");
        }
        this.checkErrorCode();
    }

    public boolean isErrorMessageInResponse() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdService.getConnectedPrinterV1().command43Variant2Version0("d");
        }
        this.checkErrorCode();
        return R.get("ItemValue").equals("1");
    }

    public ArrayList<String> getLastErrorMessage(boolean clearError) throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdService.getConnectedPrinterV1().command32Variant0Version0(clearError ? "CLEAR" : "");
        }
        res.add("Cmd:" + R.get("Command") + "-" + R.get("ErrCode") + "  " + R.get("DateTime"));
        res.add(R.get("Command"));
        res.add(R.get("ErrCode"));
        res.add(R.get("DateTime"));
        return res;
    }

    public void PrintDiagnosticInfo() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdService.getConnectedPrinterV1().command71Variant0Version0();
        }
        if (this.isConnectedPrinter()) {
            R = cmdService.getConnectedPrinterV1().command71Variant0Version0();
        }
        this.checkErrorCode();
    }

    public String customCommand(String cmd, String data) throws Exception {
        String OutpS = "";
        if (this.isConnectedECR()) {
            OutpS = cmdService.getConnectedECRV1().customCommand(Integer.valueOf(cmd), data);
        }
        if (this.isConnectedPrinter()) {
            OutpS = cmdService.getConnectedPrinterV1().customCommand(Integer.valueOf(cmd), data);
        }
        this.checkErrorCode();
        return OutpS;
    }

    public String GetFiscalMemoryNumber() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdService.getConnectedECRV1().command90Variant0Version0("");
        }
        if (this.isConnectedPrinter()) {
            R = cmdService.getConnectedPrinterV1().command90Variant0Version0("");
        }
        this.checkErrorCode();
        return R.get("FM");
    }

    public String GetDeviceSerialNumber() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdService.getConnectedECRV1().command90Variant0Version0("");
        }
        if (this.isConnectedPrinter()) {
            R = cmdService.getConnectedPrinterV1().command90Variant0Version0("");
        }
        this.checkErrorCode();
        return R.get("Ser");
    }

    public static class VAT
    extends cmdService {
        private String TaxA = "";
        private String TaxB = "";
        private String TaxC = "";
        private String TaxD = "";
        private String TaxE = "";
        private String TaxF = "";
        private String TaxG = "";
        private String TaxH = "";
        private boolean enableTaxA = false;
        private boolean enableTaxB = false;
        private boolean enableTaxC = false;
        private boolean enableTaxD = false;
        private boolean enableTaxE = false;
        private boolean enableTaxF = false;
        private boolean enableTaxG = false;
        private boolean enableTaxH = false;
        private String multiplier = "";
        private String decimals;
        private String currencyName;
        private String enabledMask;

        public String getTaxA() {
            return this.TaxA;
        }

        public void setTaxA(String taxA) {
            this.TaxA = taxA;
        }

        public String getTaxB() {
            return this.TaxB;
        }

        public void setTaxB(String taxB) {
            this.TaxB = taxB;
        }

        public String getTaxC() {
            return this.TaxC;
        }

        public void setTaxC(String taxC) {
            this.TaxC = taxC;
        }

        public String getTaxD() {
            return this.TaxD;
        }

        public void setTaxD(String taxD) {
            this.TaxD = taxD;
        }

        public String getTaxE() {
            return this.TaxE;
        }

        public void setTaxE(String taxE) {
            this.TaxE = taxE;
        }

        public String getTaxF() {
            return this.TaxF;
        }

        public void setTaxF(String taxF) {
            this.TaxF = taxF;
        }

        public String getTaxG() {
            return this.TaxG;
        }

        public void setTaxG(String taxG) {
            this.TaxG = taxG;
        }

        public String getTaxH() {
            return this.TaxH;
        }

        public void setTaxH(String taxH) {
            this.TaxH = taxH;
        }

        public boolean isEnableTaxA() {
            return this.enableTaxA;
        }

        public void setEnableTaxA(boolean enableTaxA) {
            this.enableTaxA = enableTaxA;
        }

        public boolean isEnableTaxB() {
            return this.enableTaxB;
        }

        public void setEnableTaxB(boolean enableTaxB) {
            this.enableTaxB = enableTaxB;
        }

        public boolean isEnableTaxC() {
            return this.enableTaxC;
        }

        public void setEnableTaxC(boolean enableTaxC) {
            this.enableTaxC = enableTaxC;
        }

        public boolean isEnableTaxD() {
            return this.enableTaxD;
        }

        public void setEnableTaxD(boolean enableTaxD) {
            this.enableTaxD = enableTaxD;
        }

        public boolean isEnableTaxE() {
            return this.enableTaxE;
        }

        public void setEnableTaxE(boolean enableTaxE) {
            this.enableTaxE = enableTaxE;
        }

        public boolean isEnableTaxF() {
            return this.enableTaxF;
        }

        public void setEnableTaxF(boolean enableTaxF) {
            this.enableTaxF = enableTaxF;
        }

        public boolean isEnableTaxG() {
            return this.enableTaxG;
        }

        public void setEnableTaxG(boolean enableTaxG) {
            this.enableTaxG = enableTaxG;
        }

        public boolean isEnableTaxH() {
            return this.enableTaxH;
        }

        public void setEnableTaxH(boolean enableTaxH) {
            this.enableTaxH = enableTaxH;
        }

        public String getMultiplier() {
            return this.multiplier;
        }

        public void setMultiplier(String multiplier) {
            this.multiplier = multiplier;
        }

        public String getDecimals() {
            return this.decimals;
        }

        public void setDecimals(String decimals) {
            this.decimals = decimals;
        }

        public String getCurrencyName() {
            return this.currencyName;
        }

        public void setCurrencyName(String currencyName) {
            this.currencyName = currencyName;
        }

        public String getEnabledMask() {
            return this.enabledMask;
        }

        public void setEnabledMask(String enabledMask) {
            this.enabledMask = enabledMask;
        }

        public void saveVatRates(String TaxA, String TaxB, String TaxC, String TaxD, String TaxE, String TaxF, String TaxG, String TaxH) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdService.getConnectedECRV1().command83Variant0Version0(this.multiplier, this.decimals, this.currencyName, this.enabledMask, TaxA, TaxB, TaxC, TaxD, TaxE, TaxF, TaxG, TaxH);
            }
            if (this.isConnectedPrinter()) {
                R = VAT.getConnectedPrinterV1().command83Variant0Version0(this.multiplier, this.decimals, this.currencyName, this.enabledMask, TaxA, TaxB, TaxC, TaxD, TaxE, TaxF, TaxG, TaxH);
            }
            this.checkErrorCode();
        }

        public void readVatRates() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = VAT.getConnectedECRV1().command83Variant1Version0();
            }
            if (this.isConnectedPrinter()) {
                R = VAT.getConnectedPrinterV1().command83Variant1Version0();
            }
            this.checkErrorCode();
            this.TaxA = R.get("TaxA");
            this.TaxB = R.get("TaxB");
            this.TaxC = R.get("TaxC");
            this.TaxD = R.get("TaxD");
            this.TaxE = R.get("TaxE");
            this.TaxF = R.get("TaxF");
            this.TaxG = R.get("TaxG");
            this.TaxH = R.get("TaxH");
            this.multiplier = R.get("Multiplier");
            this.decimals = R.get("Decimals");
            this.currencyName = R.get("Currency_name");
            this.enabledMask = R.get("EnabledT");
            this.setVatEnabled(this.enabledMask);
        }

        private void setVatEnabled(String mask) throws IOException, FiscalException {
            if (mask.matches("^[0-1]{8}$")) {
                this.enableTaxA = mask.charAt(0) == '1';
                this.enableTaxB = mask.charAt(1) == '1';
                this.enableTaxC = mask.charAt(2) == '1';
                this.enableTaxD = mask.charAt(3) == '1';
                this.enableTaxE = mask.charAt(4) == '1';
                this.enableTaxF = mask.charAt(5) == '1';
                this.enableTaxG = mask.charAt(6) == '1';
                this.enableTaxH = mask.charAt(7) == '1';
            }
        }

        public void initVatEnabled() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = VAT.getConnectedECRV1().command83Variant1Version0();
            }
            if (this.isConnectedPrinter()) {
                R = VAT.getConnectedPrinterV1().command83Variant1Version0();
            }
            this.checkErrorCode();
            this.enabledMask = R.get("EnabledT");
        }
    }
}

