/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;

public class cmdEJournal
extends DatecsFiscalDevice {
    private volatile boolean userBreak = false;

    private String get_EjLines() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        StringBuilder res = new StringBuilder();
        while (!this.userBreak) {
            if (this.isConnectedECR()) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            if (this.isConnectedPrinter()) {
                R = cmdEJournal.getConnectedPrinterV1().command119Variant6Version1();
            }
            this.checkErrorCode();
            switch (R.get("F_RESULT")) {
                case "P": {
                    res.append(R.get("Text")).append('\n');
                    break;
                }
                case "F": {
                    return res.toString();
                }
            }
        }
        return null;
    }

    public void printEjDocumentsByDateRange(boolean CondensedFont, String StartDataTime, String EndDataTime, EjDocTypePrn DocType) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdEJournal.getConnectedPrinterV1().command119Variant1Version0(CondensedFont ? "<" : ">", DocType.getId(), StartDataTime, EndDataTime);
        }
        this.checkErrorCode();
    }

    public void printEjDocumentsByNumbersRange(boolean CondensedFont, String DocNumStart, String DocNumEnd, EjDocTypePrn DocType) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdEJournal.getConnectedPrinterV1().command119Variant3Version0(CondensedFont ? "<" : ">", DocType.getId(), DocNumStart, DocNumEnd);
        }
        this.checkErrorCode();
    }

    public String readEjDocumentsByNumbersRange(String DocNumStart, String DocNumEnd, EjDocTypePrn DocType) throws Exception {
        String readedDocLines = "";
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdEJournal.getConnectedPrinterV1().command119Variant2Version0(DocType.getId(), DocNumStart, DocNumEnd);
        }
        if (R.get("F_RESULT").equals("P")) {
            readedDocLines = R.get("Text") + "\n";
            readedDocLines = readedDocLines + this.get_EjLines();
        }
        this.checkErrorCode();
        return readedDocLines;
    }

    public String readEjDocumentsByDateRange(String StartDate, String EndDate, EjDocTypePrn DocType) throws Exception {
        String readedDocLines = "";
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdEJournal.getConnectedPrinterV1().command119Variant0Version0(DocType.getId(), StartDate, EndDate);
        }
        if (R.get("F_RESULT").equals("P")) {
            readedDocLines = R.get("Text") + "\n";
            readedDocLines = readedDocLines + this.get_EjLines();
        }
        this.checkErrorCode();
        return readedDocLines;
    }

    public String readEjDocumentsInZReport(String StartDocNumber, String EndDocNumber, String ZreportNumber, EjDocTypePrn DocType) throws Exception {
        String readedDocLines = "";
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdEJournal.getConnectedPrinterV1().command119Variant4Version0(DocType.getId(), ZreportNumber, StartDocNumber, EndDocNumber);
        }
        if (R.get("F_RESULT").equals("P")) {
            readedDocLines = R.get("Text") + "\n";
            readedDocLines = readedDocLines + this.get_EjLines();
        }
        this.checkErrorCode();
        return readedDocLines;
    }

    public String printEjDocumentsInZReport(boolean CondensedFont, String StartDocNumber, String EndDocNumber, String ZreportNumber, EjDocTypePrn DocType) throws Exception {
        String readedDocLines = "";
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdEJournal.getConnectedPrinterV1().command119Variant5Version0(CondensedFont ? "<" : ">", DocType.getId(), ZreportNumber, StartDocNumber, EndDocNumber);
        }
        if (R.get("F_RESULT").equals("P")) {
            readedDocLines = R.get("Text") + "\n";
            readedDocLines = readedDocLines + this.get_EjLines();
        }
        this.checkErrorCode();
        return readedDocLines;
    }

    public InfoEJ readEjInfo() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdEJournal.getConnectedECRV1().command124Variant2Version0();
            this.checkErrorCode();
            return new InfoEJ(R.get("isValid").equals("1"), R.get("isCurrent").equals("1"), R.get("IDnumber"), R.get("Number"), R.get("DateTime"), R.get("Serial"), R.get("fromZ"), R.get("toZ"), R.get("fromDoc"), R.get("toDoc"), String.valueOf(Long.valueOf(R.get("Size"))), String.valueOf(Long.valueOf(R.get("Used"))));
        }
        if (this.isConnectedPrinter()) {
            R = cmdEJournal.getConnectedPrinterV1().command119Variant8Version0("");
        }
        this.checkErrorCode();
        return new InfoEJ(R.get("C1"), R.get("C2"), R.get("D1"), R.get("D2"), String.valueOf(Long.valueOf(R.get("Tot")) / 0x100000L), String.valueOf(Long.valueOf(R.get("Used")) / 0x100000L));
    }

    public boolean validateEj() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            return this.readEjInfo().isValid;
        }
        if (this.isConnectedPrinter()) {
            R = cmdEJournal.getConnectedPrinterV1().command119Variant9Version0("#");
        }
        this.checkErrorCode();
        return true;
    }

    public synchronized void setUserBreak(boolean userBreak) {
        this.userBreak = userBreak;
    }

    private EJ_DocumentsFound set_SearchByDateRange(String DocType, String BegDate, String EndDate) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdEJournal.getConnectedECRV1().command124Variant0Version0(DocType, BegDate, EndDate);
        }
        this.checkErrorCode();
        if (R.get("ErrCode").equals("P")) {
            return new EJ_DocumentsFound().setFirstLastDoc(R.get("FirstDoc"), R.get("LastDoc"));
        }
        return null;
    }

    private EJ_DocumentsFound set_SearchByZReport(String DocType, String BegZ, String EndZ) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdEJournal.getConnectedECRV1().command124Variant1Version0(DocType, BegZ, EndZ);
        }
        this.checkErrorCode();
        if (R.get("ErrCode").equals("P")) {
            return new EJ_DocumentsFound().setFirstLastDoc(R.get("FirstDoc"), R.get("LastDoc"));
        }
        return null;
    }

    public String readEjDocumentsInZReport(int startDoc, int endDoc, String numReportZ, String docType) throws Exception {
        EJ_DocumentsFound fd;
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR() && (fd = this.set_SearchByZReport(docType, numReportZ, numReportZ)) != null) {
            return this.readEjDocumentsByNumbersRange(docType, String.valueOf(fd.getIntFirstDoc() + startDoc - 1), String.valueOf(fd.getIntFirstDoc() + endDoc - 1));
        }
        return "";
    }

    private int printEjDocumentsByZreprt(int startDoc, int endDoc, String numReportZ, String docType) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        int res = 0;
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            EJ_DocumentsFound fd = this.set_SearchByZReport(docType, numReportZ, numReportZ);
            if (fd == null) {
                return res;
            }
            for (int docN = startDoc; docN <= endDoc; ++docN) {
                this.print_ByNumber(docType, String.valueOf(fd.getIntFirstDoc() + docN));
                ++res;
            }
        }
        return res;
    }

    public String readEjDocumentsInZReports(String startDoc, String endDoc, String nZstart, String nZend, String docType) throws Exception {
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        StringBuilder res = new StringBuilder();
        if (this.isConnectedECR()) {
            int toZn;
            int fromZn = Integer.valueOf(nZstart);
            if (fromZn > (toZn = Integer.valueOf(nZend).intValue())) {
                toZn = fromZn;
            }
            for (int reportZ = fromZn; reportZ <= toZn; ++reportZ) {
                if (this.userBreak) {
                    return res.toString();
                }
                res.append(this.readEjDocumentsInZReport(Integer.valueOf(startDoc), Integer.valueOf(endDoc), String.valueOf(reportZ), docType));
            }
        }
        this.checkErrorCode();
        return res.toString();
    }

    private EJ_DocumentsFound print_ByNumber(String DocType, String DocNum) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdEJournal.getConnectedECRV1().command125Variant2Version0(DocNum, DocType);
        }
        this.checkErrorCode();
        if (R.get("ErrCode").equals("P")) {
            return new EJ_DocumentsFound(R.get("DocNumber"), R.get("Date"), R.get("Type"), R.get("Znumber"));
        }
        return null;
    }

    private EJ_DocumentsFound set_SearchByNumber(String DocType, String DocNum) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdEJournal.getConnectedECRV1().command125Variant0Version0(DocNum, DocType);
        }
        this.checkErrorCode();
        if (R.get("ErrCode").equals("P")) {
            return new EJ_DocumentsFound(R.get("DocNumber"), R.get("Date"), R.get("Type"), R.get("Znumber"));
        }
        return null;
    }

    public String readEjDocumentsByNumbersRange(String docType, String fromNum, String toNum) throws Exception {
        int fromN = Integer.valueOf(fromNum);
        int toN = Integer.valueOf(toNum);
        String allDocsInRange = "";
        if (fromN > toN) {
            toN = fromN;
        }
        for (int i = fromN; i <= toN; ++i) {
            EJ_DocumentsFound df = this.set_SearchByNumber(docType, String.valueOf(i));
            if (df == null || Integer.valueOf(df.getDocNumber()) != i) continue;
            allDocsInRange = allDocsInRange + this.readEjLines();
        }
        return allDocsInRange;
    }

    public int printEjDocumentsByNumbersRange(String docType, String fromNum, String toNum) throws Exception {
        int fromN = Integer.valueOf(fromNum);
        int toN = Integer.valueOf(toNum);
        String allDocsInRange = "";
        if (fromN > toN) {
            toN = fromN;
        }
        int res = 0;
        for (int i = fromN; i <= toN; ++i) {
            if (this.userBreak) {
                return res;
            }
            EJ_DocumentsFound df = this.print_ByNumber(docType, String.valueOf(i));
            if (df == null) continue;
            ++res;
        }
        return res;
    }

    public int printEjDocumentsInZReportRange(String startDoc, String endDoc, String nZstart, String nZend, String docType) throws Exception {
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        int res = 0;
        if (this.isConnectedECR()) {
            int toZn;
            int fromZn = Integer.valueOf(nZstart);
            if (fromZn > (toZn = Integer.valueOf(nZend).intValue())) {
                toZn = fromZn;
            }
            for (int reportZ = fromZn; reportZ <= toZn; ++reportZ) {
                if (this.userBreak) {
                    return res;
                }
                res += this.printEjDocumentsByZreprt(Integer.valueOf(startDoc) - 1, Integer.valueOf(endDoc) - 1, String.valueOf(reportZ), docType);
            }
        }
        this.checkErrorCode();
        return res;
    }

    public String readEjDocumentsByDateRange(String docType, String fromDate, String toDate) throws Exception {
        String allDocsInRange = "";
        EJ_DocumentsFound df = this.set_SearchByDateRange(docType, fromDate, toDate);
        if (df != null) {
            allDocsInRange = this.readEjDocumentsByNumbersRange(docType, df.getFirstDoc(), df.getLastDoc());
        }
        return allDocsInRange;
    }

    public int printEjDocumentsByDateRange(String docType, String fromDate, String toDate) throws Exception {
        String allDocsInRange = "";
        EJ_DocumentsFound df = this.set_SearchByDateRange(docType, fromDate, toDate);
        if (df != null) {
            return this.printEjDocumentsByNumbersRange(docType, df.getFirstDoc(), df.getLastDoc());
        }
        return 0;
    }

    private String readEjLines() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        StringBuilder res = new StringBuilder();
        while (!this.userBreak) {
            if (this.isConnectedECR()) {
                R = cmdEJournal.getConnectedECRV1().command125Variant1Version0();
            }
            if (this.isConnectedPrinter()) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            this.checkErrorCode();
            switch (R.get("ErrCode")) {
                case "P": {
                    res.append(R.get("Text")).append('\n');
                    break;
                }
                case "F": {
                    return res.toString();
                }
            }
        }
        return null;
    }

    public static class InfoEJ {
        private Boolean isValid;
        private Boolean isCurrent;
        private String IDnumber;
        private String Number;
        private String DateTime;
        private String Serial;
        private String FromZ;
        private String ToZ;
        private String FromDoc;
        private String ToDoc;
        private String Size;
        private String Used;

        public Boolean getValid() {
            return this.isValid;
        }

        public void setValid(Boolean valid) {
            this.isValid = valid;
        }

        public Boolean getCurrent() {
            return this.isCurrent;
        }

        public void setCurrent(Boolean current) {
            this.isCurrent = current;
        }

        public String getIDnumber() {
            return this.IDnumber;
        }

        public void setIDnumber(String IDnumber) {
            this.IDnumber = IDnumber;
        }

        public String getNumber() {
            return this.Number;
        }

        public void setNumber(String number) {
            this.Number = number;
        }

        public String getDateTime() {
            return this.DateTime;
        }

        public void setDateTime(String dateTime) {
            this.DateTime = dateTime;
        }

        public String getSerial() {
            return this.Serial;
        }

        public void setSerial(String serial) {
            this.Serial = serial;
        }

        public String getFromZ() {
            return this.FromZ;
        }

        public void setFromZ(String fromZ) {
            this.FromZ = fromZ;
        }

        public String getToZ() {
            return this.ToZ;
        }

        public void setToZ(String toZ) {
            this.ToZ = toZ;
        }

        public String getFromDoc() {
            return this.FromDoc;
        }

        public void setFromDoc(String fromDoc) {
            this.FromDoc = fromDoc;
        }

        public String getToDoc() {
            return this.ToDoc;
        }

        public void setToDoc(String toDoc) {
            this.ToDoc = toDoc;
        }

        public String getSize() {
            return this.Size;
        }

        public void setSize(String size) {
            this.Size = size;
        }

        public String getUsed() {
            return this.Used;
        }

        public void setUsed(String used) {
            this.Used = used;
        }

        public InfoEJ(String fromZ, String toZ, String fromDoc, String toDoc, String size, String used) {
            this.FromZ = fromZ;
            this.ToZ = toZ;
            this.FromDoc = fromDoc;
            this.ToDoc = toDoc;
            this.Size = size;
            this.Used = used;
        }

        public InfoEJ(Boolean isValid, Boolean isCurrent, String IDnumber, String number, String dateTime, String serial, String fromZ, String toZ, String fromDoc, String toDoc, String size, String used) {
            this.isValid = isValid;
            this.isCurrent = isCurrent;
            this.IDnumber = IDnumber;
            this.Number = number;
            this.DateTime = dateTime;
            this.Serial = serial;
            this.FromZ = fromZ;
            this.ToZ = toZ;
            this.FromDoc = fromDoc;
            this.ToDoc = toDoc;
            this.Size = size;
            this.Used = used;
        }
    }

    public static class EJ_DocumentsFound {
        private String DocNumber = "";
        private String Date = "";
        private String Type = "";
        private String Znumber = "";
        private String FirstDoc = "";
        private String LastDoc = "";

        public EJ_DocumentsFound() {
        }

        public String getDocNumber() {
            return this.DocNumber;
        }

        public String getDate() {
            return this.Date;
        }

        public String getType() {
            return this.Type;
        }

        public String getZnumber() {
            return this.Znumber;
        }

        public EJ_DocumentsFound(String docNumber, String date, String type, String znumber) {
            this.DocNumber = docNumber;
            this.Date = date;
            this.Type = type;
            this.Znumber = znumber;
        }

        public EJ_DocumentsFound setFirstLastDoc(String firstDoc, String lastDoc) {
            this.FirstDoc = firstDoc;
            this.LastDoc = lastDoc;
            return this;
        }

        public String getLastDoc() {
            return this.LastDoc;
        }

        public String getFirstDoc() {
            return this.FirstDoc;
        }

        public int getIntLastDoc() {
            return Integer.valueOf(this.LastDoc);
        }

        public int getIntFirstDoc() {
            return Integer.parseInt(this.FirstDoc);
        }
    }

    public static enum EjDocTypePrn {
        all_types("A"),
        fiscal_receipts("F"),
        storno_receipts("V"),
        anulated_receipts("C"),
        nonfiscal_receipts("N"),
        cash_in_receipts("I"),
        cash_out_receipts("O"),
        nonfiscal_receipts90("R"),
        service_receipts("S"),
        reports_short("P"),
        daily_xreports("X"),
        daily_zreports("Z");

        private final String id;
        private static EjDocTypePrn[] allValues;

        private EjDocTypePrn(String id) {
            this.id = id;
        }

        public String getId() {
            return String.valueOf(this.id);
        }

        public static EjDocTypePrn fromOrdinal(int n) {
            return allValues[n];
        }

        static {
            allValues = EjDocTypePrn.values();
        }
    }
}

