/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV2;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdEJournal;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.EAN8Writer;
import com.google.zxing.oned.ITFWriter;
import com.google.zxing.pdf417.PDF417Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ReceiptConverterC {
    private static BarcodeFormat barcodeFormat = BarcodeFormat.CODE_128;
    private int receiptWidth = 1;
    private int QRsize = 120;
    private int barcodeHeight = 100;
    private int barcodeWidth = 300;
    private static OnConvertCompletedListener mListener;
    private String outImageFormat = "png";
    private int regularFontSize = 15;
    private int boldTextFontSize = 17;
    private String textFont = "Courier New";
    private Insets receiptMargin = new Insets(3, 9, 3, 9);

    public void setQRsize(int QRsize) {
        this.QRsize = QRsize;
    }

    public void setReceiptMargin(Insets receiptMargin) {
        this.receiptMargin = receiptMargin;
    }

    public void setBarcodeHeight(int barcodeHeight) {
        this.barcodeHeight = barcodeHeight;
    }

    public void setBarcodeWidth(int barcodeWidth) {
        this.barcodeWidth = barcodeWidth;
    }

    public void setOutImageFormat(String outImageFormat) {
        this.outImageFormat = outImageFormat;
    }

    public void setRegularFontSize(int regularFontSize) {
        this.regularFontSize = regularFontSize;
    }

    public void setBoldTextFontSize(int boldTextFontSize) {
        this.boldTextFontSize = boldTextFontSize;
    }

    public void setTextFont(String textFont) {
        this.textFont = textFont;
    }

    public void registerConvertCompletedListener(OnConvertCompletedListener mListener) {
        ReceiptConverterC.mListener = mListener;
    }

    private String convertDate(String ejDate) throws Exception {
        if (!ejDate.matches("^[0-9]{2}-[0-9]{2}-[0-9]{2,4} \\d{2}:\\d{2}:\\d{2}( DST)?$")) {
            throw new Exception("INVALID DATE TIME FORMAT...");
        }
        Date date = new SimpleDateFormat("dd-MM-yy HH:mm:ss").parse(ejDate);
        SimpleDateFormat naredba18DateFormat = new SimpleDateFormat("yyyy-MM-dd*HH:mm:ss");
        return naredba18DateFormat.format(date);
    }

    private JLabel createIconLabel(ImageIcon imageIcon, String text, int fontSize) {
        JLabel label1 = new JLabel();
        label1.setFont(new Font("Courier New", 1, fontSize));
        label1.setText(text);
        label1.setIcon(imageIcon);
        label1.setHorizontalAlignment(0);
        label1.setVerticalAlignment(0);
        return label1;
    }

    private void addStylesToDocument(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(regular, this.textFont);
        StyleConstants.setBold(regular, false);
        StyleConstants.setFontSize(regular, this.regularFontSize);
        Style bold = doc.addStyle("bold", regular);
        StyleConstants.setBold(bold, true);
        StyleConstants.setFontSize(bold, this.boldTextFontSize);
    }

    public void ConvertEjReceipt(final String fmNumber, final int docNumber, final ImageIcon logoImg, final String imageFileName) {
        StyleContext context = new StyleContext();
        final DefaultStyledDocument styledDocument = new DefaultStyledDocument(context);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String recAmount = "0.00";
                    DocFoundInfo foundDoc = ReceiptConverterC.this.SetDocumentToRead(docNumber, cmdEJournal.EjDocumentType.AllTypes);
                    String docData = null;
                    if (foundDoc.getDocNumber() == docNumber) {
                        docData = ReceiptConverterC.this.ReadEjDocument();
                    }
                    boolean isQRCodeReceipt = foundDoc.getType().equals((Object)cmdEJournal.EjDocumentType.CancelledReceipts) || foundDoc.getType().equals((Object)cmdEJournal.EjDocumentType.FiscalReceipts) || foundDoc.getType().equals((Object)cmdEJournal.EjDocumentType.Invoice) || foundDoc.getType().equals((Object)cmdEJournal.EjDocumentType.FiscalRreceiptsStorno) || foundDoc.getType().equals((Object)cmdEJournal.EjDocumentType.FiscalInvoice_StornoInvoice) || foundDoc.getType().equals((Object)cmdEJournal.EjDocumentType.InvoiceReceiptsStorno);
                    String[] docLines = docData.split("\n\r");
                    ReceiptConverterC.this.addStylesToDocument(styledDocument);
                    if (logoImg != null) {
                        Style styleLogo = styledDocument.addStyle("logo", null);
                        StyleConstants.setAlignment(styleLogo, 1);
                        styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, styleLogo, false);
                        StyleConstants.setComponent(styleLogo, ReceiptConverterC.this.createIconLabel(logoImg, "", ReceiptConverterC.this.regularFontSize));
                        styledDocument.insertString(0, "dummy", styleLogo);
                        styledDocument.insertString(styledDocument.getLength(), "\n", styleLogo);
                        if (ReceiptConverterC.this.receiptWidth < logoImg.getIconWidth()) {
                            ReceiptConverterC.this.receiptWidth = logoImg.getIconWidth();
                        }
                    }
                    ReceiptConverterC.this.receiptWidth = docLines[0].length() * ReceiptConverterC.this.boldTextFontSize;
                    int qrPos = 0;
                    for (int line = 0; line < docLines.length; ++line) {
                        String s = docLines[line];
                        Style style = styledDocument.getStyle("regular");
                        StyleConstants.setAlignment(style, 0);
                        styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                        if (s.contains("\u0423\u041d\u041f:")) {
                            style = styledDocument.getStyle("bold");
                            StyleConstants.setAlignment(style, 1);
                            styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                            s = s.trim();
                            styledDocument.insertString(styledDocument.getLength(), "\n", style);
                        } else if (s.trim().matches("^.?[\\^].+$")) {
                            int col = s.length();
                            style = styledDocument.getStyle("bold");
                            s = s.replace("^", "").trim();
                            StyleConstants.setAlignment(style, 1);
                            styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                            if (s.contains("\u041e\u0431\u0449\u0430 \u0441\u0443\u043c\u0430")) {
                                String[] ls = s.split("   ", 2);
                                recAmount = String.format("%.2f", Double.valueOf(ls[1].replaceAll("#", "")));
                                StyleConstants.setAlignment(style, 0);
                                styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, style, false);
                                s = ReceiptConverterC.alignRight(ls[0], recAmount, col - recAmount.length());
                            }
                        } else {
                            if (s.contains("\u0424\u0418\u0421\u041a\u0410\u041b\u0415\u041d \u0411\u041e\u041d")) {
                                qrPos = styledDocument.getLength();
                                styledDocument.insertString(styledDocument.getLength(), "\n", style);
                                Style styleMapBG = styledDocument.addStyle("map_icon", null);
                                StyleConstants.setAlignment(styleMapBG, 1);
                                styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, styleMapBG, false);
                                StyleConstants.setComponent(styleMapBG, ReceiptConverterC.this.createIconLabel(new ImageIcon(this.getClass().getClassLoader().getResource("res/bgmap24x16.png")), s.trim(), ReceiptConverterC.this.boldTextFontSize));
                                styledDocument.insertString(styledDocument.getLength(), "dummy", styleMapBG);
                                styledDocument.insertString(styledDocument.getLength(), "\n", style);
                                continue;
                            }
                            if (s.startsWith("DT") && s.endsWith(fmNumber) && isQRCodeReceipt) {
                                styledDocument.insertString(styledDocument.getLength(), s + "\n", style);
                                String fCodeQR = fmNumber + "*" + String.format("%07d", docNumber) + "*" + ReceiptConverterC.this.convertDate(foundDoc.getDate()) + "*" + recAmount;
                                Style styleQR = styledDocument.addStyle("qr_code", null);
                                StyleConstants.setAlignment(styleQR, 1);
                                styledDocument.setParagraphAttributes(qrPos, 1, styleQR, false);
                                StyleConstants.setComponent(styleQR, ReceiptConverterC.this.createIconLabel(new ImageIcon(ReceiptConverterC.this.createBarcodeImage(fCodeQR, ReceiptConverterC.this.QRsize, ReceiptConverterC.this.QRsize, BarcodeFormat.QR_CODE)), "", ReceiptConverterC.this.boldTextFontSize));
                                styledDocument.insertString(qrPos, "dummy", styleQR);
                                continue;
                            }
                            if (s.trim().equals("BARCODE")) {
                                String barcodeData = docLines[line + 1].trim();
                                if (barcodeData.length() < 3) continue;
                                ++line;
                                Style styleBC = styledDocument.addStyle("barcode", null);
                                StyleConstants.setAlignment(styleBC, 1);
                                styledDocument.setParagraphAttributes(styledDocument.getLength(), 1, styleBC, false);
                                StyleConstants.setComponent(styleBC, ReceiptConverterC.this.createIconLabel(new ImageIcon(ReceiptConverterC.this.createBarcodeImage(barcodeData, ReceiptConverterC.this.barcodeWidth, ReceiptConverterC.this.barcodeHeight, barcodeFormat)), "", ReceiptConverterC.this.boldTextFontSize));
                                styledDocument.insertString(styledDocument.getLength(), "dummy", styleBC);
                                continue;
                            }
                        }
                        styledDocument.insertString(styledDocument.getLength(), s + "\n", style);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                JTextPane textPane = new JTextPane(styledDocument);
                                textPane.setEditable(false);
                                textPane.setMargin(ReceiptConverterC.this.receiptMargin);
                                JScrollPane scrollPane = new JScrollPane(textPane);
                                JFrame frame = new JFrame("View");
                                frame.add((Component)scrollPane, "Center");
                                frame.setSize(ReceiptConverterC.this.receiptWidth, 150);
                                frame.setVisible(true);
                                BufferedImage image = new BufferedImage(textPane.getWidth(), textPane.getHeight(), 10);
                                frame.setVisible(false);
                                Graphics2D g = image.createGraphics();
                                textPane.printAll(g);
                                g.dispose();
                                try {
                                    ImageIO.write((RenderedImage)image, ReceiptConverterC.this.outImageFormat, new File(imageFileName + "." + ReceiptConverterC.this.outImageFormat));
                                    if (mListener != null) {
                                        mListener.onResultEvent(image, null);
                                    }
                                }
                                catch (IOException exp) {
                                    exp.printStackTrace();
                                    if (mListener == null) break block3;
                                    mListener.onResultEvent(null, exp.getMessage());
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    mListener.onResultEvent(null, e.getMessage());
                }
            }
        }).start();
    }

    public void setBarcodeFormat(BCType barcodeFormat) throws Exception {
        switch (barcodeFormat) {
            case EAN8: {
                ReceiptConverterC.barcodeFormat = BarcodeFormat.EAN_8;
                break;
            }
            case EAN13: {
                ReceiptConverterC.barcodeFormat = BarcodeFormat.EAN_13;
                break;
            }
            case CODE128: {
                ReceiptConverterC.barcodeFormat = BarcodeFormat.CODE_128;
                break;
            }
            case ITF: {
                ReceiptConverterC.barcodeFormat = BarcodeFormat.ITF;
                break;
            }
            case PDF417: {
                ReceiptConverterC.barcodeFormat = BarcodeFormat.PDF_417;
                break;
            }
            default: {
                throw new Exception("Barcode not supported:" + (Object)((Object)barcodeFormat));
            }
        }
    }

    private BufferedImage createBarcodeImage(String barcodeMessage, int width, int height, BarcodeFormat bcFormat) throws Exception {
        BitMatrix bitMatrix;
        switch (bcFormat) {
            case CODE_128: {
                if (!barcodeMessage.matches("^.{3,31}$")) {
                    throw new Exception("Barcode data not matches - CODE_128");
                }
                Code128Writer code128Writer = new Code128Writer();
                bitMatrix = code128Writer.encode(barcodeMessage, BarcodeFormat.CODE_128, width, height, null);
                break;
            }
            case EAN_13: {
                if (!barcodeMessage.matches("^\\d{13}$")) {
                    throw new Exception("Barcode data not matches - EAN_13");
                }
                EAN13Writer ean13Writer = new EAN13Writer();
                bitMatrix = ean13Writer.encode(barcodeMessage, BarcodeFormat.EAN_13, width, height, null);
                break;
            }
            case EAN_8: {
                if (!barcodeMessage.matches("^\\d{8}$")) {
                    throw new Exception("Barcode data not matches - EAN_8");
                }
                EAN8Writer ean8Writer = new EAN8Writer();
                bitMatrix = ean8Writer.encode(barcodeMessage, BarcodeFormat.EAN_8, width, height, null);
                break;
            }
            case ITF: {
                if (!barcodeMessage.matches("^\\d{3,22}$")) {
                    throw new Exception("Barcode data not matches - ITF");
                }
                ITFWriter itfWriter = new ITFWriter();
                bitMatrix = itfWriter.encode(barcodeMessage, BarcodeFormat.ITF, width, height, null);
                break;
            }
            case PDF_417: {
                if (!barcodeMessage.matches("^.{3,400}$")) {
                    throw new Exception("Barcode data not matches - PDF_417");
                }
                PDF417Writer pdf417Writer = new PDF417Writer();
                bitMatrix = pdf417Writer.encode(barcodeMessage, BarcodeFormat.PDF_417, width, height, null);
                break;
            }
            case QR_CODE: {
                if (!barcodeMessage.matches("^.{3,279}$")) {
                    throw new Exception("Barcode data not matches - QR_CODE");
                }
                Hashtable<EncodeHintType, Enum> qrMap = new Hashtable<EncodeHintType, Enum>();
                qrMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
                qrMap.put(EncodeHintType.CHARACTER_SET, CharacterSetECI.ISO8859_5);
                QRCodeWriter qrCodeWriter = new QRCodeWriter();
                bitMatrix = qrCodeWriter.encode(barcodeMessage, BarcodeFormat.QR_CODE, width, width, qrMap);
                break;
            }
            default: {
                throw new Exception("UNSUPPORTED BARCODE FORMAT...");
            }
        }
        int matrixWidth = bitMatrix.getWidth();
        int matrixHeight = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(matrixWidth, matrixHeight, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, matrixWidth, matrixWidth);
        graphics.setColor(Color.BLACK);
        for (int i = 0; i < matrixWidth; ++i) {
            for (int j = 0; j < matrixHeight; ++j) {
                if (!bitMatrix.get(i, j)) continue;
                graphics.fillRect(i, j, 1, 1);
            }
        }
        return image;
    }

    private static String alignRight(String strLeft, String strRight, int column) {
        if (column < strLeft.length() + strRight.length()) {
            column = strLeft.length() + strRight.length();
        }
        return String.format("%s%" + (column - strLeft.length()) + "s", strLeft, strRight + "\n");
    }

    private DocFoundInfo SetDocumentToRead(int DocNum, cmdEJournal.EjDocumentType ejDocumentType) throws Exception {
        DocFoundInfo res;
        FiscalResponse R = new FiscalResponse(0);
        try {
            R = DatecsFiscalDevice.getConnectedModelV2().command125Variant0Version0(String.valueOf(DocNum), String.valueOf(ejDocumentType.ordinal()));
            res = new DocFoundInfo();
            res.setDocNumber(R.getInt("docNumber"));
            res.setRecNumber(R.getInt("recNumber"));
            res.setDate(R.get("date"));
            res.setType(cmdEJournal.EjDocumentType.fromOrdinal(R.getInt("type")));
            res.setZnumber(R.getInt("znumber"));
        }
        catch (FiscalException e) {
            if (e.getErrorCode() != -105000 && e.getErrorCode() != -100003) {
                throw new Exception("DOCUMENT " + DocNum + " NOT FOUND IN EJ...");
            }
            throw e;
        }
        return res;
    }

    private String ReadEjDocument() throws IOException, FiscalException {
        StringBuilder res = new StringBuilder();
        FiscalResponse R = new FiscalResponse(0);
        while (true) {
            try {
                R = DatecsFiscalDevice.getConnectedModelV2().command125Variant1Version0("1", "");
            }
            catch (FiscalException e) {
                int i = e.getErrorCode();
                if (i == -105000 || i == -100003) {
                    return res.toString();
                }
                throw e;
            }
            res.append(R.get("TextData")).append("\n\r");
        }
    }

    private static class DocFoundInfo {
        private int docNumber;
        private int recNumber;
        private String date;
        private cmdEJournal.EjDocumentType type;
        private int znumber;

        private DocFoundInfo() {
        }

        public void setDocNumber(int docNumber) {
            this.docNumber = docNumber;
        }

        public int getDocNumber() {
            return this.docNumber;
        }

        public void setRecNumber(int recNumber) {
            this.recNumber = recNumber;
        }

        public int getRecNumber() {
            return this.recNumber;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getDate() {
            return this.date;
        }

        public void setType(cmdEJournal.EjDocumentType type) {
            this.type = type;
        }

        public cmdEJournal.EjDocumentType getType() {
            return this.type;
        }

        public void setZnumber(int znumber) {
            this.znumber = znumber;
        }

        public int getZnumber() {
            return this.znumber;
        }
    }

    public static interface OnConvertCompletedListener {
        public void onResultEvent(BufferedImage var1, String var2);
    }

    public static enum BCType {
        EAN8,
        EAN13,
        CODE128,
        ITF,
        PDF417;

    }
}

