/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV2;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;

public class cmdEJournal
extends DatecsFiscalDevice {
    private volatile boolean userBreak = false;
    private int progressCounterDocs = 0;
    private int progressCounterLines = 0;

    public EJ_Document EJ_SearchDocumentsByDate(String StartDate, String EndDate, EjDocumentType ejDocumentType) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdEJournal.getConnectedModelV2().command124Variant0Version0(StartDate, EndDate, String.valueOf(ejDocumentType.ordinal()));
        }
        cmdEJournal.checkErrorCode(R);
        return new EJ_Document(R.getString("startDate"), R.getString("endDate"), R.getString("firstDoc"), R.getString("lastDoc"));
    }

    private String get_EJTextLines(String docNum) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        StringBuilder res = new StringBuilder();
        this.progressCounterLines = 0;
        while (!this.userBreak) {
            if (this.isConnectedDeviceV2()) {
                try {
                    R = cmdEJournal.getConnectedModelV2().command125Variant1Version0("1", "");
                }
                catch (FiscalException e) {
                    int i = e.getErrorCode();
                    if (i == -105000 || i == -100003) {
                        return res.toString();
                    }
                    throw e;
                }
            }
            res.append(R.get("TextData")).append("\n\r");
            ++this.progressCounterLines;
        }
        return res.toString();
    }

    public int EJ_PrintDocument(String docNum, EjDocumentType documentType) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdEJournal.getConnectedModelV2().command125Variant3Version0("3", docNum, String.valueOf(documentType.ordinal()));
        }
        return 0;
    }

    public int EJ_SetDocumentToRead(String DocNum, EjDocumentType ejDocumentType) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            try {
                R = cmdEJournal.getConnectedModelV2().command125Variant0Version0(DocNum, String.valueOf(ejDocumentType.ordinal()));
            }
            catch (FiscalException e) {
                int i = e.getErrorCode();
                if (e.getErrorCode() != -105000 && e.getErrorCode() != -100003) {
                    throw e;
                }
                return e.getErrorCode();
            }
        }
        return R.getInt("errorCode");
    }

    public EJ_ParamRange set_SearchDocuments_ByDateRange(EjDocumentType ejDocumentType, EJ_ParamRange in_range) throws IOException, FiscalException {
        EJ_Document ejFoundedDoc = null;
        ejFoundedDoc = this.EJ_SearchDocumentsByDate(in_range.getFromDT(), in_range.getToDT(), ejDocumentType);
        return new EJ_ParamRange(ejFoundedDoc.getFirstDoc(), ejFoundedDoc.getLastDoc(), ejFoundedDoc.FirstDoc, ejFoundedDoc.LastDoc, ejFoundedDoc.StartDate, ejFoundedDoc.EndDate);
    }

    public int get_Documents_ByNumbersRange(EjDocumentType ejDocumentType, EJ_ParamRange range, String[] readedDocs) throws IOException, FiscalException {
        int[] documentsCount = new int[1];
        this.get_Range(range.getDocNumStart(), range.getDocNumEnd(), ejDocumentType, documentsCount, readedDocs);
        return documentsCount[0];
    }

    private static String padLeft(String s) {
        String padded = "0000".substring(s.length()) + s;
        return padded;
    }

    public int print_Documents_ByNumbersRange(EjDocumentType ejDocumentType, EJ_ParamRange range) throws IOException, FiscalException {
        int[] printedDocuments = new int[1];
        this.print_Range(range.getDocNumStart(), range.getDocNumEnd(), printedDocuments, ejDocumentType);
        return printedDocuments[0];
    }

    private int get_Range(Integer target_Start_DocNumber, Integer target_Last_DocNumber, EjDocumentType ejDocumentType, int[] receivedDocuments, String[] lines) throws IOException, FiscalException {
        int cmdResult = Integer.MAX_VALUE;
        receivedDocuments[0] = 0;
        this.progressCounterDocs = 0;
        boolean no_Range_Case = target_Last_DocNumber.equals(target_Start_DocNumber);
        if (target_Last_DocNumber < target_Start_DocNumber) {
            target_Last_DocNumber = target_Start_DocNumber;
        }
        for (int i = target_Start_DocNumber.intValue(); i <= target_Last_DocNumber && !this.isUserBreak(); ++i) {
            int current_DocNumber = i;
            cmdResult = this.EJ_SetDocumentToRead(String.valueOf(current_DocNumber), ejDocumentType);
            if (cmdResult != 0) {
                if (cmdResult != -105000 && cmdResult != -100003 || no_Range_Case) break;
                if (current_DocNumber != target_Last_DocNumber || receivedDocuments[0] <= 0) continue;
                cmdResult = 0;
                continue;
            }
            lines[0] = lines[0] + this.get_EJTextLines(String.valueOf(current_DocNumber));
            ++this.progressCounterDocs;
            receivedDocuments[0] = receivedDocuments[0] + 1;
        }
        return cmdResult;
    }

    private int print_Range(Integer target_Start_DocNumber, Integer target_Last_DocNumber, int[] printedDocuments, EjDocumentType ejDocumentType) throws IOException, FiscalException {
        int cmdResult = Integer.MAX_VALUE;
        this.progressCounterDocs = 0;
        boolean no_Range_Case = target_Last_DocNumber.equals(target_Start_DocNumber);
        if (target_Last_DocNumber < target_Start_DocNumber) {
            target_Last_DocNumber = target_Start_DocNumber;
        }
        for (int i = target_Start_DocNumber.intValue(); i <= target_Last_DocNumber && !this.isUserBreak(); ++i) {
            ++this.progressCounterDocs;
            int current_DocNumber = i;
            cmdResult = this.EJ_PrintDocument(String.valueOf(current_DocNumber), ejDocumentType);
            if (cmdResult != 0) {
                if (cmdResult != -105000 && cmdResult != -100003 || no_Range_Case) break;
                if (current_DocNumber != target_Last_DocNumber || printedDocuments[0] <= 0) continue;
                cmdResult = 0;
                continue;
            }
            printedDocuments[0] = printedDocuments[0] + 1;
        }
        return cmdResult;
    }

    public synchronized boolean isUserBreak() {
        return this.userBreak;
    }

    public synchronized void setUserBreak(boolean userBreakPrint) {
        this.userBreak = userBreakPrint;
    }

    public int getProgressCounterDocs() {
        return this.progressCounterDocs;
    }

    public int getProgressCounterLines() {
        return this.progressCounterLines;
    }

    public static class EJ_ParamRange {
        private Integer docNumStart;
        private Integer docNumEnd;
        private String fromDT;
        private String toDT;

        public EJ_ParamRange() {
        }

        public EJ_ParamRange(Integer docNumStart, Integer docNumEnd, Integer zRangeStart, Integer zRangeEnd, String fromDT, String toDT) {
            this.docNumStart = docNumStart;
            this.docNumEnd = docNumEnd;
            this.fromDT = fromDT;
            this.toDT = toDT;
        }

        public void setFromDT(String fromDT) {
            this.fromDT = fromDT;
        }

        public void setToDT(String toDT) {
            this.toDT = toDT;
        }

        public synchronized Integer getDocNumStart() {
            return this.docNumStart;
        }

        public synchronized void setDocNumStart(Integer docNumStart) {
            this.docNumStart = docNumStart;
        }

        public synchronized Integer getDocNumEnd() {
            return this.docNumEnd;
        }

        public synchronized void setDocNumEnd(Integer docNumEnd) {
            this.docNumEnd = docNumEnd;
        }

        public String getFromDT() {
            return this.fromDT;
        }

        public String getToDT() {
            return this.toDT;
        }
    }

    public static class EJ_Document {
        private String StartDate;
        private String EndDate;
        private Integer FirstDoc;
        private Integer LastDoc;

        public EJ_Document(String startDate, String endDate, String firstDoc, String lastDoc) {
            this.StartDate = startDate;
            this.EndDate = endDate;
            this.FirstDoc = Integer.valueOf(firstDoc);
            this.LastDoc = Integer.valueOf(lastDoc);
        }

        public Integer getFirstDoc() {
            return this.FirstDoc;
        }

        public Integer getLastDoc() {
            return this.LastDoc;
        }

        public String getStartDate() {
            return this.StartDate;
        }

        public void setStartDate(String startDate) {
            this.StartDate = startDate;
        }

        public String getEndDate() {
            return this.EndDate;
        }

        public void setEndDate(String endDate) {
            this.EndDate = endDate;
        }
    }

    public static enum EjDocumentType {
        AllTypes,
        FiscalReceipts,
        DailyZ,
        Invoice,
        Nonfiscal,
        PaidoutReceipts,
        FiscalRreceiptsStorno,
        InvoiceReceiptsStorno,
        CancelledReceipts,
        DailyX,
        FiscalInvoice_StornoInvoice;

        private static EjDocumentType[] allValues;

        public static EjDocumentType fromOrdinal(int n) {
            return allValues[n];
        }

        static {
            allValues = EjDocumentType.values();
        }
    }
}

