/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.util.EGNValidator;
import com.datecs.util.EIKValidator;
import com.datecs.util.RegExpr;
import java.util.ArrayList;
import java.util.List;

public class cmdReceipt
extends DatecsFiscalDevice {
    protected String allReceipt;
    private String sPrintBCdata = ";";

    public void printBarcode(String bcData, BarcodeType bcType, String bcAlign, boolean bcLongSize) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            if (this.sPrintBCdata.equals("")) {
                this.sPrintBCdata = ",";
            }
            R = cmdReceipt.getConnectedECRV1().command84Variant0Version0(bcType.getId(), bcData, this.sPrintBCdata);
        }
        if (this.isConnectedPrinter()) {
            R = cmdReceipt.getConnectedPrinterV1().command84Variant0Version0(bcType.getId(), bcAlign, bcLongSize ? "*" : "", this.sPrintBCdata, bcData);
        }
        this.checkErrorCode();
    }

    public void setPrintBarcodeData(boolean value) throws Exception {
        this.sPrintBCdata = value ? "" : ";";
    }

    public static class FiscalReceipt
    extends cmdReceipt {
        String OpCode;
        String OpPwd;
        String TillNmb;
        String UNP = "";
        private String fiscReceipt;

        public FiscalReceipt(String opCode, String opPwd, String tillNmb) {
            this.OpCode = opCode;
            this.OpPwd = opPwd;
            this.TillNmb = tillNmb;
        }

        public FiscalReceipt(String opCode, String opPwd, String tillNmb, String unp) {
            this.OpCode = opCode;
            this.OpPwd = opPwd;
            this.TillNmb = tillNmb;
            this.UNP = unp;
        }

        public FiscalReceipt() {
        }

        public int openFiscalReceipt(String opCode, String opPwd, String tillNmb, String unp) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdReceipt.getConnectedECRV1().command48Variant0Version0(opCode, opPwd, tillNmb, unp);
            }
            if (this.isConnectedPrinter()) {
                R = cmdReceipt.getConnectedPrinterV1().command48Variant0Version0(opCode, opPwd, tillNmb, unp);
            }
            this.allReceipt = R.getString("AllReceipt");
            this.fiscReceipt = R.getString("FiscReceipt");
            this.checkErrorCode();
            return Integer.valueOf(this.fiscReceipt);
        }

        public int openFiscalReceipt() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdReceipt.getConnectedECRV1().command48Variant0Version0(this.OpCode, this.OpPwd, this.TillNmb, this.UNP);
            }
            if (this.isConnectedPrinter()) {
                R = cmdReceipt.getConnectedPrinterV1().command48Variant0Version0(this.OpCode, this.OpPwd, this.TillNmb, this.UNP);
            }
            this.checkErrorCode();
            this.allReceipt = R.getString("AllReceipt");
            this.fiscReceipt = R.getString("FiscReceipt");
            return Integer.valueOf(this.fiscReceipt);
        }

        public int closeFiscalReceipt() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command56Variant0Version0();
            }
            if (this.isConnectedPrinter()) {
                R = cmdReceipt.getConnectedPrinterV1().command56Variant0Version0();
            }
            this.allReceipt = R.getString("Allreceipt");
            this.fiscReceipt = R.getString("FiscReceipt");
            this.checkErrorCode();
            return Integer.valueOf(this.fiscReceipt);
        }

        public int openInvoice(String opCode, String opPwd, String tillNmb, String unp) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command48Variant1Version0(opCode, opPwd, tillNmb, unp);
            }
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command48Variant1Version0(opCode, opPwd, tillNmb, unp);
            }
            this.checkErrorCode();
            this.allReceipt = R.getString("AllReceipt");
            this.fiscReceipt = R.getString("FiscReceipt");
            return Integer.valueOf(this.fiscReceipt);
        }

        public boolean isInvoice() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command103Variant0Version0();
            }
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command103Variant0Version0();
            }
            this.checkErrorCode();
            return R.get("Inv").equals("1");
        }

        public boolean isOpen() throws Exception {
            boolean bitResult = true;
            if (this.isConnectedPrinter()) {
                bitResult = FiscalReceipt.getConnectedPrinterV1().getStatusBitBol(2, 3);
            }
            if (this.isConnectedECR()) {
                bitResult = FiscalReceipt.getConnectedECRV1().getStatusBitBol(2, 3);
            }
            return bitResult;
        }

        public boolean cancel() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command60Variant0Version0();
            }
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command60Variant0Version0();
            }
            this.checkErrorCode();
            return true;
        }

        public String getLastUNP() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command48Variant2Version0();
            }
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command48Variant2Version0();
            }
            this.checkErrorCode();
            return R.get("UNP");
        }

        public int getNextFiscReceipt() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command110Variant0Version0();
            }
            if (this.isConnectedPrinter()) {
                R = cmdReceipt.getConnectedPrinterV1().command110Variant0Version0();
            }
            this.checkErrorCode();
            return Integer.parseInt(R.get("Receipt"));
        }

        public String getLastDocNumber() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command113Variant0Version0();
            }
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command113Variant0Version0();
            }
            this.checkErrorCode();
            return R.get("DocNum");
        }

        public String getOpCode() {
            return this.OpCode;
        }

        public void setOpCode(String opCode) {
            this.OpCode = opCode;
        }

        public String getOpPwd() {
            return this.OpPwd;
        }

        public void setOpPwd(String opPwd) {
            this.OpPwd = opPwd;
        }

        public String getTillNmb() {
            return this.TillNmb;
        }

        public void setTillNmb(String tillNmb) {
            this.TillNmb = tillNmb;
        }

        public String getAllreceipt() {
            return this.allReceipt;
        }

        public String getFiscReceipt() {
            return this.fiscReceipt;
        }

        public void printFreeText(String s) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command54Variant0Version0(s);
            }
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command54Variant0Version0(s);
            }
            this.checkErrorCode();
        }

        public void printFreeText(String text, boolean Bold, boolean DoubleH, boolean Italic, FreeFiscalTextType font) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            String flags = Bold ? "B" : "";
            flags = flags + (DoubleH ? "H" : "");
            flags = flags + (Italic ? "I" : "");
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command54Variant0Version0(text);
            }
            if (this.isConnectedPrinter()) {
                R = cmdReceipt.getConnectedPrinterV1().command54Variant1Version0(String.valueOf(font.ordinal()), flags, text);
            }
            this.checkErrorCode();
        }

        public void paperFeed(int linesToFeed) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            while (linesToFeed > 99) {
                if (this.isConnectedPrinter()) {
                    R = FiscalReceipt.getConnectedPrinterV1().command44Variant0Version0(String.valueOf(linesToFeed));
                }
                if (this.isConnectedECR()) {
                    R = FiscalReceipt.getConnectedECRV1().command44Variant0Version0(String.valueOf(linesToFeed));
                }
                linesToFeed -= 99;
            }
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command44Variant0Version0(String.valueOf(linesToFeed));
            }
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command44Variant0Version0(String.valueOf(linesToFeed));
            }
            this.checkErrorCode();
        }

        public void paperCutting() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedPrinter() && FiscalReceipt.getConnectedPrinterV1().isPaperCuttingDevice()) {
                R = FiscalReceipt.getConnectedPrinterV1().command45Variant0Version0();
            }
            if (this.isConnectedECR()) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }

        public Double[] cashInCashOut(Double dAmount) throws Exception {
            Double[] outData = new Double[3];
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command70Variant0Version0(dAmount.toString());
            }
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command70Variant0Version0(dAmount.toString());
            }
            if (R.get("ExitCode").equals("P")) {
                outData[0] = R.getDouble("CashSum");
                outData[1] = R.getDouble("ServIn");
                outData[2] = R.getDouble("ServOut");
            }
            this.checkErrorCode();
            return outData;
        }

        public void printSeparatingLine(SeparatingLine separatingLine) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command92Variant0Version0(String.valueOf(separatingLine.ordinal() + 1));
            }
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command92Variant0Version0(String.valueOf(separatingLine.ordinal() + 1));
            }
            this.checkErrorCode();
        }

        public void drawerKickOut(String timeout) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = FiscalReceipt.getConnectedECRV1().command106Variant0Version0(timeout);
            }
            if (this.isConnectedPrinter()) {
                R = FiscalReceipt.getConnectedPrinterV1().command106Variant0Version0(timeout);
            }
            this.checkErrorCode();
        }

        public static class FiscalTransaction
        extends cmdReceipt {
            private boolean Open;
            private int Items;
            private Double Amount;
            private Double Tender;
            private final Double NotPaid;

            public FiscalTransaction() throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    R = FiscalTransaction.getConnectedECRV1().command76Variant0Version0("");
                }
                if (this.isConnectedPrinter()) {
                    R = cmdReceipt.getConnectedPrinterV1().command76Variant0Version0("");
                }
                this.checkErrorCode();
                this.Open = R.getBoolean("Open");
                this.Amount = R.getDouble("Amount");
                this.Items = R.getInt("Items");
                this.Tender = this.getPaid();
                this.NotPaid = this.Amount - this.Tender;
            }

            public boolean isOpen() {
                return this.Open;
            }

            public int getNumberOfItems() {
                return this.Items;
            }

            public Double getAmount() {
                return this.Amount;
            }

            public Double getPaid() throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    R = FiscalReceipt.getConnectedECRV1().command76Variant0Version0("T");
                }
                if (this.isConnectedPrinter()) {
                    R = FiscalReceipt.getConnectedPrinterV1().command76Variant0Version0("T");
                }
                this.checkErrorCode();
                return R.getDouble("Tender");
            }

            public Double getNotPaid() {
                return this.NotPaid;
            }
        }

        public static class Storno
        extends FiscalReceipt {
            private StornoType TypeOfStorno;
            String StornoUNP;
            String DocNumber;
            String DocUNP;
            String DocDateTime;
            String FMNumber;
            String StornoReason;
            private String InvoiceNumber;

            public Storno() {
            }

            public Storno(String opCode, String opPwd, String stornoUNP, String tillNmb, StornoType stornoType, String docNumber, String docUNP, String docDateTime, String fmnumber, String stornoReason) {
                this.OpCode = opCode;
                this.OpPwd = opPwd;
                this.StornoUNP = stornoUNP;
                this.TillNmb = tillNmb;
                this.TypeOfStorno = stornoType;
                this.DocNumber = docNumber;
                this.DocUNP = docUNP;
                this.DocDateTime = docDateTime;
                this.FMNumber = fmnumber;
                this.StornoReason = stornoReason;
            }

            public Storno(String opCode, String opPwd, String tillNmb, String docUNP, StornoType stornoType, String docNumber, String stornoReason) {
                this.OpCode = opCode;
                this.OpPwd = opPwd;
                this.TillNmb = tillNmb;
                this.StornoUNP = docUNP;
                this.TypeOfStorno = stornoType;
                this.DocNumber = docNumber;
                this.StornoReason = stornoReason;
            }

            public void openStornoReceipt() throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    R = Storno.getConnectedECRV1().command46Variant0Version0(this.OpCode, this.OpPwd, this.DocUNP, this.TillNmb, this.TypeOfStorno.getId(), this.DocNumber, this.DocDateTime, this.FMNumber, "", "", this.StornoReason);
                }
                if (this.isConnectedPrinter()) {
                    R = cmdReceipt.getConnectedPrinterV1().command46Variant0Version0(this.OpCode, this.OpPwd, this.TillNmb, "", "", this.StornoUNP, this.TypeOfStorno.getId(), this.DocNumber, this.DocUNP, this.DocDateTime, this.FMNumber, this.StornoReason);
                }
            }

            public void printStornoReceipt(String opCode, String opPwd, String tillNmb, String stronoUNP, StornoType stornoType, String docNumber, String stornoReason) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                if (this.isConnectedPrinter()) {
                    R = Storno.getConnectedPrinterV1().command46Variant0Version0(opCode, opPwd, tillNmb, "", "", stronoUNP, stornoType.getId(), docNumber, "", "", "", stornoReason);
                }
            }

            public boolean printStornoReceipt() throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                if (this.isConnectedPrinter()) {
                    R = Storno.getConnectedPrinterV1().command46Variant0Version0(this.OpCode, this.OpPwd, this.TillNmb, "", "", this.StornoUNP, this.TypeOfStorno.getId(), this.DocNumber, "", "", "", this.StornoReason);
                }
                this.checkErrorCode();
                return !R.get("Result").equals("P");
            }

            public boolean openStornoReceipt(String opCode, String opPwd, String tillNmb, String stronoUNP, StornoType stornoType, String docNumber, String docUNP, String docDT, String FMNumber, String stornoReason) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    R = Storno.getConnectedECRV1().command46Variant0Version0(opCode, opPwd, docUNP, tillNmb, String.valueOf(stornoType.ordinal()), docNumber, docDT, FMNumber, "", "", "");
                }
                if (this.isConnectedPrinter()) {
                    R = cmdReceipt.getConnectedPrinterV1().command46Variant0Version0(opCode, opPwd, tillNmb, "", "", stronoUNP, stornoType.getId(), docNumber, docUNP, docDT, FMNumber, stornoReason);
                }
                this.checkErrorCode();
                return !R.get("Result").equals("P");
            }

            public void printStornoInvoice(String opCode, String opPwd, String tillNmb, String stronoUNP, StornoType stornoType, String docNumber, String invoiceNumber, String stornoReason) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                if (this.isConnectedPrinter()) {
                    R = Storno.getConnectedPrinterV1().command46Variant0Version0(opCode, opPwd, tillNmb, "I", invoiceNumber, stronoUNP, stornoType.getId(), docNumber, "", "", "", stornoReason);
                }
            }

            public boolean printStornoInvoice() throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                if (this.isConnectedPrinter()) {
                    R = Storno.getConnectedPrinterV1().command46Variant0Version0(this.OpCode, this.OpPwd, this.TillNmb, "I", this.InvoiceNumber, this.StornoUNP, this.TypeOfStorno.getId(), this.DocNumber, "", "", "", this.StornoReason);
                }
                this.checkErrorCode();
                return !R.get("Result").equals("P");
            }

            public boolean openStornoInvoice(String opCode, String opPwd, String tillNmb, String stronoUNP, StornoType stornoType, String docNumber, String docUNP, String docDT, String FMNumber, String invoiceNumber, String stornoReason) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    R = Storno.getConnectedECRV1().command46Variant0Version0(opCode, opPwd, docUNP, tillNmb, String.valueOf(stornoType.ordinal()), docNumber, docDT, FMNumber, "I", invoiceNumber, stornoReason);
                }
                if (this.isConnectedPrinter()) {
                    R = cmdReceipt.getConnectedPrinterV1().command46Variant0Version0(opCode, opPwd, tillNmb, "I", invoiceNumber, stronoUNP, stornoType.getId(), docNumber, docUNP, docDT, FMNumber, stornoReason);
                }
                this.checkErrorCode();
                return !R.get("Result").equals("P");
            }

            public List<Boolean> capIssueStornoReceipt(String opCode, String opPwd, String tillNmb, String stronoUNP, StornoType stornoType, String docNumber, String stornoReason) {
                ArrayList<Boolean> resList = new ArrayList<Boolean>();
                if (this.isConnectedPrinter()) {
                    resList.add(opCode.matches(RegExpr._1_16));
                    resList.add(opPwd.matches(RegExpr._4to8Digit));
                    resList.add(stornoType.getId().matches(RegExpr._E_R_T));
                }
                if (this.isConnectedECR()) {
                    resList.add(opCode.matches(RegExpr._1_30));
                    resList.add(opPwd.matches(RegExpr._1to8Digit));
                    resList.add(String.valueOf(stornoType.ordinal()).matches(RegExpr._1_3));
                }
                resList.add(tillNmb.matches(RegExpr._1_99999));
                if (stronoUNP.length() > 0) {
                    resList.add(stronoUNP.matches(RegExpr._UNP));
                } else {
                    resList.add(true);
                }
                resList.add(docNumber.matches(RegExpr._0_99999999));
                if (stornoReason.length() > 0) {
                    resList.add(stornoReason.matches(RegExpr._UpTo30Symbol));
                } else {
                    resList.add(true);
                }
                return resList;
            }

            public List<Boolean> capIssueStornoReceipt(String opCode, String opPwd, String tillNmb, String stronoUNP, StornoType stornoType, String docNumber, String docUNP, String docDateTime, String fiscalMemoryID, String stornoReason) {
                ArrayList<Boolean> resList = new ArrayList<Boolean>();
                if (this.isConnectedPrinter()) {
                    resList.add(opCode.matches(RegExpr._1_16));
                    resList.add(opPwd.matches(RegExpr._4to8Digit));
                }
                if (this.isConnectedECR()) {
                    resList.add(opCode.matches(RegExpr._1_30));
                    resList.add(opPwd.matches(RegExpr._1to8Digit));
                }
                if (this.isConnectedECR() || this.isConnectedPrinter()) {
                    resList.add(tillNmb.matches(RegExpr._1_99999));
                    if (stronoUNP.length() > 0) {
                        resList.add(stronoUNP.matches(RegExpr._UNP));
                    } else {
                        resList.add(true);
                    }
                    resList.add(stornoType.getId().matches(RegExpr._E_R_T));
                    resList.add(docNumber.matches(RegExpr._0_99999999));
                    resList.add(docUNP.matches(RegExpr._UNP));
                    resList.add(docDateTime.matches(RegExpr._DDMMYYhhmmss));
                    resList.add(fiscalMemoryID.matches(RegExpr._8Digit));
                    if (stornoReason.length() > 0) {
                        resList.add(stornoReason.matches(RegExpr._UpTo30Symbol));
                    } else {
                        resList.add(true);
                    }
                    return resList;
                }
                return null;
            }

            @Override
            public boolean isOpen() throws Exception {
                boolean bitResult = false;
                if (this.isConnectedECR()) {
                    FiscalResponse R = new FiscalResponse(0);
                    R = Storno.getConnectedECRV1().command103Variant0Version0();
                    this.checkErrorCode();
                    bitResult = R.get("Type").matches(RegExpr._0_3);
                } else if (this.isConnectedPrinter()) {
                    bitResult = Storno.getConnectedPrinterV1().getStatusBitBol(1, 4);
                }
                return bitResult;
            }

            public static enum StornoType {
                OperatorMistake('E'),
                ReturnedItem('R'),
                LowTAX('T');

                private final char id;
                private static StornoType[] allValues;

                private StornoType(char id) {
                    this.id = id;
                }

                public String getId() {
                    return String.valueOf(this.id);
                }

                public static StornoType fromOrdinal(int n) {
                    return allValues[n];
                }

                static {
                    allValues = StornoType.values();
                }
            }
        }

        public static class FiscalSale
        extends FiscalReceipt {
            String sDescriptionL1;
            String sDescriptionL2;
            String sTaxCd;
            String sDept;
            String sPrice;
            String sQwan;
            String sUN;
            String sDiscountType;
            String sDiscValueStr;
            String sPLU;
            private boolean sendToDisplay = false;

            public boolean isSendToDisplay() {
                return this.sendToDisplay;
            }

            public void setSendToDisplay(boolean sendToDisplay) {
                this.sendToDisplay = sendToDisplay;
            }

            public void addByPLU(String pluCode, String dept, String quantity, String unitName, CorrectionType correctionType, String discountValue) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                switch (correctionType) {
                    case noCorecction: {
                        if (this.isConnectedPrinter()) {
                            R = FiscalSale.getConnectedPrinterV1().command58Variant0Version1(this.sendToDisplay ? "D" : "", pluCode, dept, quantity, unitName, "");
                        }
                        if (!this.isConnectedECR()) break;
                        R = FiscalSale.getConnectedECRV1().command58Variant0Version1(this.sendToDisplay ? "D" : "", pluCode, dept, quantity, "");
                        break;
                    }
                    case discountPercentage: 
                    case surchargePercentage: {
                        if (this.isConnectedPrinter()) {
                            R = FiscalSale.getConnectedPrinterV1().command58Variant0Version0(this.sendToDisplay ? "D" : "", pluCode, dept, quantity, unitName, discountValue);
                        }
                        if (!this.isConnectedECR()) break;
                        R = FiscalSale.getConnectedECRV1().command58Variant0Version0(this.sendToDisplay ? "D" : "", pluCode, dept, quantity, discountValue);
                        break;
                    }
                    case discountSum: 
                    case surchargeSum: {
                        if (this.isConnectedPrinter()) {
                            R = FiscalSale.getConnectedPrinterV1().command58Variant0Version1(this.sendToDisplay ? "D" : "", pluCode, dept, quantity, unitName, discountValue);
                        }
                        if (!this.isConnectedECR()) break;
                        R = FiscalSale.getConnectedECRV1().command58Variant0Version0(this.sendToDisplay ? "D" : "", pluCode, dept, quantity, discountValue);
                    }
                }
                this.checkErrorCode();
            }

            public void add() throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedECR()) {
                    R = FiscalSale.getConnectedECRV1().command49Variant1Version0(this.sDescriptionL1, this.sDescriptionL2, this.sTaxCd, this.sPrice, this.sQwan, this.sDiscValueStr);
                }
                if (this.isConnectedPrinter()) {
                    R = FiscalSale.getConnectedPrinterV1().command49Variant1Version0(this.sDescriptionL1, this.sDescriptionL2, this.sTaxCd, this.sPrice, this.sQwan, this.sUN, this.sDiscValueStr);
                }
                this.checkErrorCode();
            }

            public void addByDepartment(String descriptionL1, String descriptionL2, String dept, String price, String qwan, String unitName, CorrectionType correctionType, String percentAbs) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                switch (correctionType) {
                    case noCorecction: {
                        if (this.isConnectedPrinter()) {
                            R = FiscalSale.getConnectedPrinterV1().command49Variant0Version1(descriptionL1, descriptionL2, dept, price, qwan, unitName, "");
                        }
                        if (!this.isConnectedECR()) break;
                        R = FiscalSale.getConnectedECRV1().command49Variant0Version1(descriptionL1, descriptionL2, dept, price, qwan, "");
                        break;
                    }
                    case discountPercentage: 
                    case surchargePercentage: {
                        if (this.isConnectedPrinter()) {
                            R = FiscalSale.getConnectedPrinterV1().command49Variant0Version1(descriptionL1, descriptionL2, dept, price, qwan, unitName, percentAbs);
                        }
                        if (!this.isConnectedECR()) break;
                        R = FiscalSale.getConnectedECRV1().command49Variant0Version1(descriptionL1, descriptionL2, dept, price, qwan, percentAbs);
                        break;
                    }
                    case discountSum: 
                    case surchargeSum: {
                        if (this.isConnectedPrinter()) {
                            R = FiscalSale.getConnectedPrinterV1().command49Variant1Version1(descriptionL1, descriptionL2, dept, price, qwan, unitName, percentAbs);
                        }
                        if (!this.isConnectedECR()) break;
                        R = FiscalSale.getConnectedECRV1().command49Variant1Version1(descriptionL1, descriptionL2, dept, price, qwan, percentAbs);
                    }
                }
                this.checkErrorCode();
            }

            public void add(String descriptionL1, String descriptionL2, String taxCd, String price, String qwan, String unitName, CorrectionType correctionType, String percentAbs) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                switch (correctionType) {
                    case noCorecction: {
                        if (this.isConnectedECR()) {
                            R = cmdReceipt.getConnectedECRV1().command49Variant0Version0(descriptionL1, descriptionL2, taxCd, price, qwan, "");
                        }
                        if (!this.isConnectedPrinter()) break;
                        R = FiscalSale.getConnectedPrinterV1().command49Variant0Version0(descriptionL1, descriptionL2, taxCd, price, qwan, unitName, "");
                        break;
                    }
                    case discountPercentage: {
                        if (!percentAbs.contains("-")) {
                            percentAbs = "-" + percentAbs;
                        }
                    }
                    case surchargePercentage: {
                        if (this.isConnectedECR()) {
                            R = FiscalSale.getConnectedECRV1().command49Variant0Version0(descriptionL1, descriptionL2, taxCd, price, qwan, percentAbs);
                        }
                        if (!this.isConnectedPrinter()) break;
                        R = FiscalSale.getConnectedPrinterV1().command49Variant0Version0(descriptionL1, descriptionL2, taxCd, price, qwan, unitName, percentAbs);
                        break;
                    }
                    case discountSum: {
                        if (!percentAbs.contains("-")) {
                            percentAbs = "-" + percentAbs;
                        }
                    }
                    case surchargeSum: {
                        if (this.isConnectedECR()) {
                            R = FiscalSale.getConnectedECRV1().command49Variant1Version0(descriptionL1, descriptionL2, taxCd, price, qwan, percentAbs);
                        }
                        if (!this.isConnectedPrinter()) break;
                        R = FiscalSale.getConnectedPrinterV1().command49Variant1Version0(descriptionL1, descriptionL2, taxCd, price, qwan, unitName, percentAbs);
                    }
                }
                this.checkErrorCode();
            }

            public String subtotal(boolean print, boolean dispaly, CorrectionType corecctionType, String corecctionValue) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                switch (corecctionType) {
                    case noCorecction: {
                        if (this.isConnectedECR()) {
                            R = cmdReceipt.getConnectedECRV1().command51Variant0Version0(print ? "1" : "0", dispaly ? "1" : "0");
                        }
                        if (!this.isConnectedPrinter()) break;
                        R = cmdReceipt.getConnectedPrinterV1().command51Variant0Version0(print ? "1" : "0", dispaly ? "1" : "0");
                        break;
                    }
                    case discountSum: {
                        if (!corecctionValue.contains("-")) {
                            corecctionValue = "-" + corecctionValue;
                        }
                    }
                    case surchargeSum: {
                        if (this.isConnectedECR()) {
                            R = cmdReceipt.getConnectedECRV1().command51Variant2Version0(print ? "1" : "0", dispaly ? "1" : "0", corecctionValue);
                        }
                        if (!this.isConnectedPrinter()) break;
                        R = cmdReceipt.getConnectedPrinterV1().command51Variant2Version0(print ? "1" : "0", dispaly ? "1" : "0", corecctionValue);
                        break;
                    }
                    case discountPercentage: {
                        if (!corecctionValue.contains("-")) {
                            corecctionValue = "-" + corecctionValue;
                        }
                    }
                    case surchargePercentage: {
                        if (this.isConnectedECR()) {
                            R = cmdReceipt.getConnectedECRV1().command51Variant1Version0(print ? "1" : "0", dispaly ? "1" : "0", corecctionValue);
                        }
                        if (!this.isConnectedPrinter()) break;
                        R = cmdReceipt.getConnectedPrinterV1().command51Variant1Version0(print ? "1" : "0", dispaly ? "1" : "0", corecctionValue);
                    }
                }
                return R.get("SubTotal");
            }

            public TotalResult saleTotal(String sDescriptionL1, String sDescriptionL2, String paymentType, String tenderAmount) throws Exception {
                FiscalResponse R = new FiscalResponse(0);
                if (this.isConnectedPrinter()) {
                    R = FiscalSale.getConnectedPrinterV1().command53Variant0Version0(sDescriptionL1, sDescriptionL2, paymentType, tenderAmount);
                }
                if (this.isConnectedECR()) {
                    R = FiscalSale.getConnectedECRV1().command53Variant0Version0(sDescriptionL1, sDescriptionL2, paymentType, tenderAmount);
                }
                TotalResult totalRes = new TotalResult();
                switch (R.get("PaidCode")) {
                    case "F": {
                        totalRes.setCode(TotalResult.PaidCode.unknowTotalError);
                        break;
                    }
                    case "E": {
                        totalRes.setCode(TotalResult.PaidCode.negativeAmount);
                        break;
                    }
                    case "D": {
                        totalRes.setCode(TotalResult.PaidCode.amountUnderTotal);
                        break;
                    }
                    case "R": {
                        totalRes.setCode(TotalResult.PaidCode.amountGreaterTotal);
                        break;
                    }
                    case "I": {
                        totalRes.setCode(TotalResult.PaidCode.amountTaxGroupNegative);
                        break;
                    }
                    default: {
                        totalRes.setCode(null);
                    }
                }
                totalRes.setAmount(R.get("Amount_Out"));
                return totalRes;
            }

            public void setsDescriptionL1(String sDescriptionL1) {
                this.sDescriptionL1 = sDescriptionL1;
            }

            public void setsDescriptionL2(String sDescriptionL2) {
                this.sDescriptionL2 = sDescriptionL2;
            }

            public void setsTaxCd(String sTaxCd) {
                this.sTaxCd = sTaxCd;
            }

            public void setsDept(String sDept) {
                this.sDept = sDept;
            }

            public void setsPrice(String sPrice) {
                this.sPrice = sPrice;
            }

            public void setsQwan(String sQwan) {
                this.sQwan = sQwan;
            }

            public void setsDiscountType(String sDiscountType) {
                this.sDiscountType = sDiscountType;
            }

            public String getsDiscValueStr() {
                return this.sDiscValueStr;
            }

            public void setsDiscValueStr(String sDiscValueStr) {
                this.sDiscValueStr = sDiscValueStr;
            }

            public void setsPLU(String sPLU) {
                this.sPLU = sPLU;
            }

            public static enum CorrectionType {
                noCorecction,
                surchargePercentage,
                discountPercentage,
                surchargeSum,
                discountSum;

                private static CorrectionType[] allValues;

                public static CorrectionType fromOrdinal(int n) {
                    return allValues[n];
                }

                static {
                    allValues = CorrectionType.values();
                }
            }
        }

        public static enum FreeFiscalTextType {
            type32dpiA,
            type32dpiB,
            type24dpi,
            type16dpy;

        }
    }

    public static class NonFiscalReceipt
    extends cmdReceipt {
        public Integer open() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = NonFiscalReceipt.getConnectedECRV1().command38Variant0Version0();
            }
            if (this.isConnectedPrinter()) {
                R = cmdReceipt.getConnectedPrinterV1().command38Variant0Version0();
            }
            this.allReceipt = R.get("Allreceipt");
            this.checkErrorCode();
            return Integer.valueOf(this.allReceipt);
        }

        public int closeNonFiscalReceipt() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdReceipt.getConnectedECRV1().command39Variant0Version0();
            }
            if (this.isConnectedPrinter()) {
                R = NonFiscalReceipt.getConnectedPrinterV1().command39Variant0Version0();
            }
            this.allReceipt = R.get("Allreceipt");
            this.checkErrorCode();
            return Integer.valueOf(this.allReceipt);
        }

        public boolean isOpen() {
            boolean bitResult = true;
            if (this.isConnectedECR()) {
                bitResult = cmdReceipt.getConnectedECRV1().getStatusBitBol(2, 5);
            }
            if (this.isConnectedPrinter()) {
                bitResult = NonFiscalReceipt.getConnectedPrinterV1().getStatusBitBol(2, 5);
            }
            return bitResult;
        }

        public void printNonFiscalText(String text) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdReceipt.getConnectedECRV1().command42Variant0Version0(text);
            }
            if (this.isConnectedPrinter()) {
                R = NonFiscalReceipt.getConnectedPrinterV1().command42Variant0Version0(text);
            }
            this.checkErrorCode();
            this.allReceipt = R.get("Allreceipt");
        }

        public void printNonFiscalText(String text, String height) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdReceipt.getConnectedECRV1().command42Variant1Version0(height, text);
            }
            if (this.isConnectedPrinter()) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            this.checkErrorCode();
            this.allReceipt = R.get("Allreceipt");
        }

        public void printNonFiscalText(String text, String height, boolean bold, boolean italic, boolean doubleHigh) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            String flags = (bold ? "B" : "") + (italic ? "I" : "") + (doubleHigh ? "H" : "");
            if (this.isConnectedPrinter()) {
                R = NonFiscalReceipt.getConnectedPrinterV1().command42Variant1Version0(text, height, flags);
            }
            this.checkErrorCode();
            this.allReceipt = R.get("Allreceipt");
        }

        public void printSeparatingLine(String type) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            if (this.isConnectedPrinter()) {
                R = NonFiscalReceipt.getConnectedPrinterV1().command92Variant0Version0("W" + type);
            }
            this.checkErrorCode();
        }
    }

    public static enum PaidMode {
        CashPayment('P'),
        CreditPayment('N'),
        CheckPayment('C'),
        DebitCardPayment('D'),
        ProgrammablePayment1('i'),
        ProgrammablePayment2('j'),
        ProgrammablePayment3('k'),
        ProgrammablePayment4('l'),
        Coupons('m'),
        ExternalCoupons('n'),
        Packaging('o'),
        InternalService('p'),
        Damage('q'),
        BankTransfers('r'),
        WithCheck('s');

        private final char id;
        private static PaidMode[] allValues;

        private PaidMode(char id) {
            this.id = id;
        }

        public String getId() {
            return String.valueOf(this.id);
        }

        public static PaidMode fromOrdinal(int n) {
            return allValues[n];
        }

        static {
            allValues = PaidMode.values();
        }
    }

    public static class TotalResult {
        private String Amount;
        private PaidCode code;

        public String getAmount() {
            return this.Amount;
        }

        public void setAmount(String amount) {
            this.Amount = amount;
        }

        public PaidCode getCode() {
            return this.code;
        }

        public void setCode(PaidCode code) {
            this.code = code;
        }

        public static enum PaidCode {
            unknowTotalError,
            negativeAmount,
            amountUnderTotal,
            amountGreaterTotal,
            amountTaxGroupNegative;

        }
    }

    public static class InvoiceClientInfo
    extends cmdReceipt {
        private String Bulstat = "";
        private BulstatType TypeBULSTAT;
        private String Seller = "";
        private String Receiver = "";
        private String Client = "";
        private String ClientTaxNo = "";
        private String ClientAddress1 = "";
        private String ClientAddress2 = "";
        private String AccountablePerson = "";

        public InvoiceClientInfo(String bulstat, BulstatType typeOfBulstat, String seller, String receiver, String client, String clientTaxNo, String clientAddress1, String clientAddress2, String accountablePerson) {
            this.Bulstat = bulstat;
            this.TypeBULSTAT = typeOfBulstat;
            this.Seller = seller;
            this.Receiver = receiver;
            this.Client = client;
            this.ClientTaxNo = clientTaxNo;
            this.ClientAddress1 = clientAddress1;
            this.ClientAddress2 = clientAddress2;
            this.AccountablePerson = accountablePerson;
        }

        public String getAccountablePerson() {
            return this.AccountablePerson;
        }

        public void setAccountablePerson(String accountablePerson) {
            this.AccountablePerson = accountablePerson;
        }

        public BulstatType getTypeBULSTAT() {
            return this.TypeBULSTAT;
        }

        public void setTypeBULSTAT(BulstatType typeBULSTAT) {
            this.TypeBULSTAT = typeBULSTAT;
        }

        public String getClientAddress1() {
            return this.ClientAddress1;
        }

        public void setClientAddress1(String clientAddress1) {
            this.ClientAddress1 = clientAddress1;
        }

        public String getClientAddress2() {
            return this.ClientAddress2;
        }

        public void setClientAddress2(String clientAddress2) {
            this.ClientAddress2 = clientAddress2;
        }

        public InvoiceClientInfo(String EIK, String seller, String receiver, String client, String clientTaxNo, String clientAddress1, String clientAddress2) {
            this.Bulstat = EIK;
            this.Seller = seller;
            this.Receiver = receiver;
            this.Client = client;
            this.ClientTaxNo = clientTaxNo;
            this.ClientAddress1 = clientAddress1;
            this.ClientAddress2 = clientAddress2;
        }

        public InvoiceClientInfo(String bulstat, BulstatType typeBULSTAT, String seller, String receiver, String client, String clientTaxNo, String clientAddress1, String clientAddress2) {
            this.Bulstat = bulstat;
            this.TypeBULSTAT = typeBULSTAT;
            this.Seller = seller;
            this.Receiver = receiver;
            this.Client = client;
            this.ClientTaxNo = clientTaxNo;
            this.ClientAddress1 = clientAddress1;
            this.ClientAddress2 = clientAddress2;
        }

        public InvoiceClientInfo(String EIK, BulstatType typeOfEIK) {
            this.Bulstat = EIK;
            this.TypeBULSTAT = typeOfEIK;
        }

        public boolean[] isValid() {
            boolean[] res = new boolean[7];
            switch (this.TypeBULSTAT) {
                case EIK: {
                    res[0] = EIKValidator.isValid(this.Bulstat);
                    break;
                }
                case EGN: {
                    res[0] = new EGNValidator(this.Bulstat).isValid();
                    break;
                }
                case PersonalNum: {
                    res[0] = true;
                    break;
                }
                case ServiceNum: {
                    res[0] = true;
                    break;
                }
                default: {
                    res[0] = false;
                }
            }
            if (this.isConnectedECR()) {
                res[1] = this.Seller.matches(RegExpr._UpTo36Symbol);
                res[2] = this.Receiver.matches(RegExpr._UpTo36Symbol);
                res[3] = this.Client.matches(RegExpr._UpTo36Symbol);
                res[4] = this.ClientTaxNo.matches("^|[\\w|\\W]{10,14}");
                res[5] = this.ClientAddress1.matches(RegExpr._UpTo36Symbol);
                res[6] = this.ClientAddress2.matches(RegExpr._UpTo36Symbol);
            } else if (this.isConnectedPrinter()) {
                res[1] = this.Seller.matches(RegExpr._UpTo26Symbol);
                res[2] = this.Receiver.matches(RegExpr._UpTo26Symbol);
                res[3] = this.Client.matches(RegExpr._UpTo26Symbol);
                res[4] = this.ClientTaxNo.matches("^|[\\w|\\W]{10,14}");
                res[5] = this.ClientAddress1.matches(RegExpr._UpTo28Symbol);
                res[6] = this.ClientAddress2.matches(RegExpr._UpTo34Symbol);
            }
            return res;
        }

        public void saveClientInfo() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            String clientAddress = "";
            if (this.ClientAddress1.length() > 0) {
                clientAddress = clientAddress + this.ClientAddress1;
            }
            if (this.ClientAddress2.length() > 0) {
                clientAddress = clientAddress + "\n" + this.ClientAddress2;
            }
            if (this.isConnectedECR()) {
                R = cmdReceipt.getConnectedECRV1().command57Variant1Version0(String.valueOf(this.TypeBULSTAT.ordinal()), this.Bulstat, this.Seller, this.Receiver, this.Client, this.ClientTaxNo, clientAddress);
            }
            if (this.isConnectedPrinter()) {
                String sTypeOfBulstat = "";
                switch (this.TypeBULSTAT) {
                    case EGN: {
                        sTypeOfBulstat = "#";
                        break;
                    }
                    case EIK: {
                        sTypeOfBulstat = "";
                        break;
                    }
                    case PersonalNum: {
                        sTypeOfBulstat = "*";
                        break;
                    }
                    case ServiceNum: {
                        sTypeOfBulstat = "^";
                    }
                }
                R = cmdReceipt.getConnectedPrinterV1().command57Variant2Version0(sTypeOfBulstat, this.Bulstat, this.Seller, this.Receiver, this.Client, this.ClientTaxNo, clientAddress, this.AccountablePerson);
            }
            this.checkErrorCode();
        }

        public void printClientInfo() throws Exception {
            this.saveClientInfo();
        }

        public void printClientInfo(BulstatType typeBULSTAT, String bulstat, String seller, String receiver, String client, String clientTaxNo, String clientAddress1, String clientAddress2, String accountablePerson) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            String clientAddress = "";
            if (clientAddress1.length() > 0) {
                clientAddress = clientAddress + clientAddress1;
            }
            if (clientAddress2.length() > 0) {
                clientAddress = clientAddress + "\n" + clientAddress2;
            }
            if (this.isConnectedECR()) {
                R = cmdReceipt.getConnectedECRV1().command57Variant1Version0(String.valueOf(typeBULSTAT.ordinal()), bulstat, seller, receiver, client, clientTaxNo, clientAddress);
            }
            if (this.isConnectedPrinter()) {
                String sTypeOfBulstat = "";
                switch (typeBULSTAT) {
                    case EGN: {
                        sTypeOfBulstat = "#";
                        break;
                    }
                    case EIK: {
                        sTypeOfBulstat = "";
                        break;
                    }
                    case PersonalNum: {
                        sTypeOfBulstat = "*";
                        break;
                    }
                    case ServiceNum: {
                        sTypeOfBulstat = "^";
                    }
                }
                R = cmdReceipt.getConnectedPrinterV1().command57Variant2Version0(sTypeOfBulstat, bulstat, seller, receiver, client, clientTaxNo, clientAddress, accountablePerson);
            }
            this.checkErrorCode();
        }

        public void saveClientInfo(String EIK, String seller, String receiver, String client, String clientTaxNo, String clientAddress1, String clientAddress2) throws Exception {
            this.printClientInfo(BulstatType.EIK, EIK, seller, receiver, client, clientTaxNo, clientAddress1, clientAddress2, this.AccountablePerson == null ? "" : this.AccountablePerson);
        }

        public String getBulstat() {
            return this.Bulstat;
        }

        public void setBulstat(String bulstat) {
            this.Bulstat = bulstat;
        }

        public String getSeller() {
            return this.Seller;
        }

        public void setSeller(String seller) {
            this.Seller = seller;
        }

        public String getReceiver() {
            return this.Receiver;
        }

        public void setReceiver(String receiver) {
            this.Receiver = receiver;
        }

        public String getClient() {
            return this.Client;
        }

        public void setClient(String client) {
            this.Client = client;
        }

        public String getClientTaxNo() {
            return this.ClientTaxNo;
        }

        public void setClientTaxNo(String clientTaxNo) {
            this.ClientTaxNo = clientTaxNo;
        }

        public static enum BulstatType {
            EIK,
            EGN,
            PersonalNum,
            ServiceNum;

            private static BulstatType[] allValues;

            public static BulstatType fromOrdinal(int n) {
                return allValues[n];
            }

            static {
                allValues = BulstatType.values();
            }
        }
    }

    public static enum BarcodeType {
        EAN8('1'),
        EAN13('2'),
        Code128('3'),
        ITF1('4'),
        ITF2('5'),
        DataMatrix('D'),
        QRcode('Q'),
        PDF417('P');

        private final char id;
        private static BarcodeType[] allValues;

        private BarcodeType(char id) {
            this.id = id;
        }

        public String getId() {
            return String.valueOf(this.id);
        }

        public static BarcodeType fromOrdinal(int n) {
            return allValues[n];
        }

        static {
            allValues = BarcodeType.values();
        }
    }

    public static enum SeparatingLine {
        dash,
        dash_space,
        equal;

    }
}

