import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdConfig;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdEJournal;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;

import javax.swing.*;
import java.awt.event.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;


public class DialogEJSearch extends JFrame {
    private cmdEJournal.InfoEJ infoEJ;
    private JPanel contentPane;
    private JButton btnReadEJ;
    private JButton buttonCancel;
    private JComboBox cbxDocType;
    private JTextField edFromDate;
    private JTextField edFromTime;
    private JTextField edToDate;
    private JTextField edToTime;
    private JCheckBox chbxByDocNumber;
    private JTextField edFromNum;
    private JTextField edToNum;
    private JButton btnPrintEJ;
    private JLabel lbDocType;
    private JLabel lbFromDate;
    private JLabel lbToDate;
    private JLabel lbFromNum;
    private JLabel lbToNum;
    private JTextArea ejTextMonitor;
    private JProgressBar progBar;
    private JCheckBox chkInZReportNuber;
    private JTextField edFromZ;
    private JTextField edToZ;
    private JLabel labFromZ;
    private JCheckBox chbCondensedFont;
    private JScrollPane edEJMonitor;
    private cmdEJournal myEJournal = new cmdEJournal();
    private cmdInfo myDeviceInfo = new cmdInfo();
    private cmdConfig myConfig = new cmdConfig();


    public DialogEJSearch() {
        setContentPane(contentPane);
        //setModal(true);
        getRootPane().setDefaultButton(btnReadEJ);

        // Init EJ Search parameters
        try {
            infoEJ = myEJournal.readEjInfo();
            String textInfo = "";
            if (MainFormAB.myFiscalDevice.isConnectedECR()) {
                textInfo = "EJ Id number for the device......:" + infoEJ.getNumber() + "\n\r" +
                        "Date and time of EJ activation:" + infoEJ.getDateTime() + "\n\r";
            }
            textInfo += "Size of the EJ......:" + infoEJ.getSize() + " MB\n\r" +
                    "Used......:" + infoEJ.getUsed() + " MB\n\r" +
                    "First Z report number......:" + infoEJ.getFromZ() + "\n\r" +
                    "Last Z report number......:" + infoEJ.getToZ() + "\n\r" +
                    "First Document number......:" + infoEJ.getFromDoc() + "\n\r" +
                    "Last Document number......:" + infoEJ.getToDoc() + "\n\r";

            String sECRFix = "";
            if (MainFormAB.myFiscalDevice.isConnectedPrinter()) sECRFix = "HHmmss";
            Date dateOfLastFiscalRecord = new SimpleDateFormat("ddMMyy" + sECRFix).parse(myDeviceInfo.GetLastFiscalRecordDate());
            DateFormat dateFormat = new SimpleDateFormat("dd-MM-yy");
            DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            String dateString = dateFormat.format(dateOfLastFiscalRecord);
            String timeString = timeFormat.format(dateOfLastFiscalRecord);
            // LocalDateTime now = LocalDateTime.now();

            ejTextMonitor.setText(textInfo);
            edFromDate.setText(dateString); // Indicative start date for the reporting period
            edFromTime.setText(timeString);
            edToDate.setText(dateString);
            edToTime.setText(timeString);
            edFromNum.setText(infoEJ.getFromDoc());
            edToNum.setText(infoEJ.getToDoc());
            if (MainFormAB.myFiscalDevice.isConnectedECR()) populateDocTypeCombo(new String[]{
                    "All",
                    "Fiscal Recipt",
                    "Daily Z report",
                    "Cash in",
                    "Cash Out",
                    "Daily X Report",
                    "Service ( None fiscal )",
                    "Invoice",
                    "Storno",
                    "Storno Invoices"
            });

            if (MainFormAB.myFiscalDevice.isConnectedPrinter()) populateDocTypeCombo(new String[]{
                    "All document types.",
                    "Fiscal (customer) receipts.",
                    "Refund (storno) receipts.",
                    "Cancelled (customer) receipts.",
                    "Service receipts.",
                    "Service deposit receipts.",
                    "Service withdrawal receipts.",
                    "Service receipts with 90-degree rotated printing.",
                    "Service operation receipts.",
                    "Reports (only date/time and receipt number information)",
                    "X-reports.",
                    "Z-reports."
            });

        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

        btnReadEJ.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ReadEJ();
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        chbxByDocNumber.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean byDate = !chbxByDocNumber.isSelected();
                lbFromDate.setEnabled(byDate);
                edFromDate.setEnabled(byDate);
                edFromTime.setEnabled(byDate);
                lbToDate.setEnabled(byDate);
                edToDate.setEnabled(byDate);
                edToTime.setEnabled(byDate);
                lbFromNum.setEnabled(!byDate);
                edFromNum.setEnabled(!byDate);
                lbToNum.setEnabled(!byDate);
                edToNum.setEnabled(!byDate);
                chkInZReportNuber.setEnabled(!byDate);
                labFromZ.setEnabled(!byDate);
                edFromZ.setEnabled(chkInZReportNuber.isSelected());
            }
        });

        cbxDocType.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    switch (cmdEJournal.EjDocTypePrn.fromOrdinal(cbxDocType.getSelectedIndex())) {
                        case daily_xreports:
                        case daily_zreports:
                            edToNum.setText(infoEJ.getFromZ());
                            edToNum.setText(infoEJ.getToZ());
                            break;
                        default:
                            edFromNum.setText(infoEJ.getFromDoc());
                            edToNum.setText(infoEJ.getToDoc());
                            break;
                    }
                } catch (Exception ex) {
                    MainFormAB.errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        edFromNum.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edFromNum);
            }
        });

        edToNum.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edToNum);
            }
        });
        chkInZReportNuber.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                edFromZ.setEnabled(chkInZReportNuber.isSelected());
            }
        });

        edFromZ.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edFromZ);
            }
        });


        btnPrintEJ.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                progBar.setValue(0);
                progBar.setMaximum(100);
                progBar.setStringPainted(false);
                ejTextMonitor.setText("");

                //Fake progBar
                final boolean[] runProgress = {true};
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        while (!runProgress[0]) {
                            SwingUtilities.invokeLater(new Runnable() {
                                public void run() {
                                    progBar.setValue(progBar.getValue() + 1);
                                    if (progBar.getValue() == progBar.getMaximum())
                                        progBar.setValue(progBar.getMinimum());
                                }
                            });
                            try {
                                Thread.sleep(100);
                            } catch (InterruptedException e) {

                            }
                        }
                    }
                }).start();

                //Read EJ
                new Thread(new Runnable() {
                    final String[] readDocsList = {""};

                    @Override
                    public void run() {
                        final int[] printedCount = {0};
                        boolean isPrintByNumber = chbxByDocNumber.isSelected();
                        boolean isSearchInZreports = chkInZReportNuber.isSelected();
                        // do the thing that takes a long time
                        try {
                            // FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F/ FMP-10 / FP-550
                            if (MainFormAB.myFiscalDevice.isConnectedPrinter())
                                if (isPrintByNumber) //Search by number
                                {
                                    if (!isSearchInZreports)
                                        myEJournal.printEjDocumentsByNumbersRange(
                                                chbCondensedFont.isSelected(),
                                                edFromNum.getText(),
                                                edToNum.getText(), cmdEJournal.EjDocTypePrn.fromOrdinal(cbxDocType.getSelectedIndex()));
                                    else {
                                        myEJournal.printEjDocumentsInZReport(
                                                chbCondensedFont.isSelected(),
                                                edFromNum.getText(),
                                                edToNum.getText(),
                                                edFromZ.getText(),
                                                cmdEJournal.EjDocTypePrn.fromOrdinal(cbxDocType.getSelectedIndex())
                                        );
                                    }

                                } else //Print by Date
                                {
                                    myEJournal.printEjDocumentsByDateRange(
                                            chbCondensedFont.isSelected(),
                                            edFromDate.getText().replace("-", "") + edFromTime.getText().replace(":", ""),
                                            edToDate.getText().replace("-", "") + edToTime.getText().replace(":", ""),
                                            cmdEJournal.EjDocTypePrn.fromOrdinal((int) cbxDocType.getSelectedIndex()));
                                }

                            //else // DP-05, DP-25, DP-35, WP-50, DP-150
                            if (MainFormAB.myFiscalDevice.isConnectedECR()) {
                                if (isPrintByNumber) //Print by number
                                {
                                    if (isSearchInZreports) {
                                        //Search for documents by day order number 1,2,3 ... in Z reports range
                                        printedCount[0] = myEJournal.printEjDocumentsInZReportRange(
                                                edFromNum.getText().toString(),
                                                edToNum.getText().toString(),
                                                edFromZ.getText().toString(),
                                                edToZ.getText().toString(),
                                                String.valueOf(cbxDocType.getSelectedIndex())); //0,1,2...8);

                                    } else
                                        printedCount[0] = myEJournal.printEjDocumentsByNumbersRange(
                                                String.valueOf(cbxDocType.getSelectedIndex()), //0,1,2...8
                                                edFromNum.getText(),
                                                edToNum.getText());

                                } else //..by DateTime
                                {   //Use overwrite version of printEjDocumentsByDateRange for ECR !
                                    printedCount[0] = myEJournal.printEjDocumentsByDateRange(
                                            String.valueOf(cbxDocType.getSelectedIndex()),
                                            edFromDate.getText().replace("-", "") + edFromTime.getText().replace(":", ""),
                                            edToDate.getText().replace("-", "") + edToTime.getText().replace(":", ""));
                                }

                            }

                            SwingUtilities.invokeLater(new Runnable() {
                                public void run() {
                                    runProgress[0] = false;
                                    progBar.setValue(progBar.getMaximum());
                                    ejTextMonitor.setText(readDocsList[0]);
                                }
                            });
                        } catch (Exception e) {
                            runProgress[0] = false;
                            e.printStackTrace();
                            MainFormAB.errListModel.add(0, e.getMessage());
                        }
                    }
                }).start();
            }
        });
    }

    private void populateDocTypeCombo(String[] docType) {
        cbxDocType.setModel(new DefaultComboBoxModel(docType));
    }

    private void checkInput(JTextField tf) {
        try {
            long number = Long.parseLong(tf.getText());
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(rootPane, "Only Numbers Allowed");
            tf.setSelectionStart(tf.getText().length() - 1);
        }

    }

    private void ReadEJ() {
        progBar.setValue(0);
        progBar.setMaximum(100);
        progBar.setStringPainted(false);
        ejTextMonitor.setText("");
        final boolean[] runProgressBar = {true};
        //Fake progBar
        new Thread(new Runnable() {
            @Override
            public void run() {
                while (runProgressBar[0]) {
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            progBar.setValue(progBar.getValue() + 1);
                            if (progBar.getValue() == progBar.getMaximum()) progBar.setValue(progBar.getMinimum());
                        }
                    });
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e) {

                    }
                }
            }
        }).start();
        //Read EJ
        new Thread(new Runnable() {
            final String[] readDocsList = {""};

            @Override
            public void run() {

                // do the thing that takes a long time
                try {
                    // FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F/ FMP-10 / FP-550
                    boolean isSearchByNumber = chbxByDocNumber.isSelected();
                    boolean isSearchInZreports = chkInZReportNuber.isSelected();
                    if (MainFormAB.myFiscalDevice.isConnectedPrinter())
                        if (isSearchByNumber) //Search by number
                        {
                            if (isSearchInZreports)
                                readDocsList[0] = myEJournal.readEjDocumentsInZReport(
                                        edFromNum.getText(),
                                        edToNum.getText(),
                                        edFromZ.getText(),
                                        cmdEJournal.EjDocTypePrn.fromOrdinal(cbxDocType.getSelectedIndex())
                                );
                            else {
                                readDocsList[0] = myEJournal.readEjDocumentsByNumbersRange(
                                        edFromNum.getText(),
                                        edToNum.getText(),
                                        cmdEJournal.EjDocTypePrn.fromOrdinal(cbxDocType.getSelectedIndex())
                                );
                            }

                        } else //..by DateTime
                        {
                            readDocsList[0] = myEJournal.readEjDocumentsByDateRange(
                                    edFromDate.getText().replace("-", "") + edFromTime.getText().replace(":", ""),
                                    edToDate.getText().replace("-", "") + edToTime.getText().replace(":", ""),
                                    cmdEJournal.EjDocTypePrn.fromOrdinal((int) cbxDocType.getSelectedIndex()));
                        }

                    //else // DP-05, DP-25, DP-35, WP-50, DP-150
                    if (MainFormAB.myFiscalDevice.isConnectedECR()) {
                        if (isSearchByNumber) //Search by number
                        {
                            if (isSearchInZreports) {
                                //Search for documents by day order number 1, 2,3 ... in Z reports range
                                readDocsList[0] = myEJournal.readEjDocumentsInZReports(
                                        edFromNum.getText(),
                                        edToNum.getText(),
                                        edFromZ.getText(),
                                        edToZ.getText(),
                                        String.valueOf(cbxDocType.getSelectedIndex()) //0,1,2...8);
                                );

                            } else //by Number range
                                readDocsList[0] = myEJournal.readEjDocumentsByNumbersRange(
                                        String.valueOf(cbxDocType.getSelectedIndex()), //0,1,2...8
                                        edFromNum.getText(),
                                        edToNum.getText());

                        } else //..by DateTime
                        {   //Use overwrite version of readEjDocumentsByDateRange for ECR !
                            readDocsList[0] = myEJournal.readEjDocumentsByDateRange(
                                    String.valueOf(cbxDocType.getSelectedIndex()),
                                    edFromDate.getText().replace("-", "") + edFromTime.getText().replace(":", ""),
                                    edToDate.getText().replace("-", "") + edToTime.getText().replace(":", ""));
                        }

                    }
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            runProgressBar[0] = false;
                            progBar.setValue(progBar.getMaximum());
                            ejTextMonitor.setText(readDocsList[0]);
                        }
                    });
                } catch (Exception e) {
                    runProgressBar[0] = false;
                    e.printStackTrace();
                    MainFormAB.errListModel.add(0, e.getMessage());
                }
            }
        }).start();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogEJSearch dialog = new DialogEJSearch();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
