import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdEJournal;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;

import javax.swing.*;
import java.awt.event.*;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


public class DialogStructEjInfo extends JFrame {
    private cmdEJournal.InfoEJ infoEJ;
    private JPanel contentPane;
    private JButton btnReadEJ;
    private JButton btnExport;
    private JComboBox cbxDocType;
    private JTextField edFromDate;
    private JTextField edFromTime;
    private JTextField edToDate;
    private JTextField edToTime;
    private JCheckBox chbxByDocNumber;
    private JTextField edFromNum;
    private JTextField edToNum;
    private JLabel lbFromDate;
    private JLabel lbToDate;
    private JLabel lbFromNum;
    private JLabel lbToNum;
    private JProgressBar progBarAllDocs;
    private JProgressBar progBarDoc;
    private JTextArea docPane;
    private cmdInfo myDeviceInfo = new cmdInfo();


    public DialogStructEjInfo() {
        setContentPane(contentPane);
        getRootPane().setDefaultButton(btnReadEJ);

        // Init EJ Search parameters
        try {
            infoEJ = new cmdEJournal().readEjInfo();
            String textInfo = "";
            if (MainFormAB.myFiscalDevice.isConnectedECR()) {
                textInfo = "EJ Id number for the device:\t" + infoEJ.getNumber() + "\n\r" +
                        "Date and time of EJ activation:\t" + infoEJ.getDateTime() + "\n\r";
            }
            textInfo += "Size of the EJ:\t" + infoEJ.getSize() + " MB\n\r" +
                    "Used:\t" + infoEJ.getUsed() + " MB\n\r" +
                    "First Z report number:\t" + infoEJ.getFromZ() + "\n\r" +
                    "Last Z report number:\t" + infoEJ.getToZ() + "\n\r" +
                    "First Document number:\t" + infoEJ.getFromDoc() + "\n\r" +
                    "Last Document number:\t" + infoEJ.getToDoc() + "\n\r";

            String sECRFix = "";
            if (MainFormAB.myFiscalDevice.isConnectedPrinter()) sECRFix = "HHmmss";
            Date dateOfLastFiscalRecord = new SimpleDateFormat("ddMMyy" + sECRFix).parse(myDeviceInfo.GetLastFiscalRecordDate());
            DateFormat dateFormat = new SimpleDateFormat("dd-MM-yy");
            DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            String dateString = dateFormat.format(dateOfLastFiscalRecord);
            String timeString = timeFormat.format(dateOfLastFiscalRecord);
            // LocalDateTime now = LocalDateTime.now();

            docPane.append(textInfo);
            edFromDate.setText(dateString); // Indicative start date for the reporting period
            edFromTime.setText(timeString);
            edToDate.setText(dateString);
            edToTime.setText(timeString);
            edFromNum.setText(infoEJ.getFromDoc());
            edToNum.setText(infoEJ.getToDoc());

        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

        btnReadEJ.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    if (MainFormAB.getConnectedFD().isConnectedECR()) ReadEJ_B();
                    else if (MainFormAB.getConnectedFD().isConnectedPrinter()) ReadEJ_A();

                } catch (Exception exception) {
                    MainFormAB.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }

            }
        });

        btnExport.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {

                final JFileChooser SaveAs = new JFileChooser();
                SaveAs.setApproveButtonText("Save");
                int actionDialog = SaveAs.showOpenDialog(getParent());
                if (actionDialog != JFileChooser.APPROVE_OPTION) {
                    return;
                }

                File fileName = new File(SaveAs.getSelectedFile() + ".txt");
                BufferedWriter outFile = null;
                try {
                    outFile = new BufferedWriter(new FileWriter(fileName));
                    docPane.write(outFile);

                } catch (IOException ex) {
                    ex.printStackTrace();
                } finally {
                    if (outFile != null) {
                        try {
                            outFile.close();
                        } catch (IOException exception) {
                            MainFormAB.errListModel.add(0, exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }

            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        chbxByDocNumber.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean byDate = !chbxByDocNumber.isSelected();
                lbFromDate.setEnabled(byDate);
                edFromDate.setEnabled(byDate);
                edFromTime.setEnabled(byDate);
                lbToDate.setEnabled(byDate);
                edToDate.setEnabled(byDate);
                edToTime.setEnabled(byDate);
                lbFromNum.setEnabled(!byDate);
                edFromNum.setEnabled(!byDate);
                lbToNum.setEnabled(!byDate);
                edToNum.setEnabled(!byDate);

            }
        });

        cbxDocType.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    switch (cmdEJournal.EjDocTypePrn.fromOrdinal(cbxDocType.getSelectedIndex())) {
                        case daily_xreports:
                        case daily_zreports:
                            edToNum.setText(infoEJ.getFromZ());
                            edToNum.setText(infoEJ.getToZ());
                            break;
                        default:
                            edFromNum.setText(infoEJ.getFromDoc());
                            edToNum.setText(infoEJ.getToDoc());
                            break;
                    }
                } catch (Exception ex) {
                    MainFormAB.errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        edFromNum.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edFromNum);
            }
        });

        edToNum.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edToNum);
            }
        });

    }


    private void checkInput(JTextField tf) {
        try {
            long number = Long.parseLong(tf.getText());
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(rootPane, "Only Numbers Allowed");
            tf.setSelectionStart(tf.getText().length() - 1);
        }

    }

    private void ReadEJ_A() {
        cmdEJStructInfoA cmd = new cmdEJStructInfoA();
        progBarAllDocs.setValue(0);
        progBarAllDocs.setStringPainted(false);
        docPane.setText("");
        new Thread(new Runnable() {
            @Override
            public void run() {
                if (chbxByDocNumber.isSelected()) { //Search EJ by Number of Documents
                    int p = 0;
                    int fromN = Integer.parseInt(edFromNum.getText());
                    int toN = Integer.parseInt(edToNum.getText());
                    progBarAllDocs.setMaximum(toN - fromN);
                    // do the thing that takes a long time
                    try {
                        for (int nDoc = fromN; nDoc <= toN; nDoc++) {
                            String readDocData = "";
                            docPane.append("\n=============================:" + nDoc);
                            String readLine = cmd.readStructuredInformation_FirstLine(nDoc);
                            if (readLine.startsWith("F")) continue;
                            while (!readLine.startsWith("*")) {
                                readDocData += "\n" + cmd.DecodeLine(readLine);
                                readLine = cmd.readStructuredInformation_NextLine();
                                progBarDoc.setIndeterminate(true);
                            }
                            docPane.append(readDocData);
                            progBarAllDocs.setValue(p++);
                            progBarDoc.setIndeterminate(false);
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else //Search Ej structured info by Date Time
                {
                    try {
                        progBarDoc.setIndeterminate(true);
                        List<String> dd = cmd.readDocumentsInPeriod(
                                edFromDate.getText() + edFromTime.getText(),
                                edToDate.getText() + edFromTime.getText());
                        int j = 1;
                        for (String s : dd) {
                            docPane.append("\n------------------:" + j + "\n");
                            docPane.append(s);
                            j++;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        progBarDoc.setIndeterminate(false);
                        btnExport.setEnabled(docPane.getText().length() > 0);
                    }
                });
            }
        }).start();
    }

    private void ReadEJ_B() {
        cmdEJStructInfoB cmd = new cmdEJStructInfoB();
        progBarDoc.setIndeterminate(false);
        progBarAllDocs.setValue(0);
        progBarAllDocs.setStringPainted(true);
        docPane.setText("");
        new Thread(new Runnable() {
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    cmdEJStructInfoB myEjStructInfo = new cmdEJStructInfoB();
                    if (chbxByDocNumber.isSelected()) { //Search EJ by Number of Documents
                        int p = 0;
                        int fromN = Integer.parseInt(edFromNum.getText());
                        int toN = Integer.parseInt(edToNum.getText());
                        progBarAllDocs.setMaximum(toN - fromN);
                        if (fromN > toN) toN = fromN;
                        for (int i = fromN; i <= toN; i++) {
                            cmdEJournal.EJ_DocumentsFound df = new cmdEJStructInfoB().set_SearchByNumber(cmdEJStructInfoB.DocTypeToRead.all_types, String.valueOf(i));
                            if (df != null) {
                                progBarDoc.setIndeterminate(true);
                                if (Integer.valueOf(df.getDocNumber()) == i)
                                    docPane.append(cmdEJStructInfoB.DocInfo.DocumentType.values()[Integer.parseInt(df.getType())].name() +
                                            "------" + df.getDocNumber() + "\t-----" + df.getDate() + "\n\r");
                                docPane.append(cmd.readEjLinesToString());
                            }
                            progBarAllDocs.setValue(p++);
                            progBarDoc.setIndeterminate(false);
                        }

                    } else { //Search EJ by Data Time of Documents
                        progBarDoc.setIndeterminate(true);
                        String fromDT = edFromDate.getText().replace("-", "") + edFromTime.getText().replace(":", "");
                        String toDT = edToDate.getText().replace("-", "") + edToTime.getText().replace(":", "");

                        int[] docRange = myEjStructInfo.SearchDocumentsInPeriod(fromDT, toDT);
                        progBarAllDocs.setMaximum(docRange.length);
                        int p = 0;
                        for (int docNum : docRange) {
                            docPane.append("\t------" + docNum + "\n\r");
                            docPane.append(myEjStructInfo.ReadDocumentByNumber(docNum));
                            progBarAllDocs.setValue(p++);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            progBarAllDocs.setValue(progBarAllDocs.getMaximum());
                            btnExport.setEnabled(docPane.getText().length() > 0);
                            progBarDoc.setIndeterminate(false);
                        }
                    });
                } catch (Exception e) {
                    progBarAllDocs.setValue(0);
                    e.printStackTrace();
                    MainFormAB.errListModel.add(0, e.getMessage());
                }
            }
        }).start();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogStructEjInfo dialog = new DialogStructEjInfo();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
