/**
 * @author DatecsSoft_Team
 */
package connectivity;

import com.datecs.fiscalprinter.SDK.model.BGR.FDModelDetectorV1;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import static com.datecs.fiscalprinter.SDK.FiscalException.FPTR_CC_OTHER;
public class SerialPrinterConnector implements PrinterConnection {

     /*
         The instance ot DatecsFiscalDevice by method  setConnectedModel(  TransportProtocol ),
         perform a set up a Datecs JavaSDK to work with the correct class that serves connected fiscal device command protocol.
         By creating the right instances, you can use commands directly across the low level layer of the Datecs JavaSDK, for example:

         connectedFD.getConnectedPrinterV1().command34Variant0Version0() See Datecs JavaSDK Documentation and
         See DESCRIPTION OF THE PROGRAMMING  INTERFACE ECR  DP-05, DP-25, DP-35, WP-50, DP-150 (programmers manual)
         Or DESCRIPTION OF THE PROGRAM INTERFACE TO A FISCAL PRINTER DATECS FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F / FMP-10 / FP-550

         or use the layer, connectedFD.setConnectedModel
         This setting FPTR_CC_XXXX allows for internal translation of error codes that occurred after execution of the commands.
         So FPTR_CC_OTHER will throw a description of the error codes in English.
         This translation has an effect on  FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F / FMP-10 / FP-550 only
    */
    private static DatecsFiscalDevice connectedFD = new DatecsFiscalDevice(FPTR_CC_OTHER);
    private SerialPort serialPort = null;
    private static String modelName="";
    public static String getModelName() {
        return modelName+= " :RS232";
    }
    private int boudrate = 115200;
    private int timeOut = 0;

    public Object getConnection() throws Exception {
        return serialPort;
    }

    public void checkOpened() throws Exception {
        if (serialPort == null) {
            throw new Exception("Port is not opened");
        }
    }

    @Override
    public String getPortName() throws Exception {
        //Read Port Name
        return "";
    }

    /**
     * <p>
     * By this method we open the serial port and ask the model vendor name, if the model
     * is from the supported in this SDK, we create an instance of the respective model class.
     * <p>
     * The following fiscal devices are supported in this demo:
     * <p>
     * List of  all supported device by Protocol V1
     * ECR:DP-05, DP-25, DP-35 , WP-50, DP-150
     * Fiscal Printers: FP-800,FP-2000,FP-650,SK1-21F,SK1-31F,FMP-10,FP-550
     *
     * @param portName Serial COM Port
     * @return DatecsFiscalDevice
     * @throws Exception
     */
    @Override
    public DatecsFiscalDevice open(String portName) throws Exception {


        try {
            if (serialPort == null) {
                serialPort = SerialPort.getCommPort(portName);
                if (!serialPort.openPort()) throw new Exception("Can't open port :" + portName);
                serialPort.setComPortParameters(boudrate, 8, 1, 0);
                serialPort.setComPortTimeouts(SerialPort.TIMEOUT_READ_SEMI_BLOCKING, timeOut, 0);
                serialPort.setFlowControl(SerialPort.FLOW_CONTROL_DISABLED);
                InputStream in = serialPort.getInputStream();
                OutputStream out = serialPort.getOutputStream();
                 //Autodetect model
                FDModelDetectorV1 datecsBGRmodelV1 = new FDModelDetectorV1(
                        serialPort.getInputStream(),
                        serialPort.getOutputStream());
                modelName = datecsBGRmodelV1.detectConnectedModel();
                return  PrinterConnection.createPrinter(modelName,datecsBGRmodelV1.getTransportProtocol());

            }
        } catch (Exception ex) {
            close();
            throw new Exception(ex.getMessage());
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (isOpen()) {
            serialPort.getInputStream().close();
            serialPort.getOutputStream().close();
            System.out.println("\n\nClosing " + serialPort.getDescriptivePortName() + ": " + serialPort.closePort());
        }
    }

    private boolean isOpen() {
        if (serialPort == null) {
            return false;
        }
        return serialPort.isOpen();
    }

    @Override
    public boolean isSearchByBaudRateEnabled() {
        return false;
    }

    @Override
    public void setBaudRate(int baudRate) throws Exception {
        if (this.boudrate != baudRate) {
            this.boudrate = baudRate;
        }
    }

    @Override
    public void setTimeout(int timeout) throws Exception {
        this.timeOut = timeout;
    }

    @Override
    public void setPortName(String portName) throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }



}
