import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdConfig;

import javax.imageio.ImageIO;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Base64;

public class DialogLoadLogo extends JDialog {
    private JPanel contentPane;
    private JButton btnWriteLogo;
    private JButton buttonCancel;
    private JButton btnOpenImageFile;
    private JButton btnWriteStamp;
    private JTextField edStampName;
    private JLabel imageLabel;
    private JProgressBar prgBarWriteLogo;
    private JLabel labInfo;
    private JButton btnPrintStamp;
    private BufferedImage originalImage;
    private BufferedImage blackAndWhiteImg;

    private int MAX_LOGO_W;
    private int MAX_LOGO_H;
    private cmdConfig myPrintConfig = new cmdConfig();
    private String stampName8X3;


    public DialogLoadLogo() {
        MAX_LOGO_W=myPrintConfig.getConnectedModelV2().getMaxLogoW();
        MAX_LOGO_H=myPrintConfig.getConnectedModelV2().getMaxLogoH();
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnOpenImageFile);

        btnOpenImageFile.addActionListener(new ActionListener() {
            private File initPath = FileSystemView.getFileSystemView().getHomeDirectory();

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser(initPath);
                jfc.setDialogTitle("Select an Logo or Stamp File...");
                jfc.setAcceptAllFileFilterUsed(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Image File (BMP,JPG,PNG)", "BMP", "JPG", "PNG");
                jfc.addChoosableFileFilter(filter);

                int returnValue = jfc.showOpenDialog(null);
                if (returnValue == JFileChooser.APPROVE_OPTION) {
                    boolean isImageFile = OpenImageFromFile(jfc.getSelectedFile().getPath());
                    btnWriteLogo.setEnabled(isImageFile);
                    btnWriteStamp.setEnabled(isImageFile);
                    initPath = new File(jfc.getSelectedFile().getPath());
                }
            }

        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);


        btnWriteLogo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                loadLogoThread(encodeToBase64(blackAndWhiteImg));
            }
        });
        btnPrintStamp.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                if (!edStampName.getText().matches("^.{1,8}[.].{3}$")) {
                    MainForm.errListModel.add(0,
                            "Please use stamp filename in format 8.3 (example: stamp123.bmp)");
                    return;
                }
                try {
                    myPrintConfig.Stamp_Operation("0", edStampName.getText());
                } catch (Exception ex) {
                    MainForm.errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }


            }
        });
        btnWriteStamp.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                stampName8X3 = edStampName.getText();
                if (!stampName8X3.matches("^.{1,8}[.].{3}$")) {
                    MainForm.errListModel.add(0,
                            "Please use stamp filename in format 8.3 (example: stamp123.bmp)");
                    return;
                }
                loadStampThread(encodeToBase64(blackAndWhiteImg));
            }
        });
    }

private void askToRestartDevice() throws IOException, FiscalException {
    int dialogResult =
            JOptionPane.showConfirmDialog(null, "Would You Like to Restart the Device?", "Warning",JOptionPane.YES_NO_OPTION);

    if (dialogResult == JOptionPane.YES_OPTION) {
        myPrintConfig.Logo_Updtae();
    }
}
    private void loadLogoThread(final String base64String) {
        final int COUNT_BYTES = 36;
        prgBarWriteLogo.setValue(0);
        prgBarWriteLogo.setMaximum(base64String.length() / COUNT_BYTES - 1);
        final int[] finalI = {0};
        new Thread(new Runnable() {
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    myPrintConfig.Logo_StartLoading();
                    String base64TempString = base64String.replaceAll("(\\n)", "");
                    while (base64TempString.length() > 0) {
                        if (base64TempString.length() >= COUNT_BYTES) {
                            myPrintConfig.Logo_DataLoading(base64TempString.substring(0, COUNT_BYTES));
                            base64TempString = base64TempString.substring(COUNT_BYTES);
                        } else {
                            myPrintConfig.Logo_DataLoading(base64TempString);
                            break;
                        }
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                prgBarWriteLogo.setValue(finalI[0]++);
                            }
                        });

                    }
                    myPrintConfig.Logo_StopLoading();
                    askToRestartDevice();
                } catch (Exception e) {
                    MainForm.errListModel.add(0, e.getMessage());
                    e.printStackTrace();

                } finally {

                }

            }
        }).start();

    }

    private void loadStampThread(final String base64String) {
        final int COUNT_BYTES = 36;
        prgBarWriteLogo.setValue(0);
        prgBarWriteLogo.setMaximum(base64String.length() / COUNT_BYTES - 1);
        final int[] finalI = {0};
        new Thread(new Runnable() {

            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    myPrintConfig.Stamp_StartLoading();
                    ;
                    String base64TempString = base64String.replaceAll("(\\n)", "");
                    while (base64TempString.length() > 0) {

                        if (base64TempString.length() >= COUNT_BYTES) {
                            myPrintConfig.Stamp_DataLoading(base64TempString.substring(0, COUNT_BYTES));
                            base64TempString = base64TempString.substring(COUNT_BYTES);
                        } else {
                            myPrintConfig.Stamp_DataLoading(base64TempString);
                            break;
                        }
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                prgBarWriteLogo.setValue(finalI[0]++);
                            }
                        });

                    }
                    myPrintConfig.Stamp_StopLoading();
                    //Set the name of stamp loaded.
                    myPrintConfig.Stamp_Operation("1", stampName8X3);
                } catch (Exception e) {
                    MainForm.errListModel.add(0, e.getMessage());
                    e.printStackTrace();
                }

            }
        }).start();

    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogLoadLogo dialog = new DialogLoadLogo();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    private boolean OpenImageFromFile(String path) {
        File imageFile = new File(path);
        try {
            originalImage = cropImage(ImageIO.read(imageFile));  //To keep original imageAsIcon
            blackAndWhiteImg = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), BufferedImage.TYPE_BYTE_BINARY);
            Graphics2D graphics = blackAndWhiteImg.createGraphics();
            graphics.drawImage(originalImage, 0, 0, null);
            showImage(blackAndWhiteImg);
            labInfo.setText(path);//+ " H:" + convertedImage.getHeight() + " W:" + convertedImage.getWidth());
            return blackAndWhiteImg != null;
        } catch (IOException e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    /**
     * @param img
     */
    private void showImage(BufferedImage img) {
        if (img == null) return;
        ImageIcon imageAsIcon = new ImageIcon(img);
        imageLabel.setIcon(imageAsIcon);
        imageLabel.setSize(img.getWidth(), img.getHeight());
        imageLabel.repaint();
    }

    /**
     * @param i
     * @return
     */
    private BufferedImage cropImage(BufferedImage i) {
        BufferedImage cropedImg = i;
        if ((i.getWidth() > MAX_LOGO_W) && (i.getHeight()) > MAX_LOGO_H)
            return i.getSubimage(0, 0, MAX_LOGO_W, MAX_LOGO_H);
        if (i.getWidth() > MAX_LOGO_W) cropedImg = i.getSubimage(0, 0, MAX_LOGO_W, i.getHeight());
        if (i.getHeight() > MAX_LOGO_H) cropedImg = i.getSubimage(0, 0, i.getWidth(), MAX_LOGO_H);
        return cropedImg;
    }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public static String encodeToBase64(BufferedImage image) {
        String imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();

        try {
            ImageIO.write(image, "bmp", bos);
            byte[] imageBytes = bos.toByteArray();

            Base64.Encoder encoder = Base64.getEncoder();
            imageString = encoder.encodeToString(imageBytes);

            bos.close();
        } catch (IOException e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
        return imageString;
    }


}
