import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdConfig;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdService;

import javax.swing.*;
import java.awt.event.*;

public class DialogNETSettings extends JDialog {
    private JPanel contentPane;
    private JButton btnSave;
    private JButton buttonCancel;
    private JTextField edIP;
    private JTextField edMask;
    private JTextField edGtw;
    private JTextField edMAC;
    private JSpinner spPort;
    private JCheckBox chkDHCP;
    private JLabel labIP;
    private JLabel labMask;
    private JLabel labGate;
    private JLabel labPort;
    private JLabel labMac;
    private JButton btnTestLAN;
    private JComboBox cbxMainInterfaceType;
    private JTextField edDNS1;
    private JTextField edDNS2;
    private JCheckBox chkSaveMAC;
    private JTextField edGPRS_APN1;
    private JTextField edGPRS_APN_USER1;
    private JTextField edGPRS_APN_PASS1;
    private JTextField edGPRS_IMSI;
    private JTextField edGPRS_IMEI;
    private JComboBox cbxGPRSModem;
    private JTextField edGPRS_SIM_PIN;
    private JTextField edGPRS_APN2;
    private JTextField edGPRS_APN_USER2;
    private JTextField edGPRS_APN_PASS2;
    private JLabel ed_GPRS_ICCID;
    private JTextField edGPRS_MSISDN;
    private JTextField edGPRS_ICCID;
    private JButton button1;
    private JButton btnTestModem;
    private cmdConfig myConfig = new cmdConfig();

    public DialogNETSettings() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnSave);

        initAll();


        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        btnTestLAN.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new cmdService().PrintLANInfo();
                } catch (Exception ex) {
                    MainForm.errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        btnSave.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            edIP.requestFocus();
                            myConfig.SetLANIP(edIP.getText());

                            edMask.requestFocus();
                            myConfig.SetLANNetMask(edMask.getText());

                            edGtw.requestFocus();
                            myConfig.SetLANGateway(edGtw.getText());

                            spPort.requestFocus();
                            myConfig.SetLANport(String.valueOf(spPort.getValue()));

                            edDNS1.requestFocus();
                            myConfig.SetLANPriDNS(edDNS1.getText());

                            edDNS2.requestFocus();
                            myConfig.SetLANSecDNS(edDNS2.getText());
                            if (chkSaveMAC.isSelected()) {
                                edMAC.requestFocus();
                                myConfig.SetLanMAC(edMAC.getText());
                            }
                            chkDHCP.requestFocus();
                            myConfig.SetDHCPenable(chkDHCP.isSelected());
                            cbxGPRSModem.requestFocus();
                            myConfig.SetModemModel(cbxGPRSModem.getSelectedIndex());
                            edGPRS_SIM_PIN.requestFocus();
                            myConfig.SetSimPin(edGPRS_SIM_PIN.getText());
                            edGPRS_APN1.requestFocus();
                            myConfig.SetAPN(0, edGPRS_APN1.getText());
                            edGPRS_APN2.requestFocus();
                            myConfig.SetAPN(1, edGPRS_APN2.getText());
                            edGPRS_APN_USER1.requestFocus();
                            myConfig.SetAPN_User(0, edGPRS_APN_USER1.getText());
                            edGPRS_APN_USER2.requestFocus();
                            myConfig.SetAPN_User(1, edGPRS_APN_USER2.getText());
                            edGPRS_APN_PASS1.requestFocus();
                            myConfig.SetAPN_Passr(0, edGPRS_APN_PASS1.getText());
                            edGPRS_APN_PASS2.requestFocus();
                            myConfig.SetAPN_Passr(1, edGPRS_APN_PASS2.getText());
                        } catch (Exception ex) {
                            MainForm.errListModel.add(0, ex.getMessage());
                            ex.printStackTrace();
                        }

                    }
                }).start();


            }
        });

        btnTestModem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cmdService myCmdService = new cmdService();
                try {
                    myCmdService.TestOfTheModem();
                    // myCmdService.TestOfTheModemNoPPP();
                } catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });

    }

    private void initAll() {
        try {
            edIP.setText(myConfig.GetLANIP());
            edMask.setText(myConfig.GetLANNetMask());
            edGtw.setText(myConfig.GetLANGateway());
            spPort.setValue(Integer.valueOf(myConfig.GetLANport()));
            edDNS1.setText(myConfig.GetLANPriDNS());
            edDNS2.setText(myConfig.GetLANSecDNS());
            edMAC.setText(myConfig.GetLanMAC());
            chkDHCP.setSelected(myConfig.GetDHCPenable());
            cbxMainInterfaceType.setSelectedIndex(myConfig.GetMainInterfaceType().ordinal());
            cbxGPRSModem.setSelectedIndex(myConfig.GetModemModel());
            edGPRS_SIM_PIN.setText(myConfig.GetSimPin());
            edGPRS_APN1.setText(myConfig.GetAPN(0));
            edGPRS_APN2.setText(myConfig.GetAPN(1));
            edGPRS_APN_USER1.setText(myConfig.GetAPN_User(0));
            edGPRS_APN_USER2.setText(myConfig.GetAPN_User(1));
            edGPRS_APN_PASS1.setText(myConfig.GetAPN_Pass(0));
            edGPRS_APN_PASS2.setText(myConfig.GetAPN_Pass(1));
            edGPRS_ICCID.setText(myConfig.GetSimICCID());
            edGPRS_IMSI.setText(myConfig.GetSimIMSI());
            edGPRS_IMEI.setText(myConfig.GetIMEI());
            edGPRS_MSISDN.setText(myConfig.GetSimTelNumber());

        } catch (Exception ex) {
            MainForm.errListModel.add(0, ex.getMessage());
            ex.printStackTrace();
        }
    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogNETSettings dialog = new DialogNETSettings();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }
}
