

import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdService;
import com.datecs.util.RegExpr;
import tools.cmdEJStructInfo;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import static connectivity.SerialPrinterConnector.getConnectedFD;

public class DialogStorno extends JDialog {

    private JButton btnOpenStorno;
    private JButton btnValidate;
    private JTextField edTillNumber;
    private JComboBox cbxOperator;
    private JPasswordField edOpPass;
    private JComboBox cbxStornoType;
    private JTextField edDocumentDate;
    private JTextField edDocumentTime;
    private JTextField edStornoReason;
    private JTextField edDocumentUNP;
    private JTextField edDocumentNumber;
    private JTextField edFiscalMemoryNum;
    private JButton btnAddItem;

    private JLabel labOpPsw;
    private JLabel labTillNum;
    private JLabel labOperator;
    private JLabel labTypeStorno;

    private JLabel labDocDate;
    private JLabel labDocTime;
    private JLabel labDocUNP;
    private JLabel labDocNum;
    private JLabel labFMNum;
    private JPanel contentPane;
    private JCheckBox chkbInvoice;
    private JButton searchButton;
    private JLabel labStornoReason;
    private cmdEJStructInfo myEjStructInfo = new cmdEJStructInfo();
    private cmdInfo myInfo = new cmdInfo();
    private cmdReceipt.FiscalReceipt.Storno fiscalStornoRec = new cmdReceipt.FiscalReceipt.Storno();

    public DialogStorno() throws Exception {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnOpenStorno);
        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        // Init
        Integer maxOperators = null;
        if (getConnectedFD().isConnectedDeviceV2())
            maxOperators = getConnectedFD().getConnectedModelV2().getMaxOperators();
        if (getConnectedFD().isConnectedECR()) maxOperators = getConnectedFD().getConnectedModelV2().getMaxOperators();
        //Init
        List<String> ls = new ArrayList<String>();
        for (int i = 1; i <= maxOperators; i++) ls.add("Operator: " + i);
        cbxOperator.setModel(new DefaultComboBoxModel(ls.toArray()));

        //Set Operator password
        //Note: WP-500X, WP-50X, WP-25X, DP-25X, DP-150X, DP-05C: the default password for each operator is
        //equal to the corresponding number (for example, for Operator1 the password is "1") . FMP-350X, FMP-55X,
        //FP-700X: the default password for each operator is "0000"
        String operatorPassword = myInfo.GetOperPasw(cbxOperator.getSelectedIndex());//Password of operator. Text up to 8 symbols. ( Require Service jumper )
        edOpPass.setText(operatorPassword);

        cmdInfo.QRinfo lastReceiptInfo = myInfo.GetQRInfo();
        edDocumentNumber.setText(String.valueOf(lastReceiptInfo.getNumber()));
        edDocumentDate.setText(lastReceiptInfo.getDatetime().split(" ")[0]);
        edDocumentTime.setText(lastReceiptInfo.getDatetime().split(" ")[1]);
        edFiscalMemoryNum.setText(new cmdService().GetFiscalMemoryNumber());

        btnOpenStorno.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    //Use format "DD-MM-YY hh:mm:ss
                    String stornoDocDT = edDocumentDate.getText() + " " + edDocumentTime.getText();

                    if (chkbInvoice.isSelected()) {
                        fiscalStornoRec.open(
                                String.valueOf(cbxOperator.getSelectedIndex() + 1),
                                edOpPass.getText(),
                                edTillNumber.getText(),
                                cmdReceipt.FiscalReceipt.Storno.StornoType.values()[cbxStornoType.getSelectedIndex()],
                                edDocumentNumber.getText(),
                                stornoDocDT,
                                edFiscalMemoryNum.getText(),
                                true,// Invoice
                                edDocumentNumber.getText(),
                                edStornoReason.getText(),
                                edDocumentUNP.getText());

                    } else fiscalStornoRec.open(
                            String.valueOf(cbxOperator.getSelectedIndex() + 1),
                            edOpPass.getText(),
                            edTillNumber.getText(),
                            cmdReceipt.FiscalReceipt.Storno.StornoType.values()[cbxStornoType.getSelectedIndex()],
                            edDocumentNumber.getText(),
                            stornoDocDT,
                            edFiscalMemoryNum.getText(),
                            false,// Not Invoice
                            "",  // Use for Invoice only
                            "",    // Use for Invoice only
                            edDocumentUNP.getText());


                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnAddItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //Creating Strono receipt as a fiscal receipt.
                cmdReceipt.FiscalReceipt stornoReceipt = new cmdReceipt.FiscalReceipt();

                if (stornoReceipt.isOpen()) {

                    //Creating fiscal sale (storno) in opened receipt.
                    cmdReceipt.FiscalReceipt.FiscalSale itemStorno = new cmdReceipt.FiscalReceipt.FiscalSale();
                    try {
                        itemStorno.add(
                                "Демонстрация",
                                "2", //1-A,2-B...
                                "",
                                "0.11",
                                "",
                                cmdReceipt.FiscalReceipt.FiscalSale.DiscountType.noDiscount,
                                "");

                        //TOTAL
                        stornoReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        itemStorno.saleTotal(
                                cmdReceipt.PaymentType.cash,
                                "0.11");

                        if (chkbInvoice.isSelected()) {
                            new cmdReceipt.FiscalReceipt.InvoiceClientInfo(
                                    cmdReceipt.FiscalReceipt.InvoiceClientInfo.TypeTAXN.BULSTAT,
                                    "000713391",
                                    "00000000000001",
                                    "",
                                    "Datecs",
                                    "",
                                    "",
                                    "").saveClientInfo();
                        }

                        //CLOSE
                        stornoReceipt.closeFiscalReceipt();

                    } catch (Exception e1) {
                        MainForm.errListModel.add(0, e1.getMessage());
                        e1.printStackTrace();
                    }

                }

            }
        });

        btnValidate.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                List<Boolean> isValidateOK = new ArrayList<>();
                isValidateOK = new cmdReceipt.FiscalReceipt.Storno().validateOpenStorno(
                        String.valueOf(cbxOperator.getSelectedIndex() + 1),//0
                        edOpPass.getText().trim(),                         //1
                        edTillNumber.getText().trim(),                     //2
                        cmdReceipt.FiscalReceipt.Storno.StornoType.values()[cbxStornoType.getSelectedIndex()],//3
                        edDocumentNumber.getText().trim(),                 //4
                        edDocumentDate.getText().trim() + " " + edDocumentTime.getText().trim(),//5
                        edFiscalMemoryNum.getText().trim(),                //6
                        edDocumentUNP.getText().trim()                     //7
                );
                markAllInvalidFieldsInRED(isValidateOK);
            }
        });

        chkbInvoice.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (chkbInvoice.isSelected())
                    labDocNum.setText("Invoice Number");
                else labDocNum.setText("Document Number");
            }
        });

        searchButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                try {
                    cmdEJStructInfo.FiscalDocInfo recInfo = myEjStructInfo.ReadReceiptInfoFromEJ(
                            Integer.valueOf(edDocumentNumber.getText()), cmdEJStructInfo.DocTypeToRead.all_types);
                    if (recInfo.isfDocData()) {
                        recInfoDialog(recInfo); //Show info
                    } else MainForm.errListModel.add(0, "Sale Receipt not found in EJ...");
                } catch (Exception ex) {
                    MainForm.errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });

    }

    /**
     * Analyzes the information from the document found in EJ.
     * And allows the data from it to be used for the issuance of a storno document.
     *
     * @param recInfo
     */
    private void recInfoDialog(cmdEJStructInfo.FiscalDocInfo recInfo) {
        String title;
        if (recInfo.isOther()) title = "The Receipt found is not a sale or invoice! \n";
        else if (recInfo.getStornoOfDocument() > 0) title = "Storno document was found.\n";
        else title = "Sale Receipt was found.\n";

        String msg = "";
        if (recInfo.isAllVoid()) msg = "\nThe found document has been canceled.\n";

        if (recInfo.isInvoice()) {
            msg += "\ninvoice number:" + String.format("%010d", recInfo.getInvoiceNumber());
            msg += "\nClient EIK:" + recInfo.getClientEIK();
        }
        msg += "\nClosed on: " + recInfo.getDateTime();
        msg += "\nOperator ID: " + recInfo.getOperator();
        String stornoUNP = recInfo.getUNP();
        msg += "\nUNP: " + stornoUNP;
        int option = JOptionPane.showConfirmDialog(null, msg, title, JOptionPane.OK_CANCEL_OPTION);
        if (option == JOptionPane.OK_OPTION) {
            //in case of document without UNP use :   "OO000000-0000-0000000"
            edDocumentUNP.setText(stornoUNP.trim().matches(RegExpr._UNP) ? "" : "OO000000-0000-0000000");
            chkbInvoice.setSelected(recInfo.isInvoice());
            cbxOperator.setSelectedIndex(recInfo.getOperator() - 1);
            edDocumentDate.setText(recInfo.getDateTime().split(" ")[0]);
            edDocumentTime.setText(recInfo.getDateTime().split(" ")[1]);
        } else {
            //System.out.println(""); Bye !
        }

    }

    /**
     * @param isValidateOK
     */
    private void markAllInvalidFieldsInRED(List<Boolean> isValidateOK) {
        Color color;

        if (edTillNumber.getText().trim().length() == 0)
            edTillNumber.setText("???");

        if (edOpPass.getText().trim().length() == 0)
            edOpPass.setText("????");

        if (edDocumentNumber.getText().trim().length() == 0)
            edDocumentNumber.setText("???");


        if (isValidateOK.size() == 8) {
            /**
             * Index to get validation
             *  opCode - 0
             *  opPwd  - 1
             *  tillNmb  - 2
             *  stornoUNP - 3
             *  stornoType - 4
             *  docNumber -  4
             *  stornoReason -6
             * */
            if (!isValidateOK.get(0)) color = Color.RED;
            else color = Color.BLACK;
            labOperator.setForeground(color);

            if (!isValidateOK.get(1)) color = Color.RED;
            else color = Color.BLACK;
            labOpPsw.setForeground(color);

            if (!isValidateOK.get(2)) color = Color.RED;
            else color = Color.BLACK;
            labTillNum.setForeground(color);


            if (!isValidateOK.get(3)) color = Color.RED;
            else color = Color.BLACK;
            labTypeStorno.setForeground(color);

            if (!isValidateOK.get(4)) color = Color.RED;
            else color = Color.BLACK;
            labDocNum.setForeground(color);

            if (!isValidateOK.get(5)) color = Color.RED;
            else color = Color.BLACK;
            labDocDate.setForeground(color);
            labDocTime.setForeground(color);

            if (!isValidateOK.get(6)) color = Color.RED;
            else color = Color.BLACK;
            labFMNum.setForeground(color);

            if (!isValidateOK.get(7)) color = Color.RED;
            else color = Color.BLACK;
            labDocUNP.setForeground(color);

            if (edDocumentDate.getText().trim().length() == 0)
                edDocumentDate.setText("DD-MM-YY");

            if (edDocumentTime.getText().trim().length() == 0)
                edDocumentTime.setText("HH:MM:SS");

            if (edDocumentUNP.getText().trim().length() == 0)
                edDocumentUNP.setText("????????-???-??????");
/*
            if (!isValidateOK.get(0)) color = Color.RED;
            else color = Color.BLACK;
            labOperator.setForeground(color);

            if (!isValidateOK.get(1)) color = Color.RED;
            else color = Color.BLACK;
            labOpPsw.setForeground(color);

            if (!isValidateOK.get(2)) color = Color.RED;
            else color = Color.BLACK;
            labTillNum.setForeground(color);


            if (!isValidateOK.get(3)) color = Color.RED;
            else color = Color.BLACK;
            labTypeStorno.setForeground(color);


            if (!isValidateOK.get(4)) color = Color.RED;
            else color = Color.BLACK;
            labTypeStorno.setForeground(color);

            if (!isValidateOK.get(5)) color = Color.RED;
            else color = Color.BLACK;
            labDocNum.setForeground(color);
            if (!isValidateOK.get(6)) color = Color.RED;
            else color = Color.BLACK;
            labDocUNP.setForeground(color);

            if (!isValidateOK.get(7)) color = Color.RED;
            else color = Color.BLACK;
            labDocDate.setForeground(color);
            labDocTime.setForeground(color);

            if (!isValidateOK.get(8)) color = Color.RED;
            else color = Color.BLACK;
            labFMNum.setForeground(color);

            if (!isValidateOK.get(9)) color = Color.RED;
            else color = Color.BLACK;
            labStornoReason.setForeground(color);
*/

        }

    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) throws Exception {
        DialogStorno dialog = new DialogStorno();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

}
