import com.datecs.fiscalprinter.SDK.BuildInfo;
import com.datecs.fiscalprinter.SDK.FiscalErrorCodesV2;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReport;
import com.fazecast.jSerialComm.SerialPort;
import connectivity.*;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import static com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.BarcdeType.*;
import static com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalSale.DiscountType.noDiscount;
import static com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.PaymentType.cash;
import static com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.SeparatingLine.dash;
import static com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.SeparatingLine.dash_space;
import static connectivity.SerialPrinterConnector.getConnectedFD;


public class MainForm {
    private JButton btnConnect;
    public JPanel paneMain;
    private JComboBox cbxSerialPort;
    private JComboBox cbxBoudrate;
    private JLabel labDevice;
    private JButton btnTestSale;
    private JButton btnCloseAll;
    private JButton btnDayliXReport;
    private JButton btnDayliZReport;
    private JButton btnSetDateTime;
    private JButton btnExSale;
    private JButton btnStorno;
    private JList list1;
    private JButton btnCashInCashOut;
    private JButton btnVATConfig;
    private JButton btnItems;
    private JButton btnJournalSearch;
    private JButton btnPrintConfig;
    private JButton btnCommand;
    private JButton btnDeviceStatus;
    private JButton btnHeaderFooter;
    private JButton btnClearErrList;
    private JButton btnGraphicalLogo;
    private JComboBox cbxConnectionType;
    private JTextField edHostAddress;
    private JLabel labSerialPort;
    private JLabel labBoudrate;
    private JLabel lbType;
    private JLabel lbHost;
    private JButton btnNetSettings;
    private JButton btnInvoice;
    private JButton nonFiscalReceiptB1utton;
    private JButton btnStructInfo;
    private JButton btnNonFiscalReceipt;
    private JButton btnDepartments;
    private JButton btnAdditionaDayInfo;
    private JButton btnOperatorsInfo;
    private JButton btnReceiptAsImg;
    private JButton btnPinpadDemo;

    private SerialPort serialPort = null;
    private cmdReceipt.FiscalReceipt fiscalReceipt;
    private cmdReceipt.NonFiscalReceipt noFiscalReceipt;
    public DatecsFiscalDevice myFiscalDevice;
    private PrinterConnection fdConnection;
    public static DefaultListModel errListModel = new DefaultListModel();

    public MainForm() {

        list1.setModel(errListModel);

        cbxSerialPort.setModel(new DefaultComboBoxModel(listPCSerialPort()));
        cbxBoudrate.setModel(new DefaultComboBoxModel(Const.RS232_BAUD_RATE_VALUES));
        cbxBoudrate.setSelectedIndex(8);
        fiscalReceipt = new cmdReceipt.FiscalReceipt();
        noFiscalReceipt = new cmdReceipt.NonFiscalReceipt();
        Border border = BorderFactory.createTitledBorder("Datecs Java SDK Build:" + BuildInfo.VERSION);
        paneMain.setBorder(border);
        btnConnect.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                try {
                    //Disconnect if device is connected
                    if (myFiscalDevice != null) {
                        fdConnection.close();
                        btnConnect.setText("Connect...");
                        buttonsEnable(false);
                        labDevice.setText(":");
                        myFiscalDevice = null;
                        return;
                    }
                    if (cbxConnectionType.getSelectedItem() == "RS232") {
                        fdConnection = PrinterConnectionFactory.createInstance("RS232_DEVICE_BUS"); //
                        fdConnection.setBaudRate(Integer.valueOf(cbxBoudrate.getSelectedItem().toString()));
                        //By this method we open the serial port and ask the model vendor name, if the model
                        //is supported in this SDK, we create an instance of the respective model class.
                        myFiscalDevice = fdConnection.open(cbxSerialPort.getSelectedItem().toString());
                        labDevice.setText(SerialPrinterConnector.getModelName());
                    } else {
                        fdConnection = PrinterConnectionFactory.createInstance("ETHERNET_DEVICE_BUS"); //
                        //By this method we open the serial port and ask the model vendor name, if the model
                        //is supported in this SDK, we create an instance of the respective model class.
                        myFiscalDevice = fdConnection.open(edHostAddress.getText());
                        labDevice.setText(SocketConnector.getModelName());
                    }
                    buttonsEnable(myFiscalDevice.isConnectedDeviceV2());

                    if (myFiscalDevice.isConnectedDeviceV2()) {
                        btnConnect.setText("Disconnect...");
                        //To check the status of the device, send a command to fill in the status bits
                        new cmdInfo().GetDeviceSerialNumber();

                    } else {
                        labDevice.setText("Fiscal Device not detected..");
                        fdConnection.close();
                    }

                } catch (Exception ex) {
                    try {
                        ex.printStackTrace();
                        errListModel.add(0, ex.getMessage());
                    } catch (Exception e1) {
                        errListModel.add(0, e1.getMessage());
                        e1.printStackTrace();
                    }
                }

            }
        });
        btnExSale.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                String salePoint = "1"; //Number of point of sale from 1...99999;
                String NSale; //Unique sale number (21 chars "LLDDDDDD-CCCC-DDDDDDD"

                try {
                    getConnectedFD();
                    if (!fiscalReceipt.isOpen()) {
                        //Note: WP-500X, WP-50X, WP-25X, DP-25X, DP-150X, DP-05C: the default password for each operator is
                        //equal to the corresponding number (for example, for Operator1 the password is "1") . FMP-350X, FMP-55X,
                        //FP-700X: the default password for each operator is "0000"

                        String operatorCode = myFiscalDevice.getConnectedModelV2().getCurrentOpCode();
                        String operatorPassword = new cmdInfo().GetOperPasw(0);//Password of operator. Text up to 8 symbols. ( Require Service jumper )
                        //String operatorPassword =  myFiscalDevice.getConnectedModelV2().getDefaultOpPass();

                        //Creating the unique sale number "LLDDDDDD-CCCC-DDDDDDD"
                        NSale = new com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo().GetDeviceSerialNumber() + "-" +
                                String.format("%04d", Integer.parseInt(operatorCode)) + "-" + // Pad left with trailing zero
                                String.format("%07d", 1 + Integer.parseInt(fiscalReceipt.getAllreceipt()));  //Next Document number pad left with trailing zero

                        //Open Fiscal bon in current receipt and return number of receipt
                        fiscalReceipt.openFiscalReceipt(
                                operatorCode,
                                operatorPassword,
                                NSale,
                                salePoint,
                                false);
                        fiscalReceipt.printSeparatingLine(dash);


                        //Registration of item for sale
                        com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalReceipt.FiscalSale testSale =
                                new com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalReceipt.FiscalSale(
                                        "Продажба с количество",
                                        "2",
                                        "0.01",
                                        "2.555",
                                        noDiscount,
                                        "",
                                        "",
                                        "kg").add();
                        fiscalReceipt.printSeparatingLine(dash_space);


                        //VOID of Registered  item for sale (Discount by percentage)
                        testSale.add(
                                "Продажба с количество",
                                "2",
                                "",
                                "-0.01", //Product price, with sign '-' at void operations.
                                "2.555",
                                com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalSale.DiscountType.discountPercentage,
                                "",
                                "kg");
                        fiscalReceipt.printSeparatingLine(dash_space);

                        //SUBTOTAL
                        testSale.printSubtotal(false, noDiscount, "");// No display
                        fiscalReceipt.printSeparatingLine(dash_space);

                        //Registration of item for sale (Minimum of parameters)
                        testSale.add(
                                "Продажба с минимум параметри",
                                "2",
                                "",
                                "0.01",
                                "",
                                noDiscount,
                                "");
                        fiscalReceipt.printSeparatingLine(dash_space);
                        //SUBTOTAL
                        testSale.printSubtotal(false, noDiscount, "");// No display

                        //Registration of item for sale  (Surcharge by value)
                        testSale.add(
                                "Продажба с надбавка по стойност",
                                "2",
                                "",
                                "0.01",
                                "",
                                com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalSale.DiscountType.surchargeSum,
                                "0.01");
                        fiscalReceipt.printSeparatingLine(dash_space);
                        //SUBTOTAL
                        testSale.printSubtotal(false, noDiscount, "");// No display

                        //Registration of item for sale (Surcharge by percentage )
                        testSale.add(
                                "Продажба процентна надбавка",
                                "2",
                                "",
                                "0.01",
                                "",
                                com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalSale.DiscountType.surchargePercentage,
                                "10");
                        fiscalReceipt.printSeparatingLine(dash_space);
                        //SUBTOTAL
                        testSale.printSubtotal(false, noDiscount, "");// No display

                        //Registration of item for sale (Discount by percentage)
                        testSale.add(
                                "Продажба с отсъпка по стойнст",
                                "2",
                                "",
                                "0.1",
                                "",
                                com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalSale.DiscountType.discountSum,
                                ".09");
                        fiscalReceipt.printSeparatingLine(dash_space);
                        //SUBTOTAL
                        testSale.printSubtotal(false, noDiscount, "");// No display

                        //Registration of item for sale (Discount by percentage)
                        testSale.add(
                                "Продажба с отсъпка в %",
                                "2",
                                "",
                                "0.1",
                                "",
                                com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalSale.DiscountType.discountPercentage,
                                "10");

                        fiscalReceipt.printBarcode(EAN8, "1234567", 0);
                        fiscalReceipt.printBarcode(EAN13, "123456789191", 0);
                        fiscalReceipt.printBarcode(Code128, "123456789191", 0);
                        fiscalReceipt.printBarcode(Interleave, "123456789191", 0);
                        fiscalReceipt.printSeparatingLine(dash_space);
                        //SUBTOTAL
                        testSale.printSubtotal(false, noDiscount, "");// No display

                        fiscalReceipt.printSeparatingLine(dash_space);
                        fiscalReceipt.printFreeText("Благодарим Ви!");
                        fiscalReceipt.printSeparatingLine(dash_space);
                        testSale.printSubtotal(false, noDiscount, "");

                        //SUBTOTAL with Discount
                        fiscalReceipt.printSeparatingLine(dash_space);
                        fiscalReceipt.printFreeText("Отстъпка в междинна сума");
                        testSale.printSubtotal(false, com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.FiscalSale.DiscountType.discountSum, "0.13");

                        String toPay = testSale.readSubtotal(false, noDiscount, "");

                        //TOTAL
                        testSale.saleTotal(
                                cash,
                                toPay
                        );
                        fiscalReceipt.closeFiscalReceipt();
                    } else closeAll();

                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnCloseAll.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    getConnectedFD();
                    closeAll();
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnDayliZReport.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                final cmdReport.ReportSummary reportSummary = new cmdReport.ReportSummary();
                try {
                    getConnectedFD();
                    cmdReport cmd = new cmdReport();
                    int num = cmd.PrintZreport(reportSummary);

                    JOptionPane.showMessageDialog(paneMain, "Report No:" + num + "\n\r" +
                            "Total A:" + reportSummary.totalA + "\n\r" +
                            "Total B:" + reportSummary.totalB);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });
        btnDayliXReport.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                final cmdReport.ReportSummary reportSummary = new cmdReport.ReportSummary();
                try {
                    getConnectedFD();
                    cmdReport cmd = new cmdReport();
                    int num = cmd.PrintXreport(reportSummary);
                    JOptionPane.showMessageDialog(paneMain, "Report No:" + num + "\n\r" +
                            "Total A:" + reportSummary.totalA + "\n\r" +
                            "Total B:" + reportSummary.totalB);

                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnSetDateTime.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDateTime dialog = null;
                try {
                    dialog = new DialogDateTime();
                    dialog.setPreferredSize(new Dimension(320, 240));
                    dialog.pack();
                    dialog.setTitle("Device Date and Time");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnTestSale.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String salePoint = "1"; //Number of point of sale from 1...99999;
                String NSale; //Unique sale number (21 chars "LLDDDDDD-CCCC-DDDDDDD"
                try {
                    getConnectedFD();
                    if (!fiscalReceipt.isOpen()) {
                        //Note: WP-500X, WP-50X, WP-25X, DP-25X, DP-150X, DP-05C: the default password for each operator is
                        //equal to the corresponding number (for example, for Operator1 the password is "1") . FMP-350X, FMP-55X,
                        //FP-700X: the default password for each operator is "0000"
                        String operatorCode = myFiscalDevice.getConnectedModelV2().getCurrentOpCode();
                        //String operatorPassword =  myFiscalDevice.getConnectedModelV2().getDefaultOpPass();
                        //Password of operator. Text up to 8 symbols. ( Require Service jumper )
                        String operatorPassword = new cmdInfo().GetOperPasw(Integer.parseInt(operatorCode) - 1);
                        //Open Fiscal bon in current receipt
                        //Creating the unique sale number "LLDDDDDD-CCCC-DDDDDDD"
                        NSale = new com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo().GetDeviceSerialNumber() + "-" +
                                String.format("%04d", Integer.parseInt(operatorCode)) + "-" + // Pad left with trailing zero
                                String.format("%07d", 1 + Integer.parseInt(fiscalReceipt.getAllreceipt()));  //Next Document number pad left with trailing zero

                        //Open Fiscal bon in current receipt and return number of receipt
                        fiscalReceipt.openFiscalReceipt(
                                operatorCode,
                                operatorPassword,
                                NSale,
                                salePoint,
                                false);
                        fiscalReceipt.printSeparatingLine(dash);


                        fiscalReceipt.printSeparatingLine(dash);
                        //Registration of item for sale with the minimum required set of parameters
                        cmdReceipt.FiscalReceipt.FiscalSale testSale =
                                new cmdReceipt.FiscalReceipt.FiscalSale(
                                        "Бонбон",
                                        "2",
                                        "0.01").add();

                        //TOTAL
                        testSale.saleTotal(cash, "");
                        //TOTAL Foreign Currency
                        //testSale.saleTotalForeignCurrency("1", cmdReceipt.FiscalSale.TypeOfChange.currentCurrency);
                        //TOTAL Debit Card
                        //testSale.saleTotalDebitCard("", cmdReceipt.FiscalSale.TypeOfCardPayment.paymentWithPoints);

                        //Combined Payment test, please increase the amount of the item
                        //testSale.saleTotal(cash,"0.10");
                        //testSale.saleTotal(debit_card,"");

                        fiscalReceipt.closeFiscalReceipt();
                    } else fiscalReceipt.cancel();

                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnStorno.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStorno dialog = null;
                try {
                    dialog = new DialogStorno();
                    dialog.setPreferredSize(new Dimension(580, 400));
                    dialog.pack();
                    dialog.setTitle("Storno documents");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnDeviceStatus.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDeviceStatus dialog = null;
                try {
                    dialog = new DialogDeviceStatus();
                    dialog.setPreferredSize(new Dimension(420, 400));
                    dialog.pack();
                    dialog.setTitle("Device Status Bytes");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnHeaderFooter.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogHeaderFooter dialog = null;
                try {
                    dialog = new DialogHeaderFooter();
                    dialog.setPreferredSize(new Dimension(320, 280));
                    dialog.pack();
                    dialog.setTitle("Header and Footer settings");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnDepartments.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDepartments dialog = null;
                try {
                    dialog = new DialogDepartments();
                    dialog.setPreferredSize(new Dimension(320, 280));
                    dialog.pack();
                    dialog.setTitle("Departments settings.");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnVATConfig.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogVAT dialog = null;
                try {
                    dialog = new DialogVAT();
                    dialog.setPreferredSize(new Dimension(320, 280));
                    dialog.pack();
                    dialog.setTitle("VAT Rates configuration");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnItems.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogItems dialog = null;
                try {
                    dialog = new DialogItems();
                    dialog.setPreferredSize(new Dimension(800, 600));
                    dialog.pack();
                    dialog.setTitle("Price Lock Up Table (PLU)");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnClearErrList.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                errListModel.clear();
            }
        });

        btnJournalSearch.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEJ dialog = null;
                try {
                    dialog = new DialogEJ();
                    dialog.setPreferredSize(new Dimension(640, 480));
                    dialog.pack();
                    dialog.setTitle("Electronic Journal Search");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnPrintConfig.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPrintConfig dialog = null;
                try {
                    dialog = new DialogPrintConfig();
                    dialog.setPreferredSize(new Dimension(640, 600));
                    dialog.pack();
                    dialog.setTitle("Printing Options");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnCommand.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCommands dialog = null;
                try {
                    dialog = new DialogCommands();
                    dialog.setPreferredSize(new Dimension(640, 520));
                    dialog.pack();
                    dialog.setTitle("User Command Scripts");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnCashInCashOut.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCashInOut dialog = null;
                try {
                    dialog = new DialogCashInOut();
                    dialog.setPreferredSize(new Dimension(320, 240));
                    dialog.pack();
                    dialog.setTitle("Cash In/Out");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnGraphicalLogo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogLoadLogo dialog = null;
                try {
                    dialog = new DialogLoadLogo();
                    dialog.setPreferredSize(new Dimension(600, 400));
                    dialog.pack();
                    dialog.setTitle("Graphical Logo and Stamp");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        cbxConnectionType.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cbxBoudrate.setEnabled(cbxConnectionType.getSelectedItem().equals("RS232"));
                cbxSerialPort.setEnabled(cbxConnectionType.getSelectedItem().equals("RS232"));
                labSerialPort.setEnabled(cbxConnectionType.getSelectedItem().equals("RS232"));
                labBoudrate.setEnabled(cbxConnectionType.getSelectedItem().equals("RS232"));
                lbHost.setEnabled(cbxConnectionType.getSelectedItem().equals("TCP/IP"));
                edHostAddress.setEnabled(cbxConnectionType.getSelectedItem().equals("TCP/IP"));
            }
        });

        btnNetSettings.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogNETSettings dialog = null;
                try {
                    dialog = new DialogNETSettings();
                    dialog.setPreferredSize(new Dimension(640, 340));
                    dialog.pack();
                    dialog.setTitle("Network Connection Settings");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnInvoice.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DialogClientInfo dialog = new DialogClientInfo();
                    if (dialog.doModal() == dialog.ID_OK) {
                        cmdReceipt.FiscalReceipt.InvoiceClientInfo clientInfo = dialog.getClientInfo();
                        String salePoint = "1"; //Number of point of sale from 1...99999;
                        String NSale; //Unique sale number (21 chars "LLDDDDDD-CCCC-DDDDDDD"
                        getConnectedFD();
                        if (!fiscalReceipt.isOpen()) {
                            //Note: WP-500X, WP-50X, WP-25X, DP-25X, DP-150X, DP-05C: the default password for each operator is
                            //equal to the corresponding number (for example, for Operator1 the password is "1") . FMP-350X, FMP-55X,
                            //FP-700X: the default password for each operator is "0000"
                            String operatorCode = myFiscalDevice.getConnectedModelV2().getCurrentOpCode();
                            //String operatorPassword =  myFiscalDevice.getConnectedModelV2().getDefaultOpPass();
                            String operatorPassword = new cmdInfo().GetOperPasw(0);//Password of operator. Text up to 8 symbols. ( Require Service jumper )

                            //Open Fiscal bon in current receipt and return number of receipt
                            fiscalReceipt.openInvoice(
                                    operatorCode,
                                    operatorPassword,
                                    salePoint);
                            //Registration of item for sale with the minimum required set of parameters
                            cmdReceipt.FiscalReceipt.FiscalSale testSale =
                                    new cmdReceipt.FiscalReceipt.FiscalSale(
                                            "Бонбон",
                                            "2",
                                            "0.01").add();
                            //TOTAL
                            testSale.saleTotal(cash, "0.01");

                            //TOTAL Foreign Currency
                            //testSale.saleTotalForeignCurrency("1", cmdReceipt.FiscalSale.TypeOfChange.currentCurrency);
                            //TOTAL Debit Card
                            //testSale.saleTotalDebitCard("", cmdReceipt.FiscalSale.TypeOfCardPayment.paymentWithPoints);

                            //Combined Payment test, please increase the amount of the item
                            //testSale.saleTotal(cash,"0.10");
                            //testSale.saleTotal(debit_card,"");
                            //Save info after Total of fiscal receipt

                            //If Client Data Info is valid
                            clientInfo.saveClientInfo();
                            fiscalReceipt.closeFiscalReceipt();
                        }
                    }
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnStructInfo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStructInfoEJ dialog = null;
                try {
                    dialog = new DialogStructInfoEJ();
                    dialog.setPreferredSize(new Dimension(520, 520));
                    dialog.pack();
                    dialog.setTitle("Structured Info");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnNonFiscalReceipt.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                cmdReceipt.NonFiscalReceipt myTestNonfiscalRec = new cmdReceipt.NonFiscalReceipt();
                try {
                    if (!myTestNonfiscalRec.isOpen()) myTestNonfiscalRec.openNonFiscalReceipt();
                    myTestNonfiscalRec.printBarcode(EAN8, "1234567", 0);
                    myTestNonfiscalRec.printBarcode(EAN13, "123456789191", 0);
                    myTestNonfiscalRec.printBarcode(Code128, "123456789191", 0);
                    myTestNonfiscalRec.printBarcode(Interleave, "123456789191", 0);
                    //bcQRSize - Dots multiplier ( 3...10 ) for QR barcodes and PDF417 barcodes. Default: 4;
                    myTestNonfiscalRec.printBarcode(QRcode, "1234567", 10);
                    myTestNonfiscalRec.printBarcode(PDF417trunc, "123456789191", 10);
                    myTestNonfiscalRec.printBarcode(PDF417normal, "123456789191", 10);
                    myTestNonfiscalRec.closeNonFiscalReceipt();
                } catch (Exception ex) {
                    errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });


        cbxSerialPort.addPopupMenuListener(new PopupMenuListener() {
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                cbxSerialPort.setModel(new DefaultComboBoxModel(listPCSerialPort()));
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {

            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {

            }
        });
        btnAdditionaDayInfo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalDayInfo dialog = null;
                try {
                    dialog = new AdditionalDayInfo();
                    dialog.setPreferredSize(new Dimension(520, 520));
                    dialog.pack();
                    dialog.setTitle("Structured Info");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnOperatorsInfo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                OperatorInformation dialog = null;
                try {
                    dialog = new OperatorInformation();
                    dialog.setPreferredSize(new Dimension(520, 520));
                    dialog.pack();
                    dialog.setTitle("Information for operator");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnReceiptAsImg.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogReceiptToImg dialog = null;
                try {
                    dialog = new DialogReceiptToImg();
                    dialog.setPreferredSize(new Dimension(600, 400));
                    dialog.pack();
                    dialog.setTitle("Receipt to Image Converter...");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }


            }
        });
        btnPinpadDemo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPinpadDemo dialog = null;
                try {
                    dialog = new DialogPinpadDemo();
                    dialog.setPreferredSize(new Dimension(610, 630));
                    dialog.pack();
                    dialog.setTitle("Pinpad demo...");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });


    }

    private void buttonsEnable(boolean connected) {
        btnHeaderFooter.setEnabled(connected);
        btnCashInCashOut.setEnabled(connected);
        btnVATConfig.setEnabled(connected);
        btnItems.setEnabled(connected);
        btnJournalSearch.setEnabled(connected);
        btnPrintConfig.setEnabled(connected);
        btnCommand.setEnabled(connected);
        btnDeviceStatus.setEnabled(connected);
        btnDayliXReport.setEnabled(connected);
        btnDayliZReport.setEnabled(connected);
        btnTestSale.setEnabled(connected);
        btnExSale.setEnabled(connected);
        btnStorno.setEnabled(connected);
        btnCloseAll.setEnabled(connected);
        btnSetDateTime.setEnabled(connected);
        btnGraphicalLogo.setEnabled(connected);
        btnNetSettings.setEnabled(connected);
        btnInvoice.setEnabled(connected);
        btnStructInfo.setEnabled(connected);
        btnNonFiscalReceipt.setEnabled(connected);
        btnDepartments.setEnabled(connected);
        btnAdditionaDayInfo.setEnabled(connected);
        btnOperatorsInfo.setEnabled(connected);
        btnReceiptAsImg.setEnabled(connected);
        btnPinpadDemo.setEnabled(connected);

    }

    /**
     * This method attempts to refuse a fiscal or non-fiscal receipt.
     * And if there is a startup payment on the amount and it is not fully paid,
     * it issues a payment message.
     */
    private void closeAll() throws Exception {
        cmdReceipt.FiscalReceipt fiscalReceipt = new cmdReceipt.FiscalReceipt();
        cmdReceipt.FiscalReceipt.NonFiscalReceipt noFiscalReceipt = new cmdReceipt.FiscalReceipt.NonFiscalReceipt();
        if (noFiscalReceipt.isOpen()) {
            noFiscalReceipt.closeNonFiscalReceipt();
            return;
        }
        if (fiscalReceipt.isOpen()) tryToCloseFiscalReceipt(fiscalReceipt);
    }

    private void tryToCloseFiscalReceipt(cmdReceipt.FiscalReceipt thisReceipt) throws Exception {

        final Double owedSum;//owedSum=Amount-Tender
        owedSum = new cmdReceipt.FiscalTransaction().getNotPaid();
        Double payedSum = new cmdReceipt.FiscalTransaction().getPaid();
        Double amount = new cmdReceipt.FiscalTransaction().getAmount();
        if (amount == 0.00) {
            //If items has add to document with 0.00 amount or no Items in Document
            thisReceipt.cancel();
            return;
        }
        int dialogResult = -1;
        //If a TOTAL in the opened receipt has not been set, it will closed or canceled
        if (payedSum == 0.0) {
            dialogResult = JOptionPane.showConfirmDialog(paneMain, "No payment started on this receipt,\n\n" +
                    "Yes-Pay the whole amount,No-Cancel receipt", "Close receipt?", JOptionPane.YES_NO_OPTION);
            if (dialogResult == 0) {
                payFull();
                closeFiscalDocument(thisReceipt);
            }
            if (dialogResult == 1)
                thisReceipt.cancel();
            return;
        }
        //If a TOTAL is set with a partial payment, there is a Amount and Tender is positive.
        //Offer payment of the amount and completion of the sale.
        if (owedSum > 0.0) {
            String sQuestion = String.format("Payment has already started.\n\r" +
                    "Do you want to pay the owed sum: %2.2f -and close it?", owedSum);
            dialogResult = JOptionPane.showConfirmDialog(paneMain, sQuestion, "Cancel receipt", JOptionPane.YES_NO_OPTION);
            if (dialogResult == 0) {
                payFull();
                closeFiscalDocument(thisReceipt);
            } else {
                thisReceipt.cancel();
            }
        } else {
            //If a TOTAL is set with a full payment, there is a Amount-Tender=0.
            //All is OK, completion of the sale!
            closeFiscalDocument(thisReceipt);
        }


    }

    private void closeFiscalDocument(cmdReceipt.FiscalReceipt thisReceipt) throws Exception {
        try {
            thisReceipt.closeFiscalReceipt();
        } catch (FiscalException e) {
            if (e.getErrorCode() == FiscalErrorCodesV2.ERR_R_WRONG_BUYERS_DATA) {
                DialogClientInfo dialog = new DialogClientInfo();
                if (dialog.doModal() == dialog.ID_OK) dialog.getClientInfo().saveClientInfo();
            }
            errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
    }

    private void payFull() throws Exception {
        //TOTAL
        new cmdReceipt.FiscalSale().saleTotal(cash, "");
    }

    private String[] listPCSerialPort() {
        SerialPort[] ports = SerialPort.getCommPorts();
        String[] RS232_PORTS_LIST = new String[ports.length];
        for (int i = 0; i < ports.length; ++i) {

            RS232_PORTS_LIST[i] = ports[i].getSystemPortName();
        }
        return RS232_PORTS_LIST;

    }


}

