package connectivity;

import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;

/**
 * @author DatecsSoft_Team
 */

public interface PrinterConnection 
{

    DatecsFiscalDevice open(String portName) throws Exception;
    
    void close() throws Exception;

    void setBaudRate(int baudRate) throws Exception;

    void setTimeout(int timeout) throws Exception;

    void setPortName(String portName) throws Exception;
    
         String    getPortName() throws Exception;
    
  //  Object getSyncObject() throws Exception;

    boolean isSearchByBaudRateEnabled();




    /**
     * Enables whether a status is a critical exception
     *
     * @return
     */
    default boolean[][] initCriticalStatus() {
        boolean[][] myCriticalStatusSet = new boolean[8][8];
        myCriticalStatusSet[0][7] = false; //"For internal use  1."
        myCriticalStatusSet[0][6] = true;////"Cover is Open"
        myCriticalStatusSet[0][5] = true; // General error - this is OR of all errors marked with #.
        myCriticalStatusSet[0][4] = true;////"# Failure in printing mechanism"
        myCriticalStatusSet[0][3] = false;//"Always 0."
        myCriticalStatusSet[0][2] = false;//"The real time clock is not synchronized"
        myCriticalStatusSet[0][1] = true;//"# Command code is invalid"
        myCriticalStatusSet[0][0] = true;//"# Syntax error"
        myCriticalStatusSet[1][7] = false;//"For internal use  1"
        myCriticalStatusSet[1][6] = false;//"For internal use  0"
        myCriticalStatusSet[1][5] = false;//"For internal use  0"
        myCriticalStatusSet[1][4] = false;//"For internal use  0"
        myCriticalStatusSet[1][3] = false;//"For internal use  0"
        myCriticalStatusSet[1][2] = false;//"For internal use  0"
        myCriticalStatusSet[1][1] = true;//"# Command is not permitted"
        myCriticalStatusSet[1][0] = true;//"# Overflow during command execution"
        myCriticalStatusSet[2][7] = false;//"For internal use  1."
        myCriticalStatusSet[2][6] = false;//"For internal use  0."
        myCriticalStatusSet[2][5] = false;//"Non fiscal receipt is open"
        myCriticalStatusSet[2][4] = false;//"EJ nearly full."
        myCriticalStatusSet[2][3] = false;//"Fiscal receipt is Open."
        myCriticalStatusSet[2][2] = true; //"EJ full."
        myCriticalStatusSet[2][1] = false; //"Near paper end."
        myCriticalStatusSet[2][0] = true;  //"#End of paper."
        myCriticalStatusSet[3][7] = false; //"For internal use  1"
        myCriticalStatusSet[3][6] = false; //"For internal use  0"
        myCriticalStatusSet[3][5] = false; //"For internal use  0"
        myCriticalStatusSet[3][4] = false; //"For internal use  0"
        myCriticalStatusSet[3][3] = false; //"For internal use  0"
        myCriticalStatusSet[3][2] = false; //"For internal use  0"
        myCriticalStatusSet[3][1] = false; //"For internal use  0"
        myCriticalStatusSet[3][0] = false; //"For internal use  0"
        myCriticalStatusSet[4][7] = false;//"For internal use  1"
        myCriticalStatusSet[4][6] = true;//"Fiscal memory is not found or damaged"
        myCriticalStatusSet[4][5] = true; //"OR of all errors marked with *  Bytes 4 - 5"
        myCriticalStatusSet[4][4] = true;//"* Fiscal memory is full."
        myCriticalStatusSet[4][3] = false; //"There is space for less then 60 reports in Fiscal memory."
        myCriticalStatusSet[4][2] = false; //"Serial number and number of FM are not set"
        myCriticalStatusSet[4][1] = false;//"Tax number is not set"
        myCriticalStatusSet[4][0] = true;//"* Error accessing data in the FM"
        myCriticalStatusSet[5][7] = false;//"For internal use  1."
        myCriticalStatusSet[5][6] = false;//"For internal use  0."
        myCriticalStatusSet[5][5] = false; //"For internal use  0."
        myCriticalStatusSet[5][4] = false; //"VAT are not set at least once."
        myCriticalStatusSet[5][3] = false;//"Device is not fiscalized."
        myCriticalStatusSet[5][2] = true; //"For internal use  0."
        myCriticalStatusSet[5][1] = true;//"FM is not formated."
        myCriticalStatusSet[5][0] = false;//"For internal use  0"
        myCriticalStatusSet[6][7] = false;//"For internal use  1"
        myCriticalStatusSet[6][6] = false;//"For internal use  0"
        myCriticalStatusSet[6][5] = false;//"For internal use  0"
        myCriticalStatusSet[6][4] = false;//"For internal use  0"
        myCriticalStatusSet[6][3] = false;//"For internal use  0"
        myCriticalStatusSet[6][2] = false;//"For internal use  0"
        myCriticalStatusSet[6][1] = false;//"For internal use  0"
        myCriticalStatusSet[6][0] = false;//"For internal use  0"
        return myCriticalStatusSet;
    }



}
