import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdReceipt;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdService;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdReceipt.InvoiceClientInfo.BulstatType.EIK;

public class DialogStornoAB extends JDialog {
    private JPanel contentPane;
    private JButton btnOpenPrintStorno;
    private JButton btnValidate;
    private JTextField edTillNumber;
    private JComboBox cbxOperator;
    private JPasswordField edOpPass;
    private JComboBox cbxStornoType;
    private JTextField edDocumentDate;
    private JTextField edDocumentTime;
    private JTextField edStornoUNP;
    private JTextField edStornoReason;
    private JTextField edDocumentUNP;
    private JTextField edDocumentNumber;
    private JTextField edFiscalMemoryNum;
    private JButton btnAddItem;
    private JCheckBox chbIssueStorno;
    private JCheckBox chbInvoice;
    private JLabel labOpPsw;
    private JLabel labTillNum;
    private JLabel labOperator;
    private JLabel labTypeStorno;
    private JLabel labStornoUnp;
    private JLabel labStornoReason;
    private JLabel labDocDate;
    private JLabel labDocTime;
    private JLabel labDocUNP;
    private JLabel labDocNum;
    private JLabel labFMNum;
    private JTextField edInvoiceNumber;
    private JLabel labInvoiceNumber;
    private JButton btnSearchEj;
    private SimpleDateFormat stornoDateFormat = new SimpleDateFormat("ddMMyy");
    private SimpleDateFormat stornoTimeFormat = new SimpleDateFormat("HHmmss");


    public DialogStornoAB() throws Exception {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnOpenPrintStorno);
        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        // Init
        Integer maxOperators = 0;
        if (MainFormAB.myFiscalDevice.isConnectedPrinter())
            maxOperators = MainFormAB.myFiscalDevice.getConnectedPrinterV1().getMaxOperators();
        if (MainFormAB.myFiscalDevice.isConnectedECR())
            maxOperators = MainFormAB.myFiscalDevice.getConnectedECRV1().getMaxOperators();
        //Init
        List<String> ls = new ArrayList<String>();
        for (int i = 1; i <= maxOperators; i++) ls.add("Operator: " + i);
        cbxOperator.setModel(new DefaultComboBoxModel(ls.toArray()));

        String operatorPassword = "";
        if (MainFormAB.myFiscalDevice.isConnectedPrinter())
            operatorPassword = MainFormAB.myFiscalDevice.getConnectedPrinterV1().getDefaultOpPass();

        if (MainFormAB.myFiscalDevice.isConnectedECR()) {
            edStornoUNP.setEnabled(false);   //Not supported on  DP-05, DP-25, DP-35, WP-50, DP-150
            chbIssueStorno.setEnabled(false);
            edStornoReason.setEnabled(false);
            operatorPassword = MainFormAB.myFiscalDevice.getConnectedECRV1().getDefaultOpPass();
        }
        edOpPass.setText(operatorPassword);

        String unp = new cmdInfo().GetDeviceSerialNumber() + "-" +
                String.format("%04d", cbxOperator.getSelectedIndex() + 1) + "-"; // Pad left with trailing zero

        edStornoUNP.setText(unp + String.format("%07d", 1 + Integer.valueOf(new cmdReceipt.FiscalReceipt().getLastDocNumber()))); //Next Document number
        edDocumentUNP.setText(unp + "0000000");
        edFiscalMemoryNum.setText(new cmdService().GetFiscalMemoryNumber());
        btnOpenPrintStorno.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (chbIssueStorno.isSelected()) { //Print Storno
                    if (chbInvoice.isSelected()) printInvoiceStorno();
                    else printReceiptStorno();

                } else { //Open new Storno of Document
                    if (chbInvoice.isSelected()) openInvoiceToAddItems();
                    else openStornoToAddItems();
                }
            }
        });

        btnAddItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //Creating Strono receipt as a fiscal receipt.
                cmdReceipt.FiscalReceipt stornoReceipt = new cmdReceipt.FiscalReceipt();

                try {
                    if (stornoReceipt.isOpen()) {
                        //Creating fiscal sale (storno) in opened receipt.
                        cmdReceipt.FiscalReceipt.FiscalSale itemStorno = new cmdReceipt.FiscalReceipt.FiscalSale();

                        itemStorno.add(
                                "Демонстрация",
                                "Сторно на стока",
                                "Б",  //А, Б, В...
                                "0.01",
                                "",
                                "", //Note! Units is not supported on DP-05, DP-25, DP-35 , WP-50, DP-150
                                cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.noCorecction,
                                "");

                        //TOTAL
                        stornoReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        cmdReceipt.TotalResult totalResult = itemStorno.saleTotal(
                                "Тотал:",
                                "",
                                cmdReceipt.FiscalReceipt.FiscalSale.PaidMode.fromOrdinal(0).getId(), //Cash
                                "0.01");


                        if (chbInvoice.isSelected())
                        /**Invoice Items case
                         *
                         Except for the first all other parameters are not required. If you have to ask
                         any parameter, all before it must be set. If a blank or unsupported parameter is left
                         empty space to fill the hand.
                         */
                            new cmdReceipt.InvoiceClientInfo("000713391",EIK,  "", "", "", "", "", "").saveClientInfo();
                        //CLOSE
                        stornoReceipt.closeFiscalReceipt();

                    }
                } catch (Exception e1) {
                    MainFormAB.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnValidate.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                List<Boolean> isValidateOK = new ArrayList<>();
                //Validate only fields used to Issue of Strono by Document Number
                if (chbIssueStorno.isSelected()) {
                    isValidateOK = new cmdReceipt.FiscalReceipt.Storno().capIssueStornoReceipt(
                            String.valueOf(
                                    cbxOperator.getSelectedIndex() + 1),    //0
                            edOpPass.getText(),                     //1
                            edTillNumber.getText(),                 //2
                            edStornoUNP.getText(),                  //3
                            //Get ID (E,R ot T) of StornoType by Index:
                            cmdReceipt.FiscalReceipt.Storno.StornoType.fromOrdinal((int) cbxStornoType.getSelectedIndex()),  //4
                            edDocumentNumber.getText(),             //5
                            edStornoReason.getText());              //6
                } else {
                    //Validate  fields used to Open new Storno
                    isValidateOK = new cmdReceipt.FiscalReceipt.Storno().capIssueStornoReceipt(

                            String.valueOf(cbxOperator.getSelectedIndex() + 1),     //0
                            edOpPass.getText(),                                     //1
                            edTillNumber.getText(),                                 //2
                            edStornoUNP.getText(),                                  //3
                            //Get ID (E,R ot T) of StornoType by Index:
                            cmdReceipt.FiscalReceipt.Storno.StornoType.fromOrdinal(cbxStornoType.getSelectedIndex()),  //4
                            edDocumentNumber.getText(),                             //5
                            edDocumentUNP.getText(),                                //6
                            edDocumentDate.getText() + edDocumentTime.getText(),      //7
                            edFiscalMemoryNum.getText().toString(),                 //8
                            edStornoReason.getText().toString()                     //9
                    );
                }
                markAllInvalidFieldsInRED(isValidateOK);
            }
        });
        chbIssueStorno.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setFields(chbIssueStorno.isSelected());
            }
        });
        chbInvoice.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                edInvoiceNumber.setEnabled(chbInvoice.isSelected());
                labInvoiceNumber.setEnabled(chbInvoice.isSelected());
                edStornoReason.setEnabled(true);
                edStornoReason.setText("Explain the reason");
            }
        });

        btnSearchEj.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                try {
                    if (MainFormAB.getConnectedFD().isConnectedPrinter()) {
                        cmdEJStructInfoA cmd = new cmdEJStructInfoA();
                        cmdEJStructInfoA.DocInfo docInfoFound = cmd.ReadDocInfo(Integer.valueOf(edDocumentNumber.getText()));
                        if (docInfoFound.getRecType() == null)
                            MainFormAB.errListModel.add(0, "Not found in EJ Receipt :" + edDocumentNumber.getText());
                        else recInfoDialogA(docInfoFound);

                    } else if (MainFormAB.getConnectedFD().isConnectedECR()) {
                        cmdEJStructInfoB cmd = new cmdEJStructInfoB();
                        cmdEJStructInfoB.DocInfo docInfoFound = cmd.ReadDocInfo(Integer.valueOf(edDocumentNumber.getText()));
                        if (docInfoFound == null)
                            MainFormAB.errListModel.add(0, "Not found in EJ Receipt :" + edDocumentNumber.getText());
                        else recInfoDialogB(docInfoFound);
                    }

                } catch (Exception exception) {
                    MainFormAB.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });
    }

    private void openStornoToAddItems() {
        String stornoDocDT = edDocumentDate.getText() + edDocumentTime.getText();
        try {
            new cmdReceipt.FiscalReceipt.Storno().openStornoReceipt(
                    String.valueOf(cbxOperator.getSelectedIndex() + 1),
                    edOpPass.getText(),
                    edTillNumber.getText(),
                    edStornoUNP.getText(),  //Not used on  DP-05, DP-25, DP-35, WP-50, DP-150
                    cmdReceipt.FiscalReceipt.Storno.StornoType.fromOrdinal(cbxStornoType.getSelectedIndex()), //E,R,T,
                    edDocumentNumber.getText(),
                    edDocumentUNP.getText(),
                    stornoDocDT,
                    edFiscalMemoryNum.getText(),
                    edStornoReason.getText());
        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
    }

    private void openInvoiceToAddItems() {
        String stornoDocDT = edDocumentDate.getText() + edDocumentTime.getText();
        try {
            new cmdReceipt.FiscalReceipt.Storno().openStornoInvoice(
                    String.valueOf(cbxOperator.getSelectedIndex() + 1),
                    edOpPass.getText(),
                    edTillNumber.getText(),
                    edStornoUNP.getText(),
                    cmdReceipt.FiscalReceipt.Storno.StornoType.fromOrdinal(cbxStornoType.getSelectedIndex()), //E,R,T,
                    edDocumentNumber.getText(),
                    edDocumentUNP.getText(),
                    stornoDocDT,
                    edFiscalMemoryNum.getText(),
                    edDocumentNumber.getText(),
                    edStornoReason.getText());
        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

    }

    private void printInvoiceStorno() {
        try {
            cmdReceipt.FiscalReceipt.Storno stornoInvoice = new cmdReceipt.FiscalReceipt.Storno();
            stornoInvoice.printStornoInvoice(
                    String.valueOf(cbxOperator.getSelectedIndex() + 1),
                    edOpPass.getText(),
                    edTillNumber.getText(),
                    edStornoUNP.getText(),
                    cmdReceipt.FiscalReceipt.Storno.StornoType.fromOrdinal(cbxStornoType.getSelectedIndex()), //E,R,T
                    edDocumentNumber.getText(),
                    "", //Not Mandatory parameter
                    edStornoReason.getText()
            );
        } catch (Exception e1) {
            MainFormAB.errListModel.add(0, e1.getMessage());
            e1.printStackTrace();
        }
    }

    private void printReceiptStorno() {
        try {
            new cmdReceipt.FiscalReceipt.Storno(
                    String.valueOf(cbxOperator.getSelectedIndex() + 1),
                    edOpPass.getText(),
                    edTillNumber.getText(),
                    edStornoUNP.getText(),
                    cmdReceipt.FiscalReceipt.Storno.StornoType.fromOrdinal(cbxStornoType.getSelectedIndex()), //E,R,T
                    edDocumentNumber.getText(),
                    edStornoReason.getText()
            ).printStornoReceipt();
        } catch (Exception e1) {
            MainFormAB.errListModel.add(0, e1.getMessage());
            e1.printStackTrace();
        }
    }

    /**
     * @param isValidateOK
     */
    private void markAllInvalidFieldsInRED(List<Boolean> isValidateOK) {
        Color color;

        if (edTillNumber.getText().trim().length() == 0)
            edTillNumber.setText("???");

        if (edOpPass.getText().trim().length() == 0)
            edOpPass.setText("????");

        if (edDocumentNumber.getText().trim().length() == 0)
            edDocumentNumber.setText("???");


        if (isValidateOK.size() == 7) //Case of print (issue) storno
        {
            if (!isValidateOK.get(0)) color = Color.RED;
            else color = Color.BLACK;
            labOperator.setForeground(color);

            if (!isValidateOK.get(1)) color = Color.RED;
            else color = Color.BLACK;
            labOpPsw.setForeground(color);

            if (!isValidateOK.get(2)) color = Color.RED;
            else color = Color.BLACK;
            labTillNum.setForeground(color);


            if (!isValidateOK.get(3)) color = Color.RED;
            else color = Color.BLACK;
            labStornoUnp.setForeground(color);

            if (!isValidateOK.get(4)) color = Color.RED;
            else color = Color.BLACK;
            labTypeStorno.setForeground(color);

            if (!isValidateOK.get(5)) color = Color.RED;
            else color = Color.BLACK;
            labDocNum.setForeground(color);

            if (!isValidateOK.get(6)) color = Color.RED;
            else color = Color.BLACK;
            labStornoReason.setForeground(color);

        } else //Case of open storno
        {
            if (edDocumentDate.getText().trim().length() == 0)
                edDocumentDate.setText("DDMMYY");

            if (edDocumentTime.getText().trim().length() == 0)
                edDocumentTime.setText("HHMMSS");

            if (edDocumentUNP.getText().trim().length() == 0)
                edDocumentUNP.setText("????????-???-??????");

            if (!isValidateOK.get(0)) color = Color.RED;
            else color = Color.BLACK;
            labOperator.setForeground(color);

            if (!isValidateOK.get(1)) color = Color.RED;
            else color = Color.BLACK;
            labOpPsw.setForeground(color);

            if (!isValidateOK.get(2)) color = Color.RED;
            else color = Color.BLACK;
            labTillNum.setForeground(color);

            if (!isValidateOK.get(3)) color = Color.RED;
            else color = Color.BLACK;
            labStornoUnp.setForeground(color);

            if (!isValidateOK.get(4)) color = Color.RED;
            else color = Color.BLACK;
            labTypeStorno.setForeground(color);

            if (!isValidateOK.get(5)) color = Color.RED;
            else color = Color.BLACK;
            labDocNum.setForeground(color);
            if (!isValidateOK.get(6)) color = Color.RED;
            else color = Color.BLACK;
            labDocUNP.setForeground(color);

            if (!isValidateOK.get(7)) color = Color.RED;
            else color = Color.BLACK;
            labDocDate.setForeground(color);
            labDocTime.setForeground(color);

            if (!isValidateOK.get(8)) color = Color.RED;
            else color = Color.BLACK;
            labFMNum.setForeground(color);

            if (!isValidateOK.get(9)) color = Color.RED;
            else color = Color.BLACK;
            labStornoReason.setForeground(color);


        }

    }

    private void setFields(boolean isIssueStorno) {

        edDocumentTime.setEnabled(!isIssueStorno);      //No need for issue
        labDocTime.setEnabled(!isIssueStorno);
        edDocumentDate.setEnabled(!isIssueStorno);      //No need for issue
        labDocDate.setEnabled(!isIssueStorno);
        edDocumentUNP.setEnabled(!isIssueStorno);       //No need for issue
        labDocUNP.setEnabled(!isIssueStorno);
        edFiscalMemoryNum.setEnabled(!isIssueStorno);   //No need for issue
        labFMNum.setEnabled(!isIssueStorno);
        btnAddItem.setEnabled(!isIssueStorno);          //No need for issue

        try {
            if (isIssueStorno) {
                btnOpenPrintStorno.setText("Print...");
                edDocumentDate.setText("");
                edDocumentTime.setText("");
                edDocumentUNP.setText("");
                edFiscalMemoryNum.setText("");
            } else {
                //Unp Prefix of Searched  document
                String unpPrefix = new cmdInfo().GetDeviceSerialNumber() + "-" + String.format("%04d", cbxOperator.getSelectedIndex() + 1) + "-???????";
                btnOpenPrintStorno.setText("Open...");
                edFiscalMemoryNum.setText(new cmdService().GetFiscalMemoryNumber());

                String currentDate = stornoDateFormat.format(new Date());
                edDocumentDate.setText(currentDate);
                String currentTime = stornoTimeFormat.format(new Date());
                edDocumentTime.setText(currentTime);
                edDocumentUNP.setText(unpPrefix);
            }
        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

    }

    /**
     * Analyzes the information from the document found in EJ.
     * And allows the data from it to be used for the issuance of a storno document.
     *
     * @param recInfo
     */
    private void recInfoDialogA(cmdEJStructInfoA.DocInfo recInfo) {
        String title = "Document found...";
        if (recInfo == null) return;

        String msg = "";
        switch (recInfo.getRecType()) {
            case fiscal:
                msg = "Fiscal receipt.";
                break;
            case invoice:
                msg = "Fiscal  invoice.";
                chbInvoice.setSelected(true);
                edInvoiceNumber.setText(String.valueOf(recInfo.getInvoiceNumber()));
                break;
            case reversal:
                msg = "Storno receipt.";
                break;
            case credit_note:
                msg = "Storno receipt.Credit note.";
                break;
            case cancelled:
                msg = "Canceled receipt";
                break;
            case cancelled_storno:
                msg = "Canceled storno receipt.";
                break;
            case cancelled_invoice:
                msg = "Canceled invoice";
                break;
            case cancelled_credit_note:
                msg = "Cancelled credit note";
                break;
            default:
                msg = "Error";

        }

        int option = JOptionPane.showConfirmDialog(null, msg, title, JOptionPane.OK_CANCEL_OPTION);
        if (option == JOptionPane.OK_OPTION) {

            cbxOperator.setSelectedIndex(recInfo.getDocOperNum() - 1);
            edTillNumber.setText(String.valueOf(recInfo.getTillNum()));
            edDocumentUNP.setText(recInfo.getDocUNP());
            try {
                Date dateEJ = new SimpleDateFormat("dd-MM-yyyy").parse(recInfo.getDocFinishedDate());
                edDocumentDate.setText(stornoDateFormat.format(dateEJ));
                edDocumentTime.setText(recInfo.getDocFinishedTime().replace(":", ""));
            } catch (ParseException e) {
                e.printStackTrace();
            }

        } else {
            //System.out.println(""); Bye !
        }

    }

    /**
     * Analyzes the information from the document found in EJ.
     * And allows the data from it to be used for the issuance of a storno document.
     *
     * @param recInfo
     */
    private void recInfoDialogB(cmdEJStructInfoB.DocInfo recInfo) {
        String title = "Document found...";
        if (recInfo == null) return;


        String msg = "";
        if (recInfo.ismCanceled()) msg += "Canceled ";

        switch (recInfo.getFoundDocumentType()) {
            case notUsed:
                msg += "Error...";
                break;
            case fiscal:
                msg += "Fiscal receipt.";
                break;
            case invoice:
                msg += "Fiscal  invoice.";
                if(!chbInvoice.isSelected()) chbInvoice.doClick();
                edInvoiceNumber.setText(String.valueOf(recInfo.getInvoiceNumber()));
                break;
            case storno:
                msg += "Storno receipt.";
                break;
            case creditNote:
                msg += "Credit note.\n";
                msg += "\nOperator: " + recInfo.getOperator();
                msg += "\nInvoice number : " + recInfo.getCreditNoteNum();
                break;
            case cashIn:
                msg += "CashIn receipt";
                break;
            case cashOut:
                msg += "CashOut receipt";
                break;
            case xReport:
                msg += "X report";
                break;
            case zReport:
                msg += "Z report ";
                break;
            case nonFiscal:
                msg += "Non fiscal ";
                break;


        }

        int option = JOptionPane.showConfirmDialog(null, msg, title, JOptionPane.OK_CANCEL_OPTION);
        if (option == JOptionPane.OK_OPTION) {

            cbxOperator.setSelectedIndex(recInfo.getOperator() - 1);
            edDocumentDate.setText(recInfo.getDate().replace("-",""));
            edDocumentTime.setText(recInfo.getTime().replace(":",""));


        } else {
            //System.out.println(""); Bye !
        }


    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) throws Exception {
        DialogStornoAB dialog = new DialogStornoAB();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

}
