
import com.datecs.fiscalprinter.SDK.BuildInfo;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.*;
import com.fazecast.jSerialComm.SerialPort;
import connectivity.*;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class MainFormAB {
    public static DefaultListModel errListModel;
    private JButton btnConnect;
    public JPanel paneMain;
    private JComboBox cbxSerialPort;
    private JComboBox cbxBoudrate;
    private JLabel labDevice;
    private JButton btnSaleTest;
    private JButton btnCloseAll;
    private JButton btnDailyXReport;
    private JButton btnDailyZReport;
    private JButton btnSetDateTime;

    private JButton btnStorno;
    private JList list1;
    private JButton btnHeaderFooter;
    private JButton btnCashInCashOut;
    private JButton btnVATConfig;
    private JButton btnItems;
    private JButton btnJournalSearch;
    private JButton btnPrintConfig;
    private JButton btnCommand;
    private JButton btnDeviceStatus;
    private JButton btnClearErrList;
    private JComboBox cbxConnectionType;
    private JTextField edHostAddress;
    private JLabel lbType;
    private JLabel lbHost;
    private JLabel labSerialPort;
    private JLabel labBoudrate;
    private JButton btnInvoice;
    private JButton btnLANSettings;
    private JButton btnStructuredInfo;
    private JButton btnNonFiscalTest;
    private JButton btnAdditionalDayInfo;
    private JButton btnOperatorInformation;
    private JButton btnReceiptToImage;
    private JButton btnPinpadDemo;
    private PrinterConnection fdConnection;
    public static DatecsFiscalDevice myFiscalDevice;

    public MainFormAB() {
        errListModel = new DefaultListModel();
        list1.setModel(errListModel);

        cbxSerialPort.setModel(new DefaultComboBoxModel(listPCSerialPort()));
        cbxBoudrate.setModel(new DefaultComboBoxModel(Const.RS232_BAUD_RATE_VALUES));
        cbxBoudrate.setSelectedIndex(8);
        cmdReceipt.FiscalReceipt fiscalReceipt = new cmdReceipt.FiscalReceipt();
        cmdReceipt.NonFiscalReceipt noFiscalReceipt = new cmdReceipt.NonFiscalReceipt();

        Border border = BorderFactory.createTitledBorder("Datecs Java SDK Build:" + BuildInfo.VERSION);
        paneMain.setBorder(border);

        btnConnect.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    //Disconnect if device is connected
                    if (myFiscalDevice != null) {
                        myFiscalDevice.close();
                        fdConnection.close();
                        myFiscalDevice = null;
                        btnConnect.setText("Connect...");
                        buttonsEnable(false);
                        labDevice.setText(":");
                        return;
                    }
                    if (cbxConnectionType.getSelectedItem() == "RS232") {
                        fdConnection = PrinterConnectionFactory.createInstance("RS232_DEVICE_BUS");
                        fdConnection.setBaudRate(Integer.valueOf(cbxBoudrate.getSelectedItem().toString()));
                        //By this method we open the serial port and ask the model vendor name, if the model
                        //is supported in this SDK, we create an instance of the respective model class.
                        myFiscalDevice = fdConnection.open(cbxSerialPort.getSelectedItem().toString());
                        labDevice.setText(SerialPrinterConnector.getModelName());
                    } else {
                        fdConnection = PrinterConnectionFactory.createInstance("ETHERNET_DEVICE_BUS");
                        //By this method we open the serial port and ask the model vendor name, if the model
                        //is supported in this SDK, we create an instance of the respective model class.
                        myFiscalDevice = fdConnection.open(edHostAddress.getText());
                        labDevice.setText(SocketConnector.getModelName());
                    }

                    if (myFiscalDevice.isConnectedECR() || myFiscalDevice.isConnectedPrinter()) {
                        buttonsEnable(true);
                        btnConnect.setText("Disconnect...");

                        //"Optional Text in Response"- Allows SDK users to see the error messages in the response of each command,
                        // this option is valid only at DATECS FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F/ FMP-10 / FP-550.
                        // Thus, if an error occurred, and if option setThrowErrorMessage(true), the "wrong" commands will throw exceptions.
                        if (myFiscalDevice.isConnectedPrinter())
                            new cmdService().setErrorMessageInResponse(true); //Turn ON Fiscal Device mode "Optional Text in Response":

                        //To check the status of the device, send a command to fill in the status bits
                        if (myFiscalDevice.isConnectedECR())
                            new cmdInfo().GetDeviceSerialNumber();

                    } else {
                        labDevice.setText("Fiscal Device not detected.");
                        buttonsEnable(false);
                    }

                } catch (Exception ex) {
                    labDevice.setText(":");
                    try {
                        ex.printStackTrace();
                        errListModel.add(0, ex.getMessage());
                    } catch (Exception e1) {
                        errListModel.add(0, e1.getMessage());
                        e1.printStackTrace();
                    }

                }

            }
        });
        btnSaleTest.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                String operatorCode = "1";//Operator number
                String operatorPassword = null;
                if (MainFormAB.myFiscalDevice.isConnectedPrinter())
                    operatorPassword = MainFormAB.myFiscalDevice.getConnectedPrinterV1().getDefaultOpPass();
                else if (MainFormAB.myFiscalDevice.isConnectedECR())
                    operatorPassword = MainFormAB.myFiscalDevice.getConnectedECRV1().getDefaultOpPass();

                String salePoint = "1"; //Number of work place / integer from 1 to 99999 /

                try {
                    getConnectedFD();
                    if (!fiscalReceipt.isOpen()) {
                        //FOR DATECS FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F/ FMP-10 / FP-550
                        /**
                         *
                         *    UNP Unique sales number format:
                         * - serial number of the fiscal device
                         * - operator code (four digits or Latin characters)
                         * - sequential sales number (seven digits with leading zeros)
                         *   example: DT000600-0001-0001000
                         *
                         *  Note: DATECS FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F/ FMP-10 / FP-550 Only!
                         *
                         *  Before the first sale, the UNP must be set at least once
                         *  if then omitted the parameter device will increment with the number
                         *  of the sale automatically.
                         *
                         */

                        String unp = new cmdInfo().GetDeviceSerialNumber() + "-" +
                                String.format("%04d", Integer.parseInt(operatorCode)) + "-" + // Pad left with trailing zero
                                String.format("%07d", 1 + Integer.valueOf(fiscalReceipt.getLastUNP()));  //Next Document number pad left with trailing zero

                        fiscalReceipt.openFiscalReceipt(operatorCode, operatorPassword, salePoint, unp);    //Internal generated  unp="".
                        cmdReceipt.FiscalReceipt.FiscalSale testSale = new cmdReceipt.FiscalReceipt.FiscalSale();

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        //Registration of items for sale
                        fiscalReceipt.printFreeText("Тест продажба без параметри!", true, true, true, cmdReceipt.FiscalReceipt.FreeFiscalTextType.type32dpiA);
                        testSale.add(
                                "",
                                "",
                                "Б", //А, Б, В...
                                "0.01",
                                "",
                                "",
                                cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.noCorecction,
                                "");

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash_space);
                        testSale.add(
                                "Демонстрация",
                                "продажба с количество",
                                "Б",  //А, Б, В...
                                "0.01",
                                "1",
                                "Кг", //Note! Units is not supported on DP-05, DP-25, DP-35 , WP-50, DP-150
                                cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.noCorecction,
                                "");

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        testSale.add(
                                "Демонстрация",
                                "Процентна отстъпка",
                                "Б", //А, Б, В...
                                "0.11",
                                "10",
                                "Кг",  //Note! Units is not supported on DP-05, DP-25, DP-35 , WP-50, DP-150
                                cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.discountPercentage,
                                "-10"); // Use sign !

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash_space);
                        testSale.add(
                                "Демонстрация",
                                "Отстъпка по стойност",
                                "Б", //А, Б, В...
                                "0.11",
                                "10",
                                "Литри", //Note! Units is not supported on DP-05, DP-25, DP-35 , WP-50, DP-150
                                cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.discountSum,
                                ".5");
                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.equal);
                        testSale.add(
                                "Демонстрация",
                                "Надбавка в процент",
                                "Б",  //А, Б, В...
                                "0.1",
                                "10",
                                "Литри", //Note! Units is not supported on DP-05, DP-25, DP-35 , WP-50, DP-150
                                cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.surchargePercentage,
                                "1.5");

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.equal);
                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        testSale.add(
                                "",
                                "VOID !!!",
                                "Б",  //А, Б, В...
                                "-0.1",
                                "",
                                "",
                                cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.noCorecction,
                                "");


  /*                      fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        fiscalReceipt.printFreeText("EAN8 - 1234567");
                        fiscalReceipt.printBarcode("1234567", cmdReceipt.BarcodeType.EAN8, "", false);

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        fiscalReceipt.printFreeText("EAN13 - 123456789191");
                        fiscalReceipt.printBarcode("123456789191", cmdReceipt.BarcodeType.EAN13, "", false);

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        fiscalReceipt.printFreeText("Code128 - 123456789191Code128");
                        fiscalReceipt.printBarcode("01234567890123456789128", cmdReceipt.BarcodeType.Code128, "", false);
*/
                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        fiscalReceipt.printFreeText("DataMatrix - 123456789191DataMatrix");
                        fiscalReceipt.printBarcode("123456789191DataMatrix", cmdReceipt.BarcodeType.DataMatrix, "", false);

                 /*       fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        fiscalReceipt.printFreeText("QRcode - 123456789191QR");
                        fiscalReceipt.printBarcode("123456789191QR", cmdReceipt.BarcodeType.QRcode, "", false);

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        fiscalReceipt.printFreeText("ITF - 12345678");
                        fiscalReceipt.printBarcode("12345678", cmdReceipt.BarcodeType.ITF2, "", false);

                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        fiscalReceipt.printFreeText("PDF417 - 123456789191");
                        fiscalReceipt.printBarcode("123456789191PDF417", cmdReceipt.BarcodeType.PDF417, "", false);*/

                        //SUBTOTAL
                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.equal);
                        testSale.subtotal(true, true, cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.noCorecction, "");
                        fiscalReceipt.printFreeText("Отстъпка в междинната сума", true, true, true, cmdReceipt.FiscalReceipt.FreeFiscalTextType.type32dpiB);
                        testSale.subtotal(true, true, cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.discountSum, "2.52");

                        //TOTAL
                        fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                        cmdReceipt.TotalResult totalResult = testSale.saleTotal(
                                "Тотал:",
                                "",
                                cmdReceipt.FiscalReceipt.FiscalSale.PaidMode.fromOrdinal(0).getId(),
                                "0.01");

                        fiscalReceipt.printFreeText("Не се дължи плащане!", true, true, true, cmdReceipt.FiscalReceipt.FreeFiscalTextType.type32dpiA);
                        //CLOSE
                        fiscalReceipt.closeFiscalReceipt();

                    } else closeAll();

                } catch (Exception e1) {
                    e1.printStackTrace();
                    errListModel.add(0, e1.getMessage());
                }
            }

        });

        btnCloseAll.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    getConnectedFD();
                    closeAll();
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnDailyZReport.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                final cmdReport.ReportSummary reportSummary = new cmdReport.ReportSummary();
                try {

                    getConnectedFD();
                    cmdReport cmd = new cmdReport();
                    int num = cmd.PrintZreport(reportSummary);

                    JOptionPane.showMessageDialog(paneMain, "Report No:" + num + "\n\r" +
                            "Total:" + reportSummary.getTotal() + "\n\r" +
                            "Fiscal Memory Total:" + reportSummary.FM_Total);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });
        btnDailyXReport.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                final cmdReport.ReportSummary reportSummary = new cmdReport.ReportSummary();
                try {
                    getConnectedFD();
                    cmdReport cmd = new cmdReport();
                    int num = cmd.PrintXreport(reportSummary);
                    JOptionPane.showMessageDialog(paneMain, "Report No:" + num + "\n\r" +
                            "Total:" + reportSummary.getTotal() + "\n\r" +
                            "Fiscal Memory Total:" + reportSummary.FM_Total);

                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnSetDateTime.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSetDataTime dialog = null;
                try {
                    dialog = new DialogSetDataTime();
                    dialog.setPreferredSize(new Dimension(320, 240));
                    dialog.pack();
                    dialog.setTitle("Device Date and Time");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnStorno.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                System.out.println("test");
                DialogStornoAB dialog = null;
                try {
                    dialog = new DialogStornoAB();
                    dialog.setPreferredSize(new Dimension(580, 400));
                    dialog.pack();
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnCommand.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCommands dialog = null;
                try {
                    dialog = new DialogCommands();
                    dialog.setPreferredSize(new Dimension(640, 520));
                    dialog.pack();
                    dialog.setTitle("User Command Scripts");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnItems.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogItems dialog = null;
                try {
                    dialog = new DialogItems();
                    dialog.setPreferredSize(new Dimension(800, 600));
                    dialog.pack();
                    dialog.setTitle("Price Lock Up Table (PLU)");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }

        });
        btnClearErrList.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                errListModel.clear();
            }
        });
        btnHeaderFooter.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogHeaderFooter dialog = null;
                try {
                    dialog = new DialogHeaderFooter();
                    dialog.setPreferredSize(new Dimension(320, 240));
                    dialog.pack();
                    dialog.setTitle("Header&Footer");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });
        btnCashInCashOut.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCashInOut dialog = null;
                try {
                    dialog = new DialogCashInOut();
                    dialog.setPreferredSize(new Dimension(320, 240));
                    dialog.pack();
                    dialog.setTitle("Under Construction");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnVATConfig.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogVAT dialog = null;
                try {
                    dialog = new DialogVAT();
                    dialog.setPreferredSize(new Dimension(400, 240));
                    dialog.pack();
                    dialog.setTitle("Under Construction");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnStructuredInfo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStructEjInfo dialog = null;
                try {
                    dialog = new DialogStructEjInfo();
                    dialog.setPreferredSize(new Dimension(640, 480));
                    dialog.pack();
                    dialog.setTitle("Journal Structured info");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnJournalSearch.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEJSearch dialog = null;
                try {
                    dialog = new DialogEJSearch();
                    dialog.setPreferredSize(new Dimension(640, 480));
                    dialog.pack();
                    dialog.setTitle("Journal Search");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnReceiptToImage.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogReceiptToImg dialog = null;
                try {
                    dialog = new DialogReceiptToImg();
                    dialog.setPreferredSize(new Dimension(640, 480));
                    dialog.pack();
                    dialog.setTitle("Recipt Image form EJ");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        btnPrintConfig.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPrintConfig dialog = null;
                try {
                    dialog = new DialogPrintConfig();
                    dialog.setPreferredSize(new Dimension(920, 660));
                    dialog.pack();
                    dialog.setTitle("Under Construction");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnDeviceStatus.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDeviceStatus dialog = null;
                try {
                    dialog = new DialogDeviceStatus();
                    dialog.setPreferredSize(new Dimension(420, 400));
                    dialog.pack();
                    dialog.setTitle("Device Status Bytes");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        cbxConnectionType.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cbxBoudrate.setEnabled(cbxConnectionType.getSelectedItem().equals("RS232"));
                cbxSerialPort.setEnabled(cbxConnectionType.getSelectedItem().equals("RS232"));
                labSerialPort.setEnabled(cbxConnectionType.getSelectedItem().equals("RS232"));
                labBoudrate.setEnabled(cbxConnectionType.getSelectedItem().equals("RS232"));
                lbHost.setEnabled(cbxConnectionType.getSelectedItem().equals("TCP/IP"));
                edHostAddress.setEnabled(cbxConnectionType.getSelectedItem().equals("TCP/IP"));
            }
        });

        btnInvoice.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cmdReceipt.FiscalReceipt fiscalReceipt = new cmdReceipt.FiscalReceipt();

                //Show Dialog to enter client data
                DialogClientInfo dialog = new DialogClientInfo();
                int result = dialog.doModal();
                if (result == dialog.ID_OK)
                    try {
                        cmdReceipt.InvoiceClientInfo clientInfo = dialog.getClientInfo();
                        if (!fiscalReceipt.isOpen()) {
                            //OPENING OF FISCAL BON
                            String operatorCode = "1";//Operator number
                            String operatorPassword = null; //Operator password
                            String salePoint = "1"; //Number of work place / integer from 1 to 99999 /

                            if (MainFormAB.myFiscalDevice.isConnectedPrinter())
                                operatorPassword = MainFormAB.myFiscalDevice.getConnectedPrinterV1().getDefaultOpPass();
                            else if (MainFormAB.myFiscalDevice.isConnectedECR())
                                operatorPassword = MainFormAB.myFiscalDevice.getConnectedECRV1().getDefaultOpPass();
                            /**
                             *
                             *    UNP Unique sales number format:
                             * - serial number of the fiscal device
                             * - operator code (four digits or Latin characters)
                             * - sequential sales number (seven digits with leading zeros)
                             *   example: DT000600-0001-0001000
                             *
                             *  Note: DATECS FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F/ FMP-10 / FP-550 Only!
                             *
                             *  Before the first sale, the UNP must be set at least once
                             *  if then omitted the parameter device will increment with the number
                             *  of the sale automatically.
                             *
                             */
                            String unp = null;  //Next Document number pad left with trailing zero

                            unp = new cmdInfo().GetDeviceSerialNumber() + "-" +
                                    String.format("%04d", Integer.parseInt(operatorCode)) + "-" + // Pad left with trailing zero
                                    String.format("%07d", 1 + Integer.valueOf(fiscalReceipt.getLastDocNumber()));

                            fiscalReceipt.openInvoice(operatorCode, operatorPassword, salePoint, unp); //For Internal generated use  unp="".
                            //РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА
                            cmdReceipt.FiscalReceipt.FiscalSale testSale = new cmdReceipt.FiscalReceipt.FiscalSale();

                            fiscalReceipt.printSeparatingLine(cmdReceipt.SeparatingLine.dash);
                            fiscalReceipt.printFreeText("Тест продажба без параметри!", true, true, true, cmdReceipt.FiscalReceipt.FreeFiscalTextType.type32dpiA);
                            testSale.add(
                                    "",
                                    "",
                                    "Б", //А, Б, В...
                                    "0.01",
                                    "",
                                    "",
                                    cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.noCorecction,
                                    "");

                            testSale.saleTotal(
                                    "Тотал:",
                                    "",
                                    cmdReceipt.PaidMode.CashPayment.getId(),//cmdReceipt.FiscalReceipt.FiscalSale.PaidMode.fromOrdinal(0).getId(),
                                    ""); //We pays a full amount

                            //If Client Data Info is valid
                            clientInfo.saveClientInfo();

                            fiscalReceipt.closeFiscalReceipt();

                        } else fiscalReceipt.cancel();
                    } catch (Exception ex) {
                        errListModel.add(0, ex.getMessage());
                        ex.printStackTrace();
                    }

            }
        });
        btnLANSettings.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogLANSettings dialog = null;
                try {
                    dialog = new DialogLANSettings();
                    dialog.setPreferredSize(new Dimension(320, 320));
                    dialog.pack();
                    dialog.setTitle("Network Settings");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnNonFiscalTest.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                cmdReceipt.NonFiscalReceipt myTestNonfiscalRec = new cmdReceipt.NonFiscalReceipt();
                try {
                    if (!myTestNonfiscalRec.isOpen()) myTestNonfiscalRec.open();
                    myTestNonfiscalRec.setPrintBarcodeData(true);
                    myTestNonfiscalRec.printBarcode("1234567", cmdReceipt.BarcodeType.EAN8, "", false);
                    myTestNonfiscalRec.printBarcode("123456789191", cmdReceipt.BarcodeType.EAN13, "", false);
                    myTestNonfiscalRec.printBarcode("123456789191", cmdReceipt.BarcodeType.Code128, "", false);
                    myTestNonfiscalRec.setPrintBarcodeData(false);
                    myTestNonfiscalRec.printBarcode("1234567", cmdReceipt.BarcodeType.EAN8, "", false);
                    myTestNonfiscalRec.printBarcode("123456789191", cmdReceipt.BarcodeType.EAN13, "", false);
                    myTestNonfiscalRec.printBarcode("123456789191", cmdReceipt.BarcodeType.Code128, "", false);
                    myTestNonfiscalRec.closeNonFiscalReceipt();

                } catch (Exception ex) {
                    errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }

            }
        });
        btnAdditionalDayInfo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionaDayInfo dialog = null;
                try {
                    dialog = new AdditionaDayInfo();
                    dialog.setPreferredSize(new Dimension(520, 520));
                    dialog.pack();
                    dialog.setTitle("Structured Info");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });
        btnOperatorInformation.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                OperatorInformation dialog = null;
                try {
                    dialog = new OperatorInformation();
                    dialog.setPreferredSize(new Dimension(520, 520));
                    dialog.pack();
                    dialog.setTitle("OBTAIN OPERATOR INFORMATION");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }


            }
        });
        btnPinpadDemo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                DialogPinpadDemoAB dialog = null;
                try {
                    dialog = new DialogPinpadDemoAB();
                    dialog.setPreferredSize(new Dimension(520, 520));
                    dialog.pack();
                    dialog.setTitle("Pinpad demo...");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });
    }


    public static DatecsFiscalDevice getConnectedFD() throws Exception {
        if (myFiscalDevice.isConnectedPrinter() || myFiscalDevice.isConnectedECR()) return myFiscalDevice;
        else throw new Exception("There is no supported Device connected");
    }

    private String[] listPCSerialPort() {
        SerialPort[] ports = SerialPort.getCommPorts();
        String[] RS232_PORTS_LIST = new String[ports.length];
        for (int i = 0; i < ports.length; ++i) {

            RS232_PORTS_LIST[i] = ports[i].getSystemPortName();
        }
        return RS232_PORTS_LIST;
    }


    /**
     * This method attempts to refuse a fiscal or non-fiscal receipt.
     * And if there is a startup payment on the amount and it is not fully paid,
     * it issues a payment message.
     */
    private void closeAll() throws Exception {

        //   cmdReceipt.FiscalReceipt.Storno stornoReceipt = new cmdReceipt.FiscalReceipt.Storno();
        cmdReceipt.FiscalReceipt fiscalReceipt = new cmdReceipt.FiscalReceipt();
        cmdReceipt.FiscalReceipt.NonFiscalReceipt noFiscalReceipt = new cmdReceipt.FiscalReceipt.NonFiscalReceipt();

        if (noFiscalReceipt.isOpen()) {
            noFiscalReceipt.closeNonFiscalReceipt();
            return;
        }

        // if (stornoReceipt.isOpen()) stornoReceipt.cancel();
        //Try to close fiscal receipt of all type: Sale Receipt,Invoice Receipt,Storno of Sale and Storno of Invoice.
        if (fiscalReceipt.isOpen()) tryToCloseFiscalReceipt(fiscalReceipt);
    }

    private void tryToCloseFiscalReceipt(cmdReceipt.FiscalReceipt thisReceipt) throws Exception {

        final Double owedSum = new cmdReceipt.FiscalReceipt.FiscalTransaction().getNotPaid();//owedSum=Amount-Tender
        Double payedSum = new cmdReceipt.FiscalReceipt.FiscalTransaction().getPaid();//Amount that the customer has provided
        int dialogResult = -1;
        //If a TOTAL in the opened receipt has not been set, it will be canceled
        if (payedSum == 0.0) {
            dialogResult = JOptionPane.showConfirmDialog(paneMain, "No payment started on this receipt,\n\n" +
                    "Yes-Pay the whole amount,No-Cancel receipt", "Close receipt?", JOptionPane.YES_NO_OPTION);
            if (dialogResult == 0) {
                payFull();
                closeFiscalRec(thisReceipt);
            }
            if (dialogResult == 1)
                thisReceipt.cancel();
            return;
        }

        //If a TOTAL is set with a partial payment, there is a Amount and Tender is positive.
        //Offer payment of the amount and completion of the sale.
        if (owedSum > 0.0) {
            String sQuestion = String.format("Payment has already started.\n\r" +
                    "Do you want to pay the owed sum: %2.2f -and close it?", owedSum / 100.0);
            dialogResult = JOptionPane.showConfirmDialog(paneMain, sQuestion, "Cancel receipt", JOptionPane.YES_NO_OPTION);
            if (dialogResult == 0) {
                payFull();
                closeFiscalRec(thisReceipt);
            } else {
                thisReceipt.cancel();
            }
        } else {
            //If a TOTAL is set with a full payment, there is a Amount-Tender=0.
            //All is OK, completion of the sale!
            closeFiscalRec(thisReceipt);
        }
    }

    private void closeFiscalRec(cmdReceipt.FiscalReceipt thisReceipt) throws Exception {
        //Try to enter new client Invoice Info
        if (thisReceipt.isInvoice())
            tryToEnterClientInfo();
        thisReceipt.closeFiscalReceipt();
    }

    private void tryToEnterClientInfo() throws Exception {
        //Show Dialog to enter client data
        DialogClientInfo dialog = new DialogClientInfo();
        int result = dialog.doModal();
        if (result == dialog.ID_OK) dialog.getClientInfo().saveClientInfo();

    }

    private void payFull() throws Exception {
        new cmdReceipt.FiscalReceipt.FiscalSale().saleTotal(
                "Тотал:",
                "",
                cmdReceipt.FiscalReceipt.FiscalSale.PaidMode.fromOrdinal(0).getId(),
                ""); //We pays a full amount
    }

    private void buttonsEnable(boolean connected) throws Exception {
        btnHeaderFooter.setEnabled(connected);
        btnCashInCashOut.setEnabled(connected);
        btnVATConfig.setEnabled(connected);
        btnItems.setEnabled(connected);
        btnJournalSearch.setEnabled(connected);
        btnPrintConfig.setEnabled(connected);
        btnCommand.setEnabled(connected);
        btnDeviceStatus.setEnabled(connected);
        btnDailyXReport.setEnabled(connected);
        btnDailyZReport.setEnabled(connected);
        btnSaleTest.setEnabled(connected);
        btnStorno.setEnabled(connected);
        btnCloseAll.setEnabled(connected);
        btnSetDateTime.setEnabled(connected);
        btnInvoice.setEnabled(connected);
        btnLANSettings.setEnabled(connected);
        btnNonFiscalTest.setEnabled(connected);
        btnAdditionalDayInfo.setEnabled(connected);
        btnOperatorInformation.setEnabled(connected);
        btnStructuredInfo.setEnabled(connected);
        btnReceiptToImage.setEnabled(connected);
        btnPinpadDemo.setEnabled(connected);
    }


}
