import javax.swing.*;
import java.awt.event.*;

public class RegExTester extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField edRegEx;
    private JTextField textField2;
    private JButton btnSplit;
    private JTextField edStr;
    private JButton btnMatch;

    public RegExTester() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonOK);

        buttonOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onOK();
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        btnSplit.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                textField2.setText(splitTest(edStr.getText(), edRegEx.getText()));

            }
        });
        btnMatch.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (edStr.getText().matches(edRegEx.getText())) textField2.setText("OK");
                else textField2.setText("NO");
            }
        });
    }

    private String splitTest(String s, String regEx) {
        String p[] = s.split(regEx);
        String res = "Res: ";
        for (String S : p) res += S.replace(" ", "");
        return res;
    }

    private void onOK() {
        // add your code here
        dispose();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        RegExTester dialog = new RegExTester();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }
}
