package connectivity;

import com.datecs.util.LoggerEx;
import java.lang.reflect.Constructor;
 
 

public class PrinterConnectionFactory {

    private static LoggerEx logger = LoggerEx.getLogger(PrinterConnectionFactory.class);

    private PrinterConnectionFactory()
    {
    }

    public static PrinterConnection createInstance(String params)
            throws Exception
    {
        PrinterConnection result = null;
        switch (params) {
        case "RS232_DEVICE_BUS":
            result = new SerialPrinterConnector();
            break;

        case  "ETHERNET_DEVICE_BUS":
            result = new SocketConnector();
            break;

            case  "BLUETOOTH_DEVICE_BUS":
             result =  null; //BtSocketConnector(params.vendorModelName);
            break;            
            
        case "PROPRIETARY_DEVICE_BUS":
            Class portClass = Class.forName(params);
            Class[] parameters = new Class[0];
            Constructor ctor = portClass.getConstructor(parameters);
            result = (PrinterConnection) ctor.newInstance(parameters);
            break;

        default:
            throw new Exception("Invalid deviceBus value");
        }
        return  result;
    }




}
