import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdConfig;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdEJournal;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;

import javax.swing.*;
import java.awt.event.*;
import java.util.ArrayList;

public class DialogEJ extends JFrame {
    private JPanel contentPane;
    private JButton btnReadEJ;
    private JButton buttonCancel;
    private JComboBox cbxDocType;
    private JTextField edFromDate;
    private JTextField edFromTime;
    private JTextField edToDate;
    private JTextField edToTime;
    private JCheckBox chbxByDocNumber;
    private JTextField edFromNum;
    private JTextField edToNum;
    private JButton btnPrintEJ;
    private JLabel lbDocType;
    private JLabel lbFromDate;
    private JLabel lbToDate;
    private JLabel lbFromNum;
    private JLabel lbToNum;
    private JTextArea ejTextMonitor;
    private JProgressBar progBar;
    private JScrollPane edEJMonitor;
    private cmdEJournal myEJournal = new cmdEJournal();
    private cmdInfo myDeviceInfo = new cmdInfo();
    private cmdConfig myConfig = new cmdConfig();


    public DialogEJ() {
        setContentPane(contentPane);
        //setModal(true);
        getRootPane().setDefaultButton(btnReadEJ);
        // Init EJ Search parameters
        try {
            edFromDate.setText(myDeviceInfo.GetActiveTaxRatesDate()); // Indicative start date for the reporting period
            edFromTime.setText("00:00:00");
            edToDate.setText(myDeviceInfo.GetLastFiscalRecordDate());
            edToTime.setText("23:59:59");
            edFromNum.setText("1");
            edToNum.setText(myDeviceInfo.GetGlobalNumberOfReceipts());
        } catch (Exception e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

        btnReadEJ.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ReadEJ();
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        chbxByDocNumber.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean byDate = !chbxByDocNumber.isSelected();
                lbFromDate.setEnabled(byDate);
                edFromDate.setEnabled(byDate);
                edFromTime.setEnabled(byDate);
                lbToDate.setEnabled(byDate);
                edToDate.setEnabled(byDate);
                edToTime.setEnabled(byDate);
                lbFromNum.setEnabled(!byDate);
                edFromNum.setEnabled(!byDate);
                lbToNum.setEnabled(!byDate);
                edToNum.setEnabled(!byDate);
            }
        });

        cbxDocType.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    switch (cmdEJournal.EjDocumentType.fromOrdinal(cbxDocType.getSelectedIndex())) {
                        case DailyZ:
                        case DailyX:
                            edToNum.setText(myDeviceInfo.GetNumberOfLastZreport());
                            break;
                        case Invoice:
                            ArrayList<String> res = myConfig.GetInvoiceInterval();
                            edFromNum.setText(res.get(0));
                            edToNum.setText(res.get(1));
                            break;
                        default:
                            edFromNum.setText("1");
                            edToNum.setText(myDeviceInfo.GetGlobalNumberOfReceipts());
                            break;
                    }
                } catch (Exception ex) {
                    MainForm.errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        edFromNum.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edFromNum);
            }
        });

        edToNum.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edToNum);
            }
        });
        btnPrintEJ.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                progBar.setValue(0);
                progBar.setMaximum(100);
                progBar.setStringPainted(false);
                ejTextMonitor.setText("");
                final boolean[] runProgressBar = {true};
                //Fake progBar
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        while (runProgressBar[0]) {
                            SwingUtilities.invokeLater(new Runnable() {
                                public void run() {
                                    progBar.setValue(progBar.getValue() + 1);
                                    if (progBar.getValue() == progBar.getMaximum())
                                        progBar.setValue(progBar.getMinimum());
                                }
                            });
                            try {
                                Thread.sleep(100);
                            } catch (InterruptedException e) {
                            }
                        }
                    }
                }).start();
                //Read EJ
                new Thread(new Runnable() {
                    final String[] readDocsList = {""};

                    @Override
                    public void run() {
                        // do the thing that takes a long time
                        try {
                            int[] receivedCnt = new int[1];
                            if (chbxByDocNumber.isSelected()) { //Search EJ by Number of Documents
                                receivedCnt[0] = myEJournal.print_Documents_ByNumbersRange(
                                        cmdEJournal.EjDocumentType.fromOrdinal(cbxDocType.getSelectedIndex()),// Type from enum
                                        setVarsByNumbers());
                            } else { //Search EJ by Data Time of Documents
                                cmdEJournal.EJ_ParamRange docRange = myEJournal.set_SearchDocuments_ByDateRange(
                                        cmdEJournal.EjDocumentType.fromOrdinal(cbxDocType.getSelectedIndex()),// Type from enum
                                        setVarsByDate());
                                receivedCnt[0] = myEJournal.print_Documents_ByNumbersRange(
                                        cmdEJournal.EjDocumentType.fromOrdinal(cbxDocType.getSelectedIndex()),// Type from enum
                                        docRange);
                            }
                            SwingUtilities.invokeLater(new Runnable() {
                                public void run() {
                                    runProgressBar[0] = false;
                                    progBar.setValue(progBar.getMaximum());
                                    ejTextMonitor.setText(readDocsList[0]);
                                }
                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                            MainForm.errListModel.add(0, e.getMessage());
                        }
                    }
                }).start();
            }
        });
    }

    private void checkInput(JTextField tf) {
        try {
            long number = Long.parseLong(tf.getText());
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(rootPane, "Only Numbers Allowed");
            tf.setSelectionStart(tf.getText().length() - 1);
        }

    }

    private void ReadEJ() {
        progBar.setValue(0);
        progBar.setIndeterminate(true);
        progBar.setStringPainted(false);
        ejTextMonitor.setText("");

        //Read EJ
        new Thread(new Runnable() {
            final String[] readDocsList = {""};
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    int[] receivedCnt = new int[1];
                    if (chbxByDocNumber.isSelected()) { //Search EJ by Number of Documents
                        receivedCnt[0] = myEJournal.get_Documents_ByNumbersRange(
                                cmdEJournal.EjDocumentType.fromOrdinal(cbxDocType.getSelectedIndex()), // Type from enum
                                setVarsByNumbers(),
                                readDocsList);
                    } else { //Search EJ by Data Time of Documents
                        cmdEJournal.EJ_ParamRange docRange = myEJournal.set_SearchDocuments_ByDateRange(
                                cmdEJournal.EjDocumentType.fromOrdinal(cbxDocType.getSelectedIndex()),// Type from enum
                                setVarsByDate());
                        receivedCnt[0] = myEJournal.get_Documents_ByNumbersRange(
                                cmdEJournal.EjDocumentType.fromOrdinal(cbxDocType.getSelectedIndex()),// Type from enum
                                docRange,
                                readDocsList);
                    }
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            progBar.setIndeterminate(false);
                            ejTextMonitor.setText(readDocsList[0]);
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                    MainForm.errListModel.add(0, e.getMessage());
                }
            }
        }).start();
    }

    /**
     * @return Input parameters for search process
     */
    private cmdEJournal.EJ_ParamRange setVarsByDate() {
        return new cmdEJournal.EJ_ParamRange(
                0, 0,
                0, 0,
                edFromDate.getText() + " " + edFromTime.getText(),
                edToDate.getText() + " " + edToTime.getText());
    }

    /**
     * @return Input parameters for search process
     */
    private cmdEJournal.EJ_ParamRange setVarsByNumbers() {
        cmdEJournal.EJ_ParamRange resParam = new cmdEJournal.EJ_ParamRange();
        resParam.setDocNumStart(Integer.valueOf(edFromNum.getText().trim()));
        resParam.setDocNumEnd(Integer.valueOf(edToNum.getText().trim()));
        return resParam;
    }

    private void onOK() {
        // add your code here
        dispose();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogEJ dialog = new DialogEJ();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
