import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdConfig;

import javax.swing.*;
import java.awt.event.*;

public class DialogEditOperator extends JDialog {
    private String operPass = null;
    private int operIndexToedit = -1;
    private String operName = null;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField edOperName;
    private JTextField edOldPassword;
    private JTextField edNewPassword;

    public DialogEditOperator(int selectedRow, String operName, String operPass) {
        this.operIndexToedit = selectedRow+1;
        this.operName = operName;
        this.operPass = operPass;
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonOK);
        edOperName.setText(operName);
        edOldPassword.setText(operPass);
        edNewPassword.setText(operPass);

        buttonOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                // add your code here
                try {
                    if ((edOperName.getText().length() > 0) && (!edOperName.getText().equals(operName)))
                    new cmdConfig().SetOperName(operIndexToedit, edOldPassword.getText().trim(), edOperName.getText().trim());

                    if ((edNewPassword.getText().length() > 0) && (!edOldPassword.getText().equals(edNewPassword.getText())))
                        new cmdConfig().SetOperPasw(operIndexToedit, edOldPassword.getText().trim(), edNewPassword.getText().trim());

                    dispose();
                } catch (Exception e1) {
                    JOptionPane.showMessageDialog(null, e1.getMessage(), "Device Error...", JOptionPane.ERROR_MESSAGE);
                    e1.printStackTrace();
                }
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {

        System.exit(0);
    }
}
