import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdConfig;

import javax.imageio.ImageIO;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import static java.awt.image.BufferedImage.TYPE_BYTE_BINARY;

public class DialogPrintConfig extends JDialog {

    private JPanel contentPane;
    private JButton btnSaveAll;
    private JButton buttonCancel;
    private JComboBox cbxBarcodeHeight;
    private JCheckBox chkFromatAsInvoice;
    private JCheckBox chkAutoPaperCutting;
    private JCheckBox chkPrintSumInEUR;
    private JCheckBox chkOpenDrawer;
    private JCheckBox chkPrintDepartmantName;
    private JCheckBox chkVATPrint;
    private JComboBox cbxPrintContrast;
    private JComboBox cbxPrinterFont;
    private JComboBox cbxLogoHeight;
    private JCheckBox chkGraphicLogoPrinting;
    private JTextField edExRate;
    private JButton btnOpenLogo;
    private JButton btnReadDeviceLogo;
    private JLabel imageLabel;
    private JButton btnWriteLogoToDevice;
    private JLabel labImageInfo;
    private JProgressBar prgBarWriteLogo;
    private JCheckBox chkUseDithering;
    private JTextField edInvoiceIntervalStart;
    private JButton btnSetInterval;
    private JTextField edInvoiceIntervalEnd;
    private JLabel labInvIndex;
    private int MAX_LOGO_H;
    private int MAX_LOGO_W;
    private final cmdConfig myPrintConfig = new cmdConfig();
    private BufferedImage originalImage;
    private BufferedImage convertedImage;

    public DialogPrintConfig() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonCancel);

        //Init Barcode Height Spinner - 3 mm to 30 mm
        String[] items = new String[28];//
        for (int i = 0; i < 28; i++) items[i] = String.valueOf(i + 3);
        cbxBarcodeHeight.setModel(new DefaultComboBoxModel(items));


        if(myPrintConfig.isConnectedECR())
        { MAX_LOGO_W=myPrintConfig.getConnectedECRV1().getMaxLogoWidthPixel();
            MAX_LOGO_H=myPrintConfig.getConnectedECRV1().getMaxLogoHeightPixel();}
        if(myPrintConfig.isConnectedPrinter())
        { MAX_LOGO_W=myPrintConfig.getConnectedPrinterV1().getMaxLogoWidthPixel();
            MAX_LOGO_H=myPrintConfig.getConnectedPrinterV1().getMaxLogoHeightPixel();}
        //Init Logo Height Spinner
        items = new String[MAX_LOGO_H];
        for (int i = 0; i < MAX_LOGO_H; i++) items[i] = String.valueOf(i + 1);
        cbxLogoHeight.setModel(new DefaultComboBoxModel(items));

        chkFromatAsInvoice.setEnabled(!MainFormAB.myFiscalDevice.isConnectedECR());//Bug Fix Hus
        cbxLogoHeight.setEnabled(!MainFormAB.myFiscalDevice.isConnectedECR());//Bug Fix Hus
        chkOpenDrawer.setEnabled(!MainFormAB.myFiscalDevice.isConnectedECR());//Bug Fix Hus

        //Init Check boxes
        try {
            cbxPrintContrast.setSelectedIndex(myPrintConfig.GetPrnQuality());
            if (MainFormAB.myFiscalDevice.isFontSupported()) {
                cbxPrinterFont.setEnabled(true);
                cbxPrinterFont.setSelectedIndex(myPrintConfig.GetFontType());
            } else cbxPrinterFont.setEnabled(false);

            if (MainFormAB.myFiscalDevice.isConnectedECR()) //   not implemented
            {
                cbxBarcodeHeight.setSelectedIndex(0);
                cbxLogoHeight.setSelectedIndex(0);
            } else {
                cbxBarcodeHeight.setSelectedIndex(myPrintConfig.GetBarcodeHeight() - 3);
                cbxLogoHeight.setSelectedIndex(myPrintConfig.GetLogoHeight() - 1); //1-96 to index 0-95
            }
            chkFromatAsInvoice.setSelected(myPrintConfig.GetReceiptFormat());
            if (MainFormAB.myFiscalDevice.isPaperCuttingDevice()) {
                chkAutoPaperCutting.setEnabled(true);
                chkAutoPaperCutting.setSelected(myPrintConfig.GetAutoPaperCutting());
            } else chkAutoPaperCutting.setEnabled(false);

            chkGraphicLogoPrinting.setSelected(myPrintConfig.GetLogoPrint());
            edExRate.setText(myPrintConfig.GetExchangeRate());
            chkPrintSumInEUR.setSelected(myPrintConfig.GetForeignPrint());
            chkOpenDrawer.setSelected(myPrintConfig.GetDrawerOpening());
            chkPrintDepartmantName.setSelected(myPrintConfig.GetDepartmentPrint());
            chkVATPrint.setSelected(myPrintConfig.GetPrintVAT());


            //Init Ivoice Range
            ArrayList<String> intervalInfo = new cmdConfig().GetInvoiceInterval();
            edInvoiceIntervalStart.setText(intervalInfo.get(0));
            edInvoiceIntervalEnd.setText(intervalInfo.get(1));
            labInvIndex.setText("Next Invoice number:" + intervalInfo.get(2));


        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }


        btnSaveAll.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                SaveAllSettings();
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        contentPane.addComponentListener(new ComponentAdapter() {
        });


        contentPane.addMouseMotionListener(new MouseMotionAdapter() {
            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                btnSaveAll.setEnabled(true);
            }
        });

        btnOpenLogo.addActionListener(new ActionListener() {
            private File initPath = FileSystemView.getFileSystemView().getHomeDirectory();

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser(initPath);
                jfc.setDialogTitle("Select an Logo File...");
                jfc.setAcceptAllFileFilterUsed(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Logo File (BMP,JPG,PNG)", "BMP", "JPG", "PNG");
                jfc.addChoosableFileFilter(filter);

                int returnValue = jfc.showOpenDialog(null);
                if (returnValue == JFileChooser.APPROVE_OPTION) {

                    OpenLogoFromFile(jfc.getSelectedFile().getPath());
                    initPath = new File(jfc.getSelectedFile().getPath());
                }
            }

            private void OpenLogoFromFile(String path) {
                File imageFile = new File(path);
                try {
                    originalImage = cropImage(ImageIO.read(imageFile)); //To keep original imageAsIcon
                    convertedImage = cropImage(ImageIO.read(imageFile)); //Use to converted images Buffer

                    //No need to convert image in BW
//                    BufferedImage bwImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), BufferedImage.TYPE_BYTE_BINARY);
//                    bwImage.createGraphics().drawImage(originalImage, 0, 0, null);

                } catch (IOException e) {
                    MainFormAB.errListModel.add(0, e.getMessage());
                    e.printStackTrace();
                }
                //   makeGrey(originalImage);
                //   makeGrey(convertedImage);
                labImageInfo.setText(path);//+ " H:" + convertedImage.getHeight() + " W:" + convertedImage.getWidth());
                if (chkUseDithering.isSelected()) {
                    floydSteinbergDithering(convertedImage);
                    showImage(convertedImage);
                } else {
                    showImage(originalImage);
                }

            }

        });


        btnWriteLogoToDevice.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (chkUseDithering.isSelected()) {
                        if (convertedImage != null) writeLogoToDevice(convertedImage);
                    } else if (originalImage != null) writeLogoToDevice(originalImage);
                } catch (Exception ex) {
                    MainFormAB.errListModel.add(0, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });


        btnReadDeviceLogo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                readLogoThread();
            }
        });
        chkUseDithering.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                if (chkUseDithering.isSelected()) {
                    floydSteinbergDithering(convertedImage);
                    showImage(convertedImage);
                } else
                    showImage(originalImage);
            }
        });

        btnSetInterval.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cmdConfig myConfig = new cmdConfig();
                try {
                    ArrayList<String> invoiceInterval = myConfig.GetInvoiceInterval();
                    //If the current invoice counter have reached the end of the interval.
                    myConfig.SetInvoiceInterval(edInvoiceIntervalStart.getText(), edInvoiceIntervalEnd.getText());
                } catch (Exception ex) {
                    ex.printStackTrace();
                    MainFormAB.errListModel.add(0, ex.getMessage());
                }
            }
        });
    }

    /**
     * @param i
     * @return
     */
    private BufferedImage cropImage(BufferedImage i) {
        BufferedImage cropedImg = i;
        if ((i.getWidth() > MAX_LOGO_W) && (i.getHeight()) > MAX_LOGO_H)
            return i.getSubimage(0, 0, MAX_LOGO_W, MAX_LOGO_H);
        if (i.getWidth() > MAX_LOGO_W) cropedImg = i.getSubimage(0, 0, MAX_LOGO_W, i.getHeight());
        if (i.getHeight() > MAX_LOGO_H) cropedImg = i.getSubimage(0, 0, i.getWidth(), MAX_LOGO_H);
        return cropedImg;
    }

    /**
     * @param img
     */
    private void showImage(BufferedImage img) {
        if (img == null) return;
        ImageIcon imageAsIcon = new ImageIcon(img);
        imageLabel.setIcon(imageAsIcon);
        imageLabel.setSize(img.getWidth(), img.getHeight());
        imageLabel.repaint();
    }


    private void SaveAllSettings() {
        try {
            myPrintConfig.SetPrnQuality(cbxPrintContrast.getSelectedIndex());

            if (MainFormAB.myFiscalDevice.isFontSupported())
                myPrintConfig.SetFontType(cbxPrinterFont.getSelectedIndex());

            myPrintConfig.SetBarcodeHeight((Integer.valueOf((String) cbxBarcodeHeight.getSelectedItem())));
            myPrintConfig.SetLogoPrint(chkGraphicLogoPrinting.isSelected(), String.valueOf(cbxLogoHeight.getSelectedItem()));
            if (!MainFormAB.myFiscalDevice.isConnectedECR()) //Bug Fix Hus
            {
                myPrintConfig.SetReceiptFormat(chkFromatAsInvoice.isSelected());
                myPrintConfig.SetLogoPrint(chkGraphicLogoPrinting.isSelected(), String.valueOf(cbxLogoHeight.getSelectedIndex()+1));
                myPrintConfig.SetDrawerOpening(chkOpenDrawer.isSelected());
            }
            if (MainFormAB.myFiscalDevice.isPaperCuttingDevice())
                myPrintConfig.GetAutoPaperCutting(chkAutoPaperCutting.isSelected());

            myPrintConfig.SetForeignPrint(chkPrintSumInEUR.isSelected(), edExRate.getText());
            myPrintConfig.SetDepartmentPrint(chkPrintDepartmantName.isSelected());
            myPrintConfig.SetPrintVAT(chkVATPrint.isSelected());

        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }


    static class C3 {
        int r, g, b;

        public C3(int c) {
            Color color = new Color(c);
            r = color.getRed();
            g = color.getGreen();
            b = color.getBlue();
        }

        public C3(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public C3 add(C3 o) {
            return new C3(r + o.r, g + o.g, b + o.b);
        }

        public int clamp(int c) {
            return Math.max(0, Math.min(255, c));
        }

        public int diff(C3 o) {
            int Rdiff = o.r - r;
            int Gdiff = o.g - g;
            int Bdiff = o.b - b;
            int distanceSquared = Rdiff * Rdiff + Gdiff * Gdiff + Bdiff * Bdiff;
            return distanceSquared;
        }

        public C3 mul(double d) {
            return new C3((int) (d * r), (int) (d * g), (int) (d * b));
        }

        public C3 sub(C3 o) {
            return new C3(r - o.r, g - o.g, b - o.b);
        }

        public Color toColor() {
            return new Color(clamp(r), clamp(g), clamp(b));
        }

        public int toRGB() {
            return toColor().getRGB();
        }
    }

    private static C3 findClosestPaletteColor(C3 c, C3[] palette) {
        C3 closest = palette[0];

        for (C3 n : palette) {
            if (n.diff(c) < closest.diff(c)) {
                closest = n;
            }
        }

        return closest;
    }


    /**
     * Dither is method to reduce color space of an image by adding an artificial noise.
     * The key idea is that the amount of light in an area should remain about the same.
     *
     * @param img
     */
    private void floydSteinbergDithering(BufferedImage img) {
        if (img == null) return;
        prgBarWriteLogo.setValue(0);
        prgBarWriteLogo.setMaximum(img.getWidth() - 1);
        C3[] palette = new C3[]{
                new C3(0, 0, 0), // black
//                new C3(0, 0, 255), // green
//                new C3(0, 255, 0), // blue
//                new C3(0, 255, 255), // cyan
//                new C3(255, 0, 0), // red
//                new C3(255, 0, 255), // purple
//                new C3(255, 255, 0), // yellow
                new C3(255, 255, 255)  // white
        };


        int w = img.getWidth();
        int h = img.getHeight();

        C3[][] d = new C3[h][w];
        new Thread(new Runnable() {
            @Override
            public void run() {
                for (int y = 0; y < h; y++) {
                    for (int x = 0; x < w; x++) {
                        d[y][x] = new C3(img.getRGB(x, y));
                    }
                }

                for (int y = 0; y < img.getHeight(); y++) {
                    for (int x = 0; x < img.getWidth(); x++) {

                        C3 oldColor = d[y][x];
                        C3 newColor = findClosestPaletteColor(oldColor, palette);
                        img.setRGB(x, y, newColor.toColor().getRGB());

                        C3 err = oldColor.sub(newColor);

                        if (x + 1 < w) {
                            d[y][x + 1] = d[y][x + 1].add(err.mul(7. / 16));
                        }

                        if (x - 1 >= 0 && y + 1 < h) {
                            d[y + 1][x - 1] = d[y + 1][x - 1].add(err.mul(3. / 16));
                        }

                        if (y + 1 < h) {
                            d[y + 1][x] = d[y + 1][x].add(err.mul(5. / 16));
                        }

                        if (x + 1 < w && y + 1 < h) {
                            d[y + 1][x + 1] = d[y + 1][x + 1].add(err.mul(1. / 16));
                        }

                        int finalX = x;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                prgBarWriteLogo.setValue(finalX);
                            }
                        });

                    }

                }
            }
        }).start();
    }

    /**
     * Read logo from fiscal device
     */
    private void readLogoThread() {
        prgBarWriteLogo.setValue(0);
        prgBarWriteLogo.setMaximum(MAX_LOGO_H - 1);
        new Thread(new Runnable() {
            String logo = "";
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    for (int i = 0; i < MAX_LOGO_H; i++) {
                        logo += myPrintConfig.Logo_ReadRow(i);//Read all 348 pixels. 96/2 = 48*8; 48*8=348 pixel
                        int finalI = i;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                prgBarWriteLogo.setValue(finalI);
                            }
                        });
                    }
                    showImage(logoToBitmap(logo));
                } catch (Exception e) {
                    MainFormAB.errListModel.add(0, e.getMessage());
                    e.printStackTrace();
                }


            }

        }).start();

    }

    private BufferedImage logoToBitmap(String logo) {
        BufferedImage bitmap = new BufferedImage(MAX_LOGO_W, MAX_LOGO_H, TYPE_BYTE_BINARY);
        try {
            byte[] decoded =hexStringToByteArray(logo); // Obsolete: DatatypeConverter.parseHexBinary(logo);
            for (int y = 0; y < MAX_LOGO_H; y++) {
                for (int x = 0; x < MAX_LOGO_W / 8; x++) {
                    int index = x * 8;
                    boolean[] bwPixel = byteToBoolArr(decoded[y * MAX_LOGO_W / 8 + x]);
                    bitmap.setRGB(index, y, bwPixel[0] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 1, y, bwPixel[1] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 2, y, bwPixel[2] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 3, y, bwPixel[3] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 4, y, bwPixel[4] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 5, y, bwPixel[5] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 6, y, bwPixel[6] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 7, y, bwPixel[7] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                }
            }

        } catch (Exception e) {

            e.printStackTrace();

        }
        return bitmap;
    }
    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4)
                    + Character.digit(s.charAt(i+1), 16));
        }
        return data;
    }
    public static boolean[] byteToBoolArr(byte b) {
        boolean boolArr[] = new boolean[8];
        for (int i = 0; i < 8; i++) boolArr[i] = (b & (byte) (128 / Math.pow(2, i))) != 0;
        return boolArr;
    }

    /**
     * Create 1bpp bitmap and write pixels(HEX represented) to device
     *
     * @param bmpOriginal - BW Bitmap
     * @return
     */
    private void writeLogoToDevice(BufferedImage bmpOriginal) {
        prgBarWriteLogo.setMaximum(bmpOriginal.getHeight() - 1);
        prgBarWriteLogo.setValue(0);
        new Thread(new Runnable() {
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    for (int y = 0; y < bmpOriginal.getHeight(); y++) {
                        String ROW_DATA = "";

                        for (int j = 0; j < bmpOriginal.getWidth() / 8; j++) {
                            int tmpB = 0;
                            int index = j * 8;
                            if (bmpOriginal.getRGB(index, y) <= Color.GRAY.getRGB()) tmpB = (tmpB | 128);
                            if (bmpOriginal.getRGB(index + 1, y) <= Color.GRAY.getRGB()) tmpB = (tmpB | 64);
                            if (bmpOriginal.getRGB(index + 2, y) <= Color.GRAY.getRGB()) tmpB = (tmpB | 32);
                            if (bmpOriginal.getRGB(index + 3, y) <= Color.GRAY.getRGB()) tmpB = (tmpB | 16);
                            if (bmpOriginal.getRGB(index + 4, y) <= Color.GRAY.getRGB()) tmpB = (tmpB | 8);
                            if (bmpOriginal.getRGB(index + 5, y) <= Color.GRAY.getRGB()) tmpB = (tmpB | 4);
                            if (bmpOriginal.getRGB(index + 6, y) <= Color.GRAY.getRGB()) tmpB = (tmpB | 2);
                            if (bmpOriginal.getRGB(index + 7, y) <= Color.GRAY.getRGB()) tmpB = (tmpB | 1);
                            ROW_DATA += String.format("%02X", tmpB);
                        }
                        myPrintConfig.Logo_WriteRow(y, ROW_DATA);

                        int finalY = y;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                prgBarWriteLogo.setValue(finalY);
                            }
                        });
                    }
                    //      myPrintConfig.Logo_SaveToDevice();
                } catch (Exception e) {
                    MainFormAB.errListModel.add(0, e.getMessage());
                    e.printStackTrace();
                }
            }
        }).start();
    }


    public static void main(String[] args) {
        DialogPrintConfig dialog = new DialogPrintConfig();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
