package connectivity;
import com.datecs.fiscalprinter.SDK.FiscalException;


import com.datecs.fiscalprinter.SDK.model.BGR.FDModelDetectorV1;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.util.LoggerEx;
import com.datecs.util.Translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.StringTokenizer;

import static com.datecs.fiscalprinter.SDK.FiscalException.FPTR_CC_OTHER;


/**
 * @author DATECS Software Dep.
 */
public class SocketConnector implements PrinterConnection {

    private int timeout = 0;
    private final Socket socket;
    private InputStream in;
    private OutputStream out;

    public static String getModelName() {
        return modelName += " :LAN";
    }

    private String portName = "";
    private static DatecsFiscalDevice connectedFD = new DatecsFiscalDevice(FPTR_CC_OTHER);
    private static String modelName = "";

    public SocketConnector() {
        socket = new Socket();
    }

    void waitConnected(int timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        for (; ; ) {
            Thread.sleep(0, 001);
            long currentTime = System.currentTimeMillis();
            if (socket.isConnected()) {
                break;
            }
            if ((currentTime - startTime) > timeout) {
                noConnectionError();
            }
        }
    }

    @Override
    public void close() throws Exception {
        Thread.sleep(100);
        socket.shutdownInput();
        socket.shutdownOutput();
        socket.close();
    }

    public int readByte() throws Exception {
        int b = doReadByte();
        return b;
    }

    public int doReadByte() throws Exception {
        int result;
        long startTime = System.currentTimeMillis();
        for (; ; ) {
            Thread.sleep(0, 001);
            long currentTime = System.currentTimeMillis();
            if (in.available() > 0) {
                result = in.read();
                if (result >= 0) {
                    return result;
                }
            }
            if ((currentTime - startTime) > timeout) {
                noConnectionError();
            }
        }
    }

    private void noConnectionError() throws Exception {
        throw new IOException(Translate.getString(Translate.NoConnection));
    }

    public byte[] readBytes(int len) throws Exception {
        byte[] data = new byte[len];
        int offset = 0;
        while (len > 0) {
            int count = in.read(data, offset, len);
            if (count == -1) {
                break;
            }
            len -= count;
            offset += count;
        }
        return data;
    }

    /**
     * @throws Exception
     */
    public void connect() throws Exception {
    }

    public void write(byte[] b) throws Exception {
    }

    public void write(int b) throws Exception {

    }

    public void setBaudRate(int baudRate) throws Exception {

    }

    public void setTimeout(int timeout) throws Exception {
        this.timeout = timeout;
    }

    public void setPortName(String portName) throws Exception {
        this.portName = portName;
    }

    public InputStream getInputStream() throws Exception {
        return socket.getInputStream();
    }

    public OutputStream getOutputStream() throws Exception {
        return socket.getOutputStream();
    }

    public Object getSyncObject() throws Exception {
        return socket;
    }

    public boolean isSearchByBaudRateEnabled() {
        return false;
    }

    @Override
    public DatecsFiscalDevice open(String portName) throws Exception {

//        if (!socket.isConnected()) {
        //Protocol V1 -Identifies all 6 byte status devices !!!
          try {
            socket.setSoTimeout(timeout);
            StringTokenizer tokenizer = new StringTokenizer(portName, ":");
            String host = tokenizer.nextToken();
            int port = Integer.parseInt(tokenizer.nextToken());

            while (true) {
                if (socket.isConnected()) break;
                socket.connect(new InetSocketAddress(host, port));
                Thread.sleep(1000);
            }
            in = socket.getInputStream();
            out = socket.getOutputStream();
            //Autodetect model
            FDModelDetectorV1 datecsBGRmodelV1 = new FDModelDetectorV1(in, out);
            modelName = datecsBGRmodelV1.detectConnectedModel();
            return  PrinterConnection.createPrinter(modelName,datecsBGRmodelV1.getTransportProtocol());

        } catch (SocketException e) {
            e.printStackTrace();
            throw new Exception("SocketException :" + e.getMessage());
        } catch (IOException e) {
            //   Thread.sleep(1000);
            e.printStackTrace();
            throw new Exception("IOException :" + e.getMessage());
        } catch (FiscalException e) {
            e.printStackTrace();
            throw new Exception("FiscalException :" + e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Exception :" + e.getMessage());
        }

    }

    @Override
    public String getPortName() throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }


}
