import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdConfig;
import tools.RowHeaderRenderer;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import java.awt.event.*;

public class DialogHeaderFooter extends JDialog {
    private final JTable table;
    private DefaultTableModel tableModel = null;
    private JPanel contentPane;
    private JButton btnSetFooter;
    private JButton buttonCancel;
    private JScrollPane scrollPanel;
    private JButton btnSetHeader;
    private final cmdConfig.HeaderFooter headerFooter = new cmdConfig.HeaderFooter();

    public DialogHeaderFooter() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnSetFooter);

        btnSetHeader.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (table.isEditing())
                    table.getCellEditor().stopCellEditing();
                tableModel.fireTableDataChanged();
                try {
                    int headerLinesCnt = headerFooter.getHeaderLinesCount();
                    for (int i = 0; i < headerLinesCnt; i++) {
                        headerFooter.setHeaderLines(i, String.valueOf(tableModel.getValueAt(i, 0)));
                    }
                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
                MainForm.errListModel.add(0, "Header Lines is saved...");
            }
        });

        btnSetFooter.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (table.isEditing())
                    table.getCellEditor().stopCellEditing();
                tableModel.fireTableDataChanged();
                try {
                    int footerLinesCount = headerFooter.getFooterLinesCount();
                    for (int i = 0; i < footerLinesCount; i++) {
                        headerFooter.setFooterLines(i, String.valueOf(tableModel.getValueAt(i, 1)));
                    }
                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
                MainForm.errListModel.add(0, "Footer Lines is saved...");
            }
        });


        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);


        //Init Table
        ListModel lm = new AbstractListModel() {
            String headers[] = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};

            public int getSize() {
                return headers.length;
            }

            public Object getElementAt(int index) {
                return headers[index];
            }
        };
        tableModel = new DefaultTableModel(lm.getSize(), 2);

        //Fill Table with values
        try {
            final int headerLinesCnt = headerFooter.getHeaderLinesCount();
            for (int i = 0; i < headerLinesCnt; i++) {
                tableModel.setValueAt(String.valueOf(headerFooter.getHeaderLines(i)), i, 0);
                tableModel.setValueAt(String.valueOf(headerFooter.getFooterLines(i)), i, 1);
            }
        } catch (Exception e1) {
            MainForm.errListModel.add(0, e1.getMessage());
            e1.printStackTrace();
        }

        table = new JTable(this.tableModel);
        TableColumn column1 = table.getTableHeader().getColumnModel().getColumn(0);
        column1.setHeaderValue("Header");
        TableColumn column2 = table.getTableHeader().getColumnModel().getColumn(1);
        column2.setHeaderValue("Footer");
        table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(44);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        //+ table.getRowMargin());
        //+ table.getIntercellSpacing().height);
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        scrollPanel.setViewportView(table);
        scrollPanel.setRowHeaderView(rowHeader);


    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogHeaderFooter dialog = new DialogHeaderFooter();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    private void createUIComponents() {
        // TODO: place custom component creation code here
    }


}