import com.datecs.fiscalprinter.SDK.FiscalErrorCodesV2;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdConfig;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdPinpad;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.IOException;

import static com.datecs.fiscalprinter.SDK.FiscalErrorCodesV2.*;
import static com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt.PaymentType.*;
import static connectivity.SerialPrinterConnector.getConnectedFD;

public class DialogPinpadDemo extends JDialog {
    private JPanel contentPane;

    private JButton buttonCancel;
    private JButton btnSale;

    private JButton btnPay;
    private JButton btnPainpadEndOfDay;
    private JButton btnCloseAll;
    private JComboBox cbxPaymentType;
    private JLabel lbSTL;

    private JProgressBar pbTransaction;
    private JTextField edAmount;

    private JComboBox cbxPinpadReceiptCopies;
    private JComboBox cbxPinpadReceiptInfo;
    private JCheckBox chkPrintAfterPayment;
    private JCheckBox chkPrintAfterClosing;
    private JCheckBox chkPinpadShortReceipt;

    private JButton btnTestPinpad;
    private JButton btnTestServer;
    private JButton btnPinpadConfig;
    private JButton btnSetPinpadDateTime;

    private JButton btnPrintPpDocCopy;
    private JButton btnVoidTransaction;
    private JComboBox cbxCopyPpDoc;
    private JTextField edDocToCopyNumber;
    private JTextField edVoidAmount;
    private JComboBox cbxPaymentToVoid;
    private JTextField edVoidAC;
    private JTextField edVoidRRN;
    private JCheckBox cbxMakeSaleFromPinpad;


    private cmdReceipt.FiscalReceipt fiscalReceipt;
    private cmdReceipt.FiscalSale testSale = new cmdReceipt.FiscalReceipt.FiscalSale();
    private cmdPinpad myPinpad = new cmdPinpad();

    public DialogPinpadDemo() {

        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonCancel);

        try {
            //Init
            cbxPaymentType.setSelectedIndex(2);//Debit card
            cbxPinpadReceiptInfo.setSelectedIndex(myPinpad.getPinpadReceiptInfo());
            cbxPinpadReceiptCopies.setSelectedIndex(myPinpad.getPinpadReceiptCopies());
            chkPinpadShortReceipt.setSelected(myPinpad.getPinpadShortRec());
            lbSTL.setText(String.format("%.2f", (new cmdReceipt.FiscalTransaction().getNotPaid())));

            cbxPaymentToVoid.removeAllItems();
            switch (myPinpad.getPinpadType()) {
                case BORICA:
                    cbxPaymentToVoid.addItem("7  - Return with money");
                    cbxPaymentToVoid.addItem("13 - Return with points");
                    edVoidAC.setEnabled(true);
                    edVoidRRN.setEnabled(true);
                    break;
                case UBB:
                    cbxPaymentToVoid.addItem("16 - Return with AC number");
                    cbxPaymentToVoid.addItem(" 17 - Return with receipt number");
                    break;

                case DSK:
                    cbxPaymentToVoid.addItem("16 - Return with money");
                    break;
            }
        } catch (Exception e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }


        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        btnSale.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String salePoint = "1"; //Number of point of sale from 1...99999;
                String NSale; //Unique sale number (21 chars "LLDDDDDD-CCCC-DDDDDDD"
                try {
                    fiscalReceipt = new cmdReceipt.FiscalReceipt();
                    if (!fiscalReceipt.isOpen()) { //Open new fiscal receipt
                        //Note: WP-500X, WP-50X, WP-25X, DP-25X, DP-150X, DP-05C: the default password for each operator is
                        //equal to the corresponding number (for example, for Operator1 the password is "1") .
                        //FMP-350X, FMP-55X, FP-700X: the default password for each operator is "0000"
                        int operatorCode = Integer.parseInt(DatecsFiscalDevice.getConnectedModelV2().getCurrentOpCode());
                        if (operatorCode < 1) operatorCode = 1;
                        //String operatorPassword =  myFiscalDevice.getConnectedModelV2().getDefaultOpPass();
                        //Password of operator. Text up to 8 symbols. ( Require Service jumper )
                        String operatorPassword = new cmdInfo().GetOperPasw(operatorCode - 1);
                        //Open Fiscal bon in current receipt
                        //Creating the unique sale number "LLDDDDDD-CCCC-DDDDDDD"
                        NSale = new com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo().GetDeviceSerialNumber() + "-" +
                                String.format("%04d", operatorCode) + "-" + // Pad left with trailing zero
                                String.format("%07d", Integer.parseInt(fiscalReceipt.getAllreceipt()));  //Next Document number pad left with trailing zero

                        //Open Fiscal bon in current receipt and return number of receipt
                        fiscalReceipt.openFiscalReceipt(
                                String.valueOf(operatorCode),
                                operatorPassword,
                                NSale,
                                salePoint,
                                false);
                    }
                    //Registration of item for sale with the minimum required set of parameters
                    testSale.add("Прясно мляко", "2", "1", "0.01", "1", cmdReceipt.FiscalSale.DiscountType.noDiscount, "");
                    lbSTL.setText(String.valueOf(testSale.readSubtotal(false, cmdReceipt.FiscalSale.DiscountType.noDiscount, "0.00")));

                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                } finally {
                    try {
                        Double owedSum = new cmdReceipt.FiscalTransaction().getNotPaid();
                        edAmount.setText(String.valueOf(owedSum));
                        lbSTL.setText(String.valueOf(owedSum));
                    } catch (Exception exception) {
                        MainForm.errListModel.add(0, exception.getMessage());
                        exception.printStackTrace();
                    }

                }

            }
        });

        btnCloseAll.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    closeAll();
                    lbSTL.setText(String.format("%.2f", new cmdReceipt.FiscalTransaction().getNotPaid()));
                    edAmount.setText("");
                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
         btnPay.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //TOTAL
                btnEnable(false);
                pbTransaction.setIndeterminate(true);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        // do the thing that takes a long time
                        try {
                            if (cbxMakeSaleFromPinpad.isSelected()) {
                                makeSaleFromPinpad();
                                return;
                            }
                            testSale.saleTotal(cmdReceipt.PaymentType.values()[cbxPaymentType.getSelectedIndex()], edAmount.getText());
                            //С карта ли е плащането
                            if (cmdReceipt.PaymentType.values()[cbxPaymentType.getSelectedIndex()] == debit_card) {
                                printAndClose();   //If the payment was successful,
                            } else fiscalReceipt.closeFiscalReceipt(); //Command 56

                            SwingUtilities.invokeLater(new Runnable() {
                                public void run() {
                                    pbTransaction.setIndeterminate(false);
                                }
                            });
                        } catch (Exception e) {
                            MainForm.errListModel.add(0, e.getMessage());

                            if (e.getMessage().contains(String.valueOf(ERR_PINPAD_FP_TRANS))) //ERR_PINPAD_FP_TRANS = -111560; // Correct 111558
                                returnTransaction(e.getMessage());
                            e.printStackTrace();
                        } finally {
                            pbTransaction.setIndeterminate(false);
                            try {
                                btnEnable(true);
                                lbSTL.setText(String.format("%.2f", new cmdReceipt.FiscalTransaction().getNotPaid()));
                                edAmount.setText(lbSTL.getText());
                            } catch (Exception exception) {
                                MainForm.errListModel.add(0, exception.getMessage());
                                exception.printStackTrace();
                            }
                        }
                    }
                }).start();

            }
        });

        btnPainpadEndOfDay.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                   myPinpad.endOfDayReport();
                } catch (Exception exception) {
                    exception.printStackTrace();
                    MainForm.errListModel.add(0, exception.getMessage());
                }
            }
        });

        cbxPinpadReceiptCopies.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    myPinpad.setPinpadReceiptCopies(cbxPinpadReceiptCopies.getSelectedIndex());
                } catch (Exception exception) {
                    MainForm.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });

        cbxPinpadReceiptInfo.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    myPinpad.setPinpadReceiptInfo(cbxPinpadReceiptInfo.getSelectedIndex());
                } catch (Exception exception) {
                    MainForm.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });

        chkPinpadShortReceipt.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    myPinpad.setPinpadShortRec(chkPinpadShortReceipt.isSelected());
                } catch (Exception exception) {
                    MainForm.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });

        btnTestPinpad.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    //'9'  - Check connection with Pinpad;
                    if (myPinpad.checkPinpadConnection())
                        MainForm.errListModel.add(0, "Pinpad is connected ...");

                } catch (Exception exception) {
                    MainForm.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });

        btnTestServer.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //'10' - Check connection with server;
                try {
                    if (myPinpad.CheckPinpadServerConnection())
                        MainForm.errListModel.add(0, "Bank server is OK !");
                } catch (Exception exception) {
                    MainForm.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });
        btnPinpadConfig.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPinpadConfig dialog = null;
                try {
                    dialog = new DialogPinpadConfig();
                    dialog.setPreferredSize(new Dimension(600, 300));
                    dialog.pack();
                    dialog.setTitle("Pinpad configuration...");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnSetPinpadDateTime.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                StringBuilder sQuestion = new StringBuilder("The pinpad time will be changed?\n\r");
                try {
                    sQuestion.append("Current time in the fiscal device: " + new cmdConfig.DateTime().getDateTime());
                } catch (Exception ex) {
                    ex.printStackTrace();
                    MainForm.errListModel.add(0, ex.getMessage());
                }
                sQuestion.append("\nAre you sure you want to set same time in the pinpad ?");
                int dialogResult = JOptionPane.showConfirmDialog(getParent(), sQuestion, "Synchronize the pinpad date and time...", JOptionPane.YES_NO_OPTION);
                if (dialogResult == 0) {
                    pbTransaction.setIndeterminate(true);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            // do the thing that takes a long time
                            try {
                                myPinpad.setPinpadDateTime(new cmdConfig.DateTime().getDateTime());
                                MainForm.errListModel.add(0, "Pinpad data  time was changed...");

                            } catch (Exception e) {
                                MainForm.errListModel.add(0, e.getMessage());
                                e.printStackTrace();
                            } finally {
                                pbTransaction.setIndeterminate(false);
                            }
                        }
                    }).start();

                } else {

                }


            }
        });


        btnPrintPpDocCopy.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                pbTransaction.setIndeterminate(true);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        // do the thing that takes a long time
                        try {
                            myPinpad.printCopyTransactionDocument(cmdPinpad.DocTypeToCopy.values()[cbxCopyPpDoc.getSelectedIndex()], edDocToCopyNumber.getText());
                        } catch (Exception ex) {
                            MainForm.errListModel.add(0, ex.getMessage());
                            ex.printStackTrace();
                        } finally {
                            pbTransaction.setIndeterminate(false);
                        }
                    }
                }).start();
            }
        });
        btnVoidTransaction.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                pbTransaction.setIndeterminate(true);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        int i;
                        // do the thing that takes a long time
                        try {

                            switch (myPinpad.getPinpadType()) {
                                case BORICA:
                                    i = 7 + 6 * cbxPaymentToVoid.getSelectedIndex();
                                    myPinpad.voidTransactionBorica(String.valueOf(i), Double.valueOf(edVoidAmount.getText()), edVoidRRN.getText(), edVoidAC.getText());
                                    break;
                                case UBB:
                                    i = 16 + cbxPaymentToVoid.getSelectedIndex();
                                    myPinpad.voidTransactionUBB(String.valueOf(i), Double.valueOf(edVoidAmount.getText()), "");
                                    break;
                                case DSK:
                                    myPinpad.voidTransactionDSK(Double.valueOf(edVoidAmount.getText()));
                                    break;

                            }


                        } catch (Exception ex) {
                            MainForm.errListModel.add(0, ex.getMessage());
                            ex.printStackTrace();
                        } finally {
                            pbTransaction.setIndeterminate(false);
                        }
                    }
                }).start();
            }
        });

        cbxMakeSaleFromPinpad.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                btnSale.setEnabled(e.getStateChange() != ItemEvent.SELECTED);
                cbxPaymentType.setEnabled(e.getStateChange() != ItemEvent.SELECTED);
            }
        });

    }


    /**
     * @throws IOException
     * @throws FiscalException
     */
    private void makeSaleFromPinpad() throws IOException, FiscalException {

        Double amount = Double.valueOf(edAmount.getText());
        cmdPinpad.PurchaseResult res = myPinpad.makePurchase(amount);
        StringBuilder message = new StringBuilder();
        message.append("Authorization code for transaction :" + res.getAC() + "\n\r");
        message.append("Type of card payment :" + res.getTransType() + "\n\r");
        message.append("Card number :" + res.getCardNumber() + "\n\r");
        message.append("Merchant ID :" + res.getMIDNumber() + "\n\r");
        message.append("RRN number for transaction :" + res.getRRN() + "\n\r");
        message.append("Terminal ID :" + res.getTIDNumber() + "\n\r");
        message.append("Transaction date time :" + res.getTransDate() + " " + res.getTransTime() + "\n\r");
        message.append("Transaction number :" + res.getTransNumber() + "\n\r");
        message.append("Transaction status :" + res.getTransStatus() + "\n\r");
        message.append("Transaction type :" + res.getTransType() + "\n\r");
        message.append("Complete response code :" + res.getFulLResponseCode() + "\n\r");

        JOptionPane.showMessageDialog(getParent(), message);
        //Set to copy this document
        edDocToCopyNumber.setText(res.getTransNumber());
        cbxCopyPpDoc.setSelectedIndex(3);
        //Set to void this document
        edVoidAC.setText(res.getAC());
        edVoidAmount.setText(res.getTransAmount());
        edVoidRRN.setText(res.getRRN());

    }


    /**
     * If the payment was successful,
     * the relevant fiscal and the transaction receipt are printed.
     * The fiscal document for the purchase is closed.
     *
     * @throws Exception
     */
    private void printAndClose() throws Exception {
        if (chkPrintAfterPayment.isSelected())
            myPinpad.printTransactionReceipt();
        fiscalReceipt.closeFiscalReceipt();
        if (chkPrintAfterClosing.isSelected())
            myPinpad.printTransactionReceipt(); //Print Copies
    }

    /**
     * Used when command 53( paying with pinpad ) and command 55 ( option 14 )
     * returns error along with sum and last digits of card number
     *
     * @param message
     */
    private void returnTransaction(String message) {

        String sQuestion = String.format(
                message + "\n\r"
                        + "Pinpad error: Unknown result of the transaction between fiscal device and PinPad\n\r" +
                        "YES - Print receipt \n\r" +
                        "No  - VOID Transaction\n\r" +
                        "Cancel - Exit operation\n\r");
        try {
            int dialogResult = JOptionPane.showConfirmDialog(getParent(), sQuestion, "Transaction error...", JOptionPane.YES_NO_CANCEL_OPTION);
            if (dialogResult == JOptionPane.CANCEL_OPTION) return;
                myPinpad.returnTransaction(dialogResult == JOptionPane.YES_OPTION);

        } catch (Exception e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
            returnTransaction(message); // case of unsuccessful void of transaction
        }

    }

    private void btnEnable(boolean val) {
        btnSale.setEnabled(val);
        btnPay.setEnabled(val);
        btnCloseAll.setEnabled(val);
        btnPainpadEndOfDay.setEnabled(val);
        btnPinpadConfig.setEnabled(val);

    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogPinpadDemo dialog = new DialogPinpadDemo();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    /**
     * This method attempts to refuse a fiscal or non-fiscal receipt.
     * And if there is a startup payment on the amount and it is not fully paid,
     * it issues a payment message.
     */
    private void closeAll() throws Exception {
        cmdReceipt.FiscalReceipt fiscalReceipt = new cmdReceipt.FiscalReceipt();
        cmdReceipt.FiscalReceipt.NonFiscalReceipt noFiscalReceipt = new cmdReceipt.FiscalReceipt.NonFiscalReceipt();
        if (noFiscalReceipt.isOpen()) {
            noFiscalReceipt.closeNonFiscalReceipt();
            return;
        }
        if (fiscalReceipt.isOpen()) tryToCloseFiscalReceipt(fiscalReceipt);
    }

    private void tryToCloseFiscalReceipt(cmdReceipt.FiscalReceipt thisReceipt) throws Exception {

        final Double owedSum;//owedSum=Amount-Tender
        owedSum = new cmdReceipt.FiscalTransaction().getNotPaid();
        Double payedSum = new cmdReceipt.FiscalTransaction().getPaid();
        Double amount = new cmdReceipt.FiscalTransaction().getAmount();
        if (amount == 0.00) {
            //If items has add to document with 0.00 amount or no Items in Document
            thisReceipt.cancel();
            return;
        }
        int dialogResult = -1;
        //If a TOTAL in the opened receipt has not been set, it will closed or canceled
        if (payedSum == 0.0) {
            dialogResult = JOptionPane.showConfirmDialog(getParent(), "No payment started on this receipt,\n\n" +
                    "Yes-Pay the whole amount,No-Cancel receipt", "Close receipt?", JOptionPane.YES_NO_OPTION);
            if (dialogResult == 0) {
                payFull();
                closeFiscalDocument(thisReceipt);
            }
            if (dialogResult == 1)
                thisReceipt.cancel();
            return;
        }
        //If a TOTAL is set with a partial payment, there is a Amount and Tender is positive.
        //Offer payment of the amount and completion of the sale.
        if (owedSum > 0.0) {
            String sQuestion = String.format("Payment has already started.\n\r" +
                    "Do you want to pay the owed sum: %.2f -and close it?", owedSum);
            dialogResult = JOptionPane.showConfirmDialog(getParent(), sQuestion, "Cancel receipt", JOptionPane.YES_NO_OPTION);
            if (dialogResult == 0) {
                payFull();
                closeFiscalDocument(thisReceipt);
            } else {
                thisReceipt.cancel();
            }
        } else {
            //If a TOTAL is set with a full payment, there is a Amount-Tender=0.
            //All is OK, completion of the sale!
            closeFiscalDocument(thisReceipt);
        }


    }

    private void closeFiscalDocument(cmdReceipt.FiscalReceipt thisReceipt) throws Exception {
        try {
            thisReceipt.closeFiscalReceipt();
        } catch (FiscalException e) {
            if (e.getErrorCode() == FiscalErrorCodesV2.ERR_R_WRONG_BUYERS_DATA) {
                DialogClientInfo dialog = new DialogClientInfo();
                if (dialog.doModal() == dialog.ID_OK) dialog.getClientInfo().saveClientInfo();
            }
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
    }

    private void payFull() throws Exception {
        //TOTAL
        new cmdReceipt.FiscalSale().saleTotal(cash, "");
    }


}
