import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdConfig;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;

import javax.swing.*;
import java.awt.event.*;
import java.util.ArrayList;

public class DialogPrintConfig extends JDialog {
    private int printerColSettings = 0;
    private JPanel contentPane;
    private JButton btnSaveAll;
    private JButton buttonCancel;
    private JComboBox cbx_PrintContrast;
    private JComboBox cbx_PrintColumns;
    private JComboBox cbx_BarcodeHeight;
    private JComboBox cbx_RecType;
    private JComboBox cbx_PowerOff;
    private JComboBox cbx_DisplayBacklight;
    private JCheckBox chbx_printReceiptDuplicate;
    private JCheckBox chbx_condensedPrint;
    private JCheckBox chbx_printSumInAlternative;
    private JCheckBox chbx_printExchangeRate;
    private JCheckBox chbx_printLogo;
    private JCheckBox chbx_printPLUBarcodeIn;
    private JCheckBox chbx_openDrawerOnEvery;
    private JCheckBox chbx_printEmptyLine;
    private JCheckBox chbx_printDepartmentName;
    private JCheckBox chbx_nearPaperEndAlert;
    private JCheckBox chbx_printVATRatesIn;
    private JCheckBox chbx_zReportGroupReport;
    private JCheckBox chbx_zReportEcrReport;
    private JCheckBox chbx_zReportClearPLU;
    private JTextField edCurrencyLocal;
    private JTextField edExchangeRate;
    private JTextField edCurrencyForeign;
    private JTextField edInvoiceIntervalStart;
    private JTextField edInvoiceIntervalEnd;
    private JButton btnSetInterval;
    private JLabel labNextIvoiceNumber;
    private final cmdConfig myPrintConfig = new cmdConfig();

    public DialogPrintConfig() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonCancel);

        //Init Print Columns Combo box, тhe values ​​are different for device models
        String[] items = myPrintConfig.GetPrintColumnsSupported();
        cbx_PrintColumns.setModel(new DefaultComboBoxModel(items));
        //Init Barcode Height Combo box  - Barcode height from '1' (7mm) to '10' (70mm);
        items = new String[10];//
        for (int i = 0; i < 10; i++) items[i] = ((i + 1) * 7) + " mm";
        cbx_BarcodeHeight.setModel(new DefaultComboBoxModel(items));

        //Init AutoPowerOff Combo box
        items = new String[16];//
        items[0] = "disable";
        for (int i = 1; i < 16; i++) items[i] = i + " minutes";
        cbx_PowerOff.setModel(new DefaultComboBoxModel(items));

        //Init BkLightAutoOff Combo box
        items = new String[6];//
        items[0] = "disable";
        for (int i = 1; i < 6; i++) items[i] = i + " minutes";
        cbx_DisplayBacklight.setModel(new DefaultComboBoxModel(items));

        //Init Check boxes
        try {

            cbx_PrintContrast.setSelectedIndex(myPrintConfig.GetPrnQuality()); // Contrast of Printing ( from 0 to 20 );
            // If not changed, D'not save this item
            printerColSettings = myPrintConfig.GetPrintColumns();
            cbx_PrintColumns.setSelectedItem(String.valueOf(printerColSettings));
            cbx_PowerOff.setSelectedIndex(myPrintConfig.GetAutoPowerOff()); //0-15
            cbx_DisplayBacklight.setSelectedIndex(myPrintConfig.GetBkLightAutoOff() - 1); //1-5
            chbx_printPLUBarcodeIn.setSelected(myPrintConfig.GetBarcodePrint());
            chbx_printLogo.setSelected(myPrintConfig.GetLogoPrint());
            chbx_printSumInAlternative.setSelected(myPrintConfig.GetForeignPrint() > 0);
            chbx_printExchangeRate.setSelected(myPrintConfig.GetForeignPrint() == 2);
            cbx_RecType.setSelectedIndex(myPrintConfig.GetEcrExtendedReceipt() ? 1 : 0);
            cbx_BarcodeHeight.setSelectedIndex(myPrintConfig.GetBarcodeHeight() - 1); //'1' (7mm) to '10' (70mm);
            chbx_condensedPrint.setSelected(myPrintConfig.GetCondensedPrint());
            chbx_printReceiptDuplicate.setSelected(myPrintConfig.GetDuplicateRec());
            chbx_printVATRatesIn.setSelected(myPrintConfig.GetVatPrint());
            chbx_nearPaperEndAlert.setSelected(myPrintConfig.GetNearPaperEndEnabled());
            chbx_printDepartmentName.setSelected(myPrintConfig.GetDoveritelPrint());
            chbx_printEmptyLine.setSelected(myPrintConfig.GetEmptyLineAfterTotal());
            chbx_zReportClearPLU.setSelected(myPrintConfig.GetEcrPluDailyClearing());
            chbx_openDrawerOnEvery.setSelected(myPrintConfig.GetEcrSafeOpening());
            chbx_zReportGroupReport.setSelected(myPrintConfig.GetEcrConnectedGroupsReport());
            chbx_zReportEcrReport.setSelected(myPrintConfig.GetEcrConnectedCashReport());
            edCurrencyLocal.setText(new cmdInfo().GetCurrNameLocal());
            edCurrencyForeign.setText(new cmdInfo().GetCurrNameForeign());
            edExchangeRate.setText(new cmdInfo().GetExchangeRate());
            btnSaveAll.setEnabled(true);
            //Set the invoice interval
            ArrayList<String> intervalInfo = new cmdConfig().GetInvoiceInterval();
            edInvoiceIntervalStart.setText(intervalInfo.get(0));
            edInvoiceIntervalEnd.setText(intervalInfo.get(1));
            labNextIvoiceNumber.setText("Next Invoice: " + intervalInfo.get(2)); //Nr

    } catch(
    Exception e)

    {
        MainForm.errListModel.add(0, e.getMessage());
        e.printStackTrace();

    }


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        btnSaveAll.addActionListener(new

    ActionListener() {
        public void actionPerformed (ActionEvent e){
            SaveAllSettings();
        }
    });

        buttonCancel.addActionListener(new

    ActionListener() {
        public void actionPerformed (ActionEvent e){
            onCancel();
        }
    });

    // call onCancel() when cross is clicked
    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);

    addWindowListener(new WindowAdapter() {
        public void windowClosing (WindowEvent e){
            onCancel();
        }
    });

    // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new

    ActionListener() {
        public void actionPerformed (ActionEvent e){
            onCancel();
        }
    },KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE,0),JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        contentPane.addComponentListener(new

    ComponentAdapter() {
    });


        contentPane.addMouseMotionListener(new

    MouseMotionAdapter() {
        @Override
        public void mouseDragged (MouseEvent e){
            super.mouseDragged(e);
            btnSaveAll.setEnabled(true);
        }
    });
        btnSetInterval.addActionListener(new

    ActionListener() {
        @Override
        public void actionPerformed (ActionEvent e){
            cmdConfig myConfig = new cmdConfig();
            try {
                ArrayList<String> invoiceInterval = myConfig.GetInvoiceInterval();

                if (Integer.valueOf(invoiceInterval.get(1)) < Integer.valueOf(invoiceInterval.get(2))) {
                    //If the current invoice counter have reached the end of the interval.
                    myConfig.SetInvoiceInterval(edInvoiceIntervalStart.getText(), edInvoiceIntervalEnd.getText());
                } else // Extend of interval
                    myConfig.SetExInvoiceInterval(edInvoiceIntervalEnd.getText());
            } catch (Exception ex) {
                ex.printStackTrace();
                MainForm.errListModel.add(0, ex.getMessage());
            }
        }
    });
}

    private void SaveAllSettings() {
        try {

            myPrintConfig.SetPrnQuality(cbx_PrintContrast.getSelectedItem().toString());
            int newPrinterColSettings = Integer.valueOf((String) cbx_PrintColumns.getSelectedItem());
            if (newPrinterColSettings != printerColSettings)     //Save Number of printer columns will restart device !!!
                myPrintConfig.SetPrintColumns(newPrinterColSettings);
            myPrintConfig.SetBarcodePrint(chbx_printPLUBarcodeIn.isSelected());
            myPrintConfig.SetLogoPrint(chbx_printLogo.isSelected());
            myPrintConfig.SetAutoPowerOff(cbx_PowerOff.getSelectedIndex());//0 - disable; from 1 minute to 15 minutes );
            myPrintConfig.SetBkLightAutoOff(cbx_DisplayBacklight.getSelectedIndex() + 1);

            int jorkaLogic = -1;
            if (chbx_printSumInAlternative.isSelected() && chbx_printExchangeRate.isSelected()) {
                jorkaLogic = 2;
            } else if (chbx_printSumInAlternative.isSelected() && (!chbx_printExchangeRate.isSelected())) {
                jorkaLogic = 1;
            } else if (!chbx_printSumInAlternative.isSelected()) {
                jorkaLogic = 0;
            }
            myPrintConfig.SetForeignPrint(jorkaLogic);
            myPrintConfig.SetEcrExtendedReceipt(cbx_RecType.getSelectedIndex() == 1);
            myPrintConfig.SetCondensedPrint(chbx_condensedPrint.isSelected());
            myPrintConfig.SetVatPrintEnable(chbx_printVATRatesIn.isSelected());
            myPrintConfig.SetDuplicateRec(chbx_printReceiptDuplicate.isSelected());
            myPrintConfig.SetNearPaperEndEnabled(chbx_nearPaperEndAlert.isSelected());
            myPrintConfig.SetDoveritelPrint(chbx_printDepartmentName.isSelected());
            myPrintConfig.SetEmptyLineAfterTotal(chbx_printEmptyLine.isSelected());
            myPrintConfig.SetBarcodeHeight(cbx_BarcodeHeight.getSelectedIndex() + 1); //Barcode height from '1' (7mm) to '10' (70mm);
            myPrintConfig.SetEcrSafeOpening(chbx_openDrawerOnEvery.isSelected());
            myPrintConfig.SetEcrConnectedGroupsReport(chbx_zReportGroupReport.isSelected());
            myPrintConfig.SetEcrConnectedCashReport(chbx_zReportEcrReport.isSelected());
            myPrintConfig.SetEcrPluDailyClearing(chbx_zReportClearPLU.isSelected());
            myPrintConfig.SetCurrNameLocal(edCurrencyLocal.getText());
            myPrintConfig.SetCurrNameForeign(edCurrencyForeign.getText());
            myPrintConfig.SetExchangeRate(edExchangeRate.getText());
            btnSaveAll.setEnabled(false);

        } catch (Exception e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogPrintConfig dialog = new DialogPrintConfig();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
