import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdService;

import javax.swing.*;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

public class DialogVAT extends JDialog implements TableModelListener {
    private final JTable table;
    private final DefaultTableModel initialTable;
    private JPanel contentPane;
    private JButton btnSaveVAT;
    private JButton buttonCancel;
    private JScrollPane scrlPane;
    private JComboBox cbxDecimals;

    public DialogVAT() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnSaveVAT);


        btnSaveVAT.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (table.isEditing())
                    table.getCellEditor().stopCellEditing();
                initialTable.fireTableDataChanged();

                try {
                    List<String> vatValue = new ArrayList<>(8);
                    for (int i = 0; i < 8; i++) {
                        vatValue.add(String.valueOf(initialTable.getValueAt(i, 1)));
                        JRadioButton dd = (JRadioButton) initialTable.getValueAt(i, 0);
                        if (!dd.isSelected()) vatValue.set(i, "100.00");
                    }

                    cmdService.VAT myVATs = new cmdService.VAT();
                    myVATs.setDecimalPoint(String.valueOf( 2 * cbxDecimals.getSelectedIndex())); //Init Decimals !!!
                    String remChanges = String.valueOf(myVATs.setVatRates(vatValue));

                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);


        List<Boolean> isVATOn = isEnabledVAT();
        List<String> vatValue = readVatVal();// Call First !!!
        cbxDecimals.setSelectedIndex(getDecimalPlace()/2); //value 0 or 2 - to index 0,1
        initialTable = new DefaultTableModel();

        initialTable.setDataVector(
                new Object[][]{
                        {new JRadioButton("A", isVATOn.get(0)), vatValue.get(0)},
                        {new JRadioButton("B", isVATOn.get(1)), vatValue.get(1)},
                        {new JRadioButton("C", isVATOn.get(2)), vatValue.get(2)},
                        {new JRadioButton("D", isVATOn.get(3)), vatValue.get(3)},
                        {new JRadioButton("E", isVATOn.get(4)), vatValue.get(4)},
                        {new JRadioButton("F", isVATOn.get(5)), vatValue.get(5)},
                        {new JRadioButton("G", isVATOn.get(6)), vatValue.get(6)},
                        {new JRadioButton("H", isVATOn.get(7)), vatValue.get(7)}
                },
                new Object[]{"TAX rates", "TAX Value"});
        table = new JTable(initialTable) {
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                repaint();
            }
        };

        table.getColumn("TAX rates").setCellRenderer(new RadioButtonRenderer());
        table.getColumn("TAX rates").setCellEditor(new RadioButtonEditor(new JCheckBox()));
        table.getModel().addTableModelListener(this);
        scrlPane.setViewportView(table);

    }

    private int getDecimalPlace() {
        Integer dec = null;
        try {
            dec = Integer.valueOf(new cmdService.VAT().getDecimals());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dec;
    }

    private List<Boolean> isEnabledVAT() {
        cmdService.VAT myVATS = new cmdService.VAT();
        List<Boolean> vatsOn = null;
        try {
            vatsOn = myVATS.getVatEnabled();
        } catch (Exception e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
        return vatsOn;

    }

    private List<String> readVatVal() {
        List<String> res = null;
        try {
            cmdService.VAT myVATS = new cmdService.VAT();
            res = myVATS.getVatRates();
        } catch (Exception e) {

            MainForm.errListModel.add(0, e.getMessage());
        }
        for (int i = 0; i < 8; i++) {
            if (Double.valueOf(res.get(i)) > 99.99) res.set(i, "Disabled");
        }
        return res;
    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogVAT dialog = new DialogVAT();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        DefaultTableModel model = (DefaultTableModel) e.getSource();
        String columnName = model.getColumnName(column);
        //Object data = model.getValueAt(row, column);
        JRadioButton dd = null;
        if (columnName.equals("TAX rates")) {
            dd = (JRadioButton) model.getValueAt(row, column);
            String val;
            if (dd.isSelected()) val = "0.00";
            else val = "Disabled";
            model.setValueAt(val, row, column + 1);
        }

    }


    class RadioButtonEditor extends DefaultCellEditor
            implements ItemListener {
        private JRadioButton button;

        public RadioButtonEditor(JCheckBox checkBox) {
            super(checkBox);
        }

        public Component getTableCellEditorComponent(JTable table, Object value,
                                                     boolean isSelected, int row, int column) {
            if (value == null) return null;
            button = (JRadioButton) value;
            button.addItemListener(this);
            return (Component) value;
        }

        public Object getCellEditorValue() {
            button.removeItemListener(this);
            return button;
        }

        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    class RadioButtonRenderer implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) return null;
            return (Component) value;
        }
    }


}
